/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.ECC;
import com.phaos.math.BigInt;
import com.phaos.math.BinaryFieldValue;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;
import java.io.IOException;
import java.io.InputStream;

public class BinaryField
extends Field {
    private int m;
    private ASN1ObjectID basisType;
    private int k;
    private int k_1;
    private int k_2;
    private int k_3;
    private ASN1Sequence contents = null;

    BinaryField() {
    }

    public BinaryField(int n, int n2) {
        this.m = n;
        this.basisType = ECC.TPB;
        this.k = n2;
        int[] nArray = new int[3];
        nArray[0] = n;
        nArray[1] = n2;
        this.modulus = new BinaryFieldValue(nArray);
    }

    public BinaryField(int n, int n2, int n3, int n4) {
        this.m = n;
        this.basisType = ECC.PPB;
        this.k_1 = n2;
        this.k_2 = n3;
        this.k_3 = n4;
        int[] nArray = new int[5];
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        this.modulus = new BinaryFieldValue(nArray);
    }

    public BinaryField(BigInt bigInt) {
        this.initialize(ECC.BINARY_FIELD, bigInt);
    }

    public BinaryField(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public FieldElement createFieldElement(BigInt bigInt) {
        return new FieldElement(this, new BinaryFieldValue(bigInt));
    }

    public FieldElement createFieldElement(String string) {
        return new FieldElement(this, new BinaryFieldValue(string));
    }

    public FieldElement createFieldElement(byte[] byArray) {
        return new FieldElement(this, new BinaryFieldValue(byArray));
    }

    public FieldElement createFieldElement(int[] nArray) {
        return new FieldElement(this, new BinaryFieldValue(nArray));
    }

    public ASN1Object getBasisType() {
        return this.basisType;
    }

    public int getBitLength() {
        return this.m;
    }

    public ASN1ObjectID getFieldType() {
        return ECC.BINARY_FIELD;
    }

    public int getK() {
        return this.k;
    }

    public int getK_1() {
        return this.k_1;
    }

    public int getK_2() {
        return this.k_2;
    }

    public int getK_3() {
        return this.k_3;
    }

    public int getM() {
        return this.m;
    }

    protected void initialize(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) throws IOException {
        block6: {
            if (!aSN1ObjectID.equals(ECC.BINARY_FIELD)) {
                throw new IllegalArgumentException("Wrong binary field type OID" + aSN1ObjectID);
            }
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
                this.m = ((ASN1Integer)aSN1Sequence.elementAt(0)).intValue();
                this.basisType = (ASN1ObjectID)aSN1Sequence.elementAt(1);
                if (this.basisType.equals(ECC.TPB)) {
                    this.k = ((ASN1Integer)aSN1Sequence.elementAt(2)).intValue();
                    int[] nArray = new int[3];
                    nArray[0] = this.m;
                    nArray[1] = this.k;
                    this.modulus = new BinaryFieldValue(nArray);
                    break block6;
                }
                if (this.basisType.equals(ECC.PPB)) {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.elementAt(2);
                    this.k_1 = ((ASN1Integer)aSN1Sequence2.elementAt(0)).intValue();
                    this.k_2 = ((ASN1Integer)aSN1Sequence2.elementAt(1)).intValue();
                    this.k_3 = ((ASN1Integer)aSN1Sequence2.elementAt(2)).intValue();
                    int[] nArray = new int[5];
                    nArray[0] = this.m;
                    nArray[1] = this.k_1;
                    nArray[2] = this.k_2;
                    nArray[3] = this.k_3;
                    this.modulus = new BinaryFieldValue(nArray);
                    break block6;
                }
                throw new IOException("Unknown basis type: " + this.basisType);
            }
            catch (ClassCastException classCastException) {
                throw new ASN1FormatException(classCastException.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ASN1FormatException(indexOutOfBoundsException.toString());
            }
        }
    }

    protected void initialize(ASN1ObjectID aSN1ObjectID, BigInt bigInt) {
        if (!aSN1ObjectID.equals(ECC.BINARY_FIELD)) {
            throw new IllegalArgumentException("Wrong binary field type OID" + aSN1ObjectID);
        }
        this.m = bigInt.bitLength() - 1;
        int n = 1;
        while (n < this.m) {
            if (bigInt.testBit(n)) {
                if (this.k == 0 && this.k_1 == 0) {
                    this.k = n;
                } else if (this.k_2 == 0) {
                    this.k_2 = n;
                    this.k_1 = this.k;
                    this.k = 0;
                } else if (this.k_3 == 0) {
                    this.k_3 = n;
                } else {
                    throw new IllegalArgumentException("Unknown reduction polynomial.");
                }
            }
            ++n;
        }
        if (this.k > 0) {
            this.basisType = ECC.TPB;
            int[] nArray = new int[3];
            nArray[0] = this.m;
            nArray[1] = this.k;
            this.modulus = new BinaryFieldValue(nArray);
        } else {
            this.basisType = ECC.PPB;
            int[] nArray = new int[5];
            nArray[0] = this.m;
            nArray[1] = this.k_1;
            nArray[2] = this.k_2;
            nArray[3] = this.k_3;
            this.modulus = new BinaryFieldValue(nArray);
        }
    }

    public boolean isValidField() {
        if (!this.modulus.isIrreducible()) {
            return false;
        }
        if (this.basisType.equals(ECC.PPB)) {
            int n = this.m / 2;
            while (n > 0) {
                int[] nArray = new int[3];
                nArray[0] = this.m;
                nArray[1] = n--;
                if (!new BinaryFieldValue(nArray).isIrreducible()) continue;
                return false;
            }
        }
        return true;
    }

    public BigInt size() {
        return ECC.ONE.shiftLeft(this.m);
    }

    ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(ECC.BINARY_FIELD);
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(new ASN1Integer(this.m));
            aSN1Sequence2.addElement(this.basisType);
            if (this.basisType.equals(ECC.TPB)) {
                aSN1Sequence2.addElement(new ASN1Integer(this.k));
            } else if (this.basisType.equals(ECC.PPB)) {
                ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
                aSN1Sequence3.addElement(new ASN1Integer(this.k_1));
                aSN1Sequence3.addElement(new ASN1Integer(this.k_2));
                aSN1Sequence3.addElement(new ASN1Integer(this.k_3));
                aSN1Sequence2.addElement(aSN1Sequence3);
            }
            aSN1Sequence.addElement(aSN1Sequence2);
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }
}

