/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.ECC;
import com.phaos.math.BigInt;
import com.phaos.math.BinaryField;
import com.phaos.math.Field;
import com.phaos.math.FieldValue;
import com.phaos.utils.Utils;

public class BinaryFieldValue
extends FieldValue {
    public static final BinaryFieldValue BINARY_ZERO_VALUE = new BinaryFieldValue(ECC.ZERO);
    private static final int[] LB;
    private static final int[] SB;
    private static final int[] sqBox;
    byte[] p;
    int deg;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        LB = nArray;
        SB = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        sqBox = new int[256];
        int n = 255;
        while (n >= 0) {
            int n2 = 0;
            int n3 = 7;
            while (n3 >= 0) {
                if ((n & SB[n3]) != 0) {
                    n2 ^= n << n3;
                }
                --n3;
            }
            BinaryFieldValue.sqBox[n] = n2;
            --n;
        }
    }

    public BinaryFieldValue(BigInt bigInt) {
        this(Utils.toByteArray(bigInt));
    }

    public BinaryFieldValue(String string) {
        BigInt bigInt = ECC.ZERO;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (Character.digit(cArray[n - 1 - n2], 2) == 1) {
                bigInt = bigInt.add(ECC.ONE.shiftLeft(n2));
            }
            --n2;
        }
        this.p = Utils.toByteArray(bigInt);
        this.deg = BinaryFieldValue.degree(this.p);
    }

    public BinaryFieldValue(byte[] byArray) {
        this(byArray, false);
    }

    private BinaryFieldValue(byte[] byArray, boolean bl) {
        this.p = BinaryFieldValue.stripLeadingZeroBytes(byArray, bl);
        this.deg = BinaryFieldValue.degree(this.p);
    }

    public BinaryFieldValue(int[] nArray) {
        BigInt bigInt = ECC.ZERO;
        int n = nArray.length - 1;
        while (n >= 0) {
            bigInt = bigInt.add(ECC.ONE.shiftLeft(nArray[n]));
            --n;
        }
        this.p = Utils.toByteArray(bigInt);
        this.deg = BinaryFieldValue.degree(this.p);
    }

    public FieldValue add(FieldValue fieldValue) {
        return new BinaryFieldValue(Utils.xor(this.p, ((BinaryFieldValue)fieldValue).p), true);
    }

    private static int degree(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n && byArray[n2] == 0) {
            ++n2;
        }
        if (n2 < n) {
            int n3 = 7;
            while (n3 >= 0) {
                if ((byArray[n2] & SB[n3]) != 0) {
                    return (n - n2 - 1 << 3) + n3;
                }
                --n3;
            }
        }
        return -1;
    }

    public FieldValue gcd(FieldValue fieldValue) {
        byte[] byArray = ((BinaryFieldValue)fieldValue).p;
        int n = Math.max(this.p.length, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.p, 0, byArray2, n - this.p.length, this.p.length);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, n - byArray.length, byArray.length);
        while (BinaryFieldValue.degree(byArray3) >= 0) {
            byte[] byArray4 = BinaryFieldValue.mod(byArray2, byArray3);
            System.arraycopy(byArray3, 0, byArray2, 0, n);
            System.arraycopy(byArray4, 0, byArray3, 0, n);
        }
        return new BinaryFieldValue(byArray2, true);
    }

    public int getDegree() {
        return this.deg;
    }

    public boolean isIrreducible() {
        BinaryFieldValue binaryFieldValue = new BinaryFieldValue(new int[]{1});
        BinaryFieldValue binaryFieldValue2 = new BinaryFieldValue(new int[]{1});
        int n = this.deg / 2;
        while (n > 0) {
            if (!this.gcd((BinaryFieldValue)(binaryFieldValue2 = (BinaryFieldValue)binaryFieldValue2.square().mod(this)).add(binaryFieldValue)).isOne()) {
                return false;
            }
            --n;
        }
        return true;
    }

    public FieldValue mod(Field field) {
        int n = ((BinaryField)field).getM();
        if (this.deg < n) {
            return new BinaryFieldValue(this.p);
        }
        byte[] byArray = (byte[])this.p.clone();
        int n2 = this.p.length - 1 - (n >> 3);
        int n3 = ((BinaryField)field).getK();
        if (n3 > 0) {
            byte by;
            int n4 = n - n3 >> 3;
            int n5 = n - n3 & 7;
            int n6 = n >> 3;
            int n7 = n & 7;
            int n8 = 0;
            while (n8 < n2) {
                by = byArray[n8];
                if (by != 0) {
                    int n9 = n4 + 1;
                    byArray[n9] = (byte)(byArray[n9] ^ by << 8 - n5);
                    int n10 = n4;
                    byArray[n10] = (byte)(byArray[n10] ^ (by & 0xFF) >>> n5);
                    int n11 = n6 + 1;
                    byArray[n11] = (byte)(byArray[n11] ^ by << 8 - n7);
                    int n12 = n6;
                    byArray[n12] = (byte)(byArray[n12] ^ (by & 0xFF) >>> n7);
                    byArray[n8] = 0;
                }
                ++n8;
                ++n4;
                ++n6;
            }
            by = (byte)((byArray[n2] & 0xFF) >>> (n & 7));
            if (by != 0) {
                n4 = n3 >> 3;
                n5 = n3 & 7;
                int n13 = this.p.length - 1 - n4;
                byArray[n13] = (byte)(byArray[n13] ^ by << n5);
                int n14 = this.p.length - 2 - n4;
                byArray[n14] = (byte)(byArray[n14] ^ (by & 0xFF) >>> 8 - n5);
                int n15 = this.p.length - 1;
                byArray[n15] = (byte)(byArray[n15] ^ by);
                int n16 = n2;
                byArray[n16] = (byte)(byArray[n16] & LB[n & 7]);
            }
        } else {
            byte by;
            int n17 = ((BinaryField)field).getK_1();
            int n18 = ((BinaryField)field).getK_2();
            int n19 = ((BinaryField)field).getK_3();
            int n20 = n >> 3;
            int n21 = n & 7;
            int n22 = n - n17 >> 3;
            int n23 = n - n17 & 7;
            int n24 = n - n18 >> 3;
            int n25 = n - n18 & 7;
            int n26 = n - n19 >> 3;
            int n27 = n - n19 & 7;
            int n28 = 0;
            while (n28 < n2) {
                by = byArray[n28];
                if (by != 0) {
                    int n29 = n26 + 1;
                    byArray[n29] = (byte)(byArray[n29] ^ by << 8 - n27);
                    int n30 = n26;
                    byArray[n30] = (byte)(byArray[n30] ^ (by & 0xFF) >>> n27);
                    int n31 = n24 + 1;
                    byArray[n31] = (byte)(byArray[n31] ^ by << 8 - n25);
                    int n32 = n24;
                    byArray[n32] = (byte)(byArray[n32] ^ (by & 0xFF) >>> n25);
                    int n33 = n22 + 1;
                    byArray[n33] = (byte)(byArray[n33] ^ by << 8 - n23);
                    int n34 = n22;
                    byArray[n34] = (byte)(byArray[n34] ^ (by & 0xFF) >>> n23);
                    int n35 = n20 + 1;
                    byArray[n35] = (byte)(byArray[n35] ^ by << 8 - n21);
                    int n36 = n20;
                    byArray[n36] = (byte)(byArray[n36] ^ (by & 0xFF) >>> n21);
                    byArray[n28] = 0;
                }
                ++n28;
                ++n26;
                ++n24;
                ++n22;
                ++n20;
            }
            by = (byte)((byArray[n2] & 0xFF) >>> (n & 7));
            if (by != 0) {
                n26 = n19 >> 3;
                n27 = n19 & 7;
                int n37 = this.p.length - 1 - n26;
                byArray[n37] = (byte)(byArray[n37] ^ by << n27);
                int n38 = this.p.length - 2 - n26;
                byArray[n38] = (byte)(byArray[n38] ^ (by & 0xFF) >>> 8 - n27);
                n24 = n18 >> 3;
                n25 = n18 & 7;
                int n39 = this.p.length - 1 - n24;
                byArray[n39] = (byte)(byArray[n39] ^ by << n25);
                int n40 = this.p.length - 2 - n24;
                byArray[n40] = (byte)(byArray[n40] ^ (by & 0xFF) >>> 8 - n25);
                n22 = n17 >> 3;
                n23 = n17 & 7;
                int n41 = this.p.length - 1 - n22;
                byArray[n41] = (byte)(byArray[n41] ^ by << n23);
                int n42 = this.p.length - 2 - n22;
                byArray[n42] = (byte)(byArray[n42] ^ (by & 0xFF) >>> 8 - n23);
                int n43 = this.p.length - 1;
                byArray[n43] = (byte)(byArray[n43] ^ by);
                int n44 = n2;
                byArray[n44] = (byte)(byArray[n44] & LB[n & 7]);
            }
        }
        return new BinaryFieldValue(byArray, true);
    }

    public FieldValue mod(FieldValue fieldValue) {
        return new BinaryFieldValue(BinaryFieldValue.mod(this.p, ((BinaryFieldValue)fieldValue).p), true);
    }

    private static byte[] mod(byte[] byArray, byte[] byArray2) {
        int n = BinaryFieldValue.degree(byArray2);
        int n2 = BinaryFieldValue.degree(byArray);
        int n3 = n >> 3;
        int n4 = n & 7;
        if (n2 < n) {
            return (byte[])byArray.clone();
        }
        byte[][] byArray3 = new byte[8][];
        byte[] byArray4 = (byte[])byArray2.clone();
        int n5 = byArray4.length - n3 - 1;
        byArray4[n5] = (byte)(byArray4[n5] & LB[n4]);
        byArray3[0] = new byte[BinaryFieldValue.degree(byArray4) / 8 + 1];
        System.arraycopy(byArray4, byArray4.length - byArray3[0].length, byArray3[0], 0, byArray3[0].length);
        byArray3[1] = BinaryFieldValue.shiftLeft(byArray3[0], 1);
        byArray3[2] = BinaryFieldValue.shiftLeft(byArray3[0], 2);
        byArray3[3] = BinaryFieldValue.shiftLeft(byArray3[0], 3);
        byArray3[4] = BinaryFieldValue.shiftLeft(byArray3[0], 4);
        byArray3[5] = BinaryFieldValue.shiftLeft(byArray3[0], 5);
        byArray3[6] = BinaryFieldValue.shiftLeft(byArray3[0], 6);
        byArray3[7] = BinaryFieldValue.shiftLeft(byArray3[0], 7);
        byte[] byArray5 = (byte[])byArray.clone();
        int n6 = n2 - n;
        while (n6 >= 0) {
            int n7 = n6 + n;
            if (BinaryFieldValue.testBit(byArray5, n7)) {
                n3 = n6 >> 3;
                n4 = n6 & 7;
                int n8 = byArray5.length - byArray3[n4].length - n3;
                int n9 = 0;
                while (n9 < byArray3[n4].length) {
                    int n10 = n8++;
                    byArray5[n10] = (byte)(byArray5[n10] ^ byArray3[n4][n9]);
                    ++n9;
                }
                int n11 = byArray5.length - 1 - (n7 >> 3);
                byArray5[n11] = (byte)(byArray5[n11] ^ SB[n7 & 7]);
            }
            --n6;
        }
        byte[] byArray6 = new byte[byArray2.length];
        System.arraycopy(byArray5, byArray5.length - byArray2.length, byArray6, 0, byArray2.length);
        return byArray6;
    }

    public FieldValue modInverse(FieldValue fieldValue) {
        int n = ((BinaryFieldValue)fieldValue).p.length;
        int n2 = Math.max(this.p.length, n);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.p, 0, byArray, n2 - this.p.length, this.p.length);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(((BinaryFieldValue)fieldValue).p, 0, byArray2, n2 - n, n);
        byte[] byArray3 = new byte[n2];
        byArray3[n2 - 1] = 1;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        int n3 = this.deg;
        while (n3 != 0) {
            int n4;
            int n5 = n3 - BinaryFieldValue.degree(byArray2);
            if (n5 < 0) {
                System.arraycopy(byArray, 0, byArray5, 0, n2);
                System.arraycopy(byArray2, 0, byArray, 0, n2);
                System.arraycopy(byArray5, 0, byArray2, 0, n2);
                System.arraycopy(byArray3, 0, byArray5, 0, n2);
                System.arraycopy(byArray4, 0, byArray3, 0, n2);
                System.arraycopy(byArray5, 0, byArray4, 0, n2);
                n5 = -n5;
            }
            int n6 = n5 >> 3;
            int n7 = n5 & 7;
            int n8 = 8 - n7;
            int n9 = n4 = n2 - n6 - 1;
            byArray[n9] = (byte)(byArray[n9] ^ byArray2[n2 - 1] << n7);
            int n10 = n4;
            byArray3[n10] = (byte)(byArray3[n10] ^ byArray4[n2 - 1] << n7);
            int n11 = n4 - 1;
            while (n11 >= 0) {
                int n12 = n11;
                byArray[n12] = (byte)(byArray[n12] ^ (byArray2[n6 + n11] << n7 | (byArray2[n6 + 1 + n11] & 0xFF) >>> n8));
                int n13 = n11;
                byArray3[n13] = (byte)(byArray3[n13] ^ (byArray4[n6 + n11] << n7 | (byArray4[n6 + 1 + n11] & 0xFF) >>> n8));
                --n11;
            }
            n3 = BinaryFieldValue.degree(byArray);
            if (n3 != -1) continue;
            throw new ArithmeticException("These two numbers are not relative prime.");
        }
        return new BinaryFieldValue(byArray3, true);
    }

    public FieldValue multiply(FieldValue fieldValue) {
        if (this.p.length == 0 || ((BinaryFieldValue)fieldValue).p.length == 0) {
            return BINARY_ZERO_VALUE;
        }
        byte[][] byArray = new byte[16][];
        byArray[0] = new byte[1];
        byArray[1] = (byte[])((BinaryFieldValue)fieldValue).p.clone();
        byArray[2] = BinaryFieldValue.shiftLeft(byArray[1], 1);
        byArray[3] = Utils.xor(byArray[2], byArray[1]);
        byArray[4] = BinaryFieldValue.shiftLeft(byArray[1], 2);
        byArray[5] = Utils.xor(byArray[4], byArray[1]);
        byArray[6] = Utils.xor(byArray[4], byArray[2]);
        byArray[7] = Utils.xor(byArray[4], byArray[3]);
        byArray[8] = BinaryFieldValue.shiftLeft(byArray[1], 3);
        int n = 9;
        while (n < 16) {
            byArray[n] = Utils.xor(byArray[8], byArray[n - 8]);
            ++n;
        }
        byte[] byArray2 = new byte[this.p.length + byArray[1].length];
        int n2 = (Math.max(this.deg, ((BinaryFieldValue)fieldValue).deg) >> 4) + 1;
        int n3 = 3;
        while (n3 >= 0) {
            int n4 = 0;
            int n5 = n3 << 2;
            while (n4 < n2) {
                int n6 = (this.testBit(n5++) ? 1 : 0) + (this.testBit(n5++) ? 2 : 0) + (this.testBit(n5++) ? 4 : 0) + (this.testBit(n5++) ? 8 : 0);
                byte[] byArray3 = byArray[n6];
                int n7 = byArray2.length - (n4 << 1) - byArray3.length;
                int n8 = n7 + byArray3.length - 1;
                while (n8 >= n7) {
                    int n9 = n8;
                    byArray2[n9] = (byte)(byArray2[n9] ^ byArray3[n8 - n7]);
                    --n8;
                }
                ++n4;
                n5 += 12;
            }
            if (n3 != 0) {
                byArray2 = BinaryFieldValue.shiftLeft(byArray2, 4);
            }
            --n3;
        }
        return new BinaryFieldValue(byArray2, true);
    }

    public FieldValue negate() {
        return new BinaryFieldValue(this.p);
    }

    private static byte[] shiftLeft(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = 8 - n;
        int n4 = (byArray[0] & ~LB[n3]) == 0 ? 0 : 1;
        byte[] byArray2 = new byte[n2 + n4];
        if (n4 == 1) {
            byArray2[0] = (byte)((byArray[0] & 0xFF) >>> n3);
        }
        int n5 = n2 - 2;
        while (n5 >= 0) {
            byArray2[n5 + n4] = (byte)(byArray[n5] << n | (byArray[n5 + 1] & 0xFF) >>> n3);
            --n5;
        }
        byArray2[n2 - 1 + n4] = (byte)(byArray[n2 - 1] << n);
        return byArray2;
    }

    public FieldValue square() {
        int n = this.p.length << 1;
        byte[] byArray = new byte[n];
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = sqBox[this.p[n2 >> 1] & 0xFF];
            byArray[n2--] = (byte)n3;
            byArray[n2] = (byte)(n3 >> 8);
            --n2;
        }
        return new BinaryFieldValue(byArray, true);
    }

    private static byte[] stripLeadingZeroBytes(byte[] byArray, boolean bl) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n && byArray[n2] == 0) {
            ++n2;
        }
        if (!(n2 >= n || bl && n2 <= 0)) {
            byte[] byArray2 = new byte[n - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public FieldValue subtract(FieldValue fieldValue) {
        return this.add(fieldValue);
    }

    public boolean testBit(int n) {
        if (n > this.deg || n < 0) {
            return false;
        }
        return (this.p[this.p.length - 1 - (n >> 3)] & SB[n & 7]) != 0;
    }

    private static boolean testBit(byte[] byArray, int n) {
        if (n > BinaryFieldValue.degree(byArray) || n < 0) {
            return false;
        }
        return (byArray[byArray.length - 1 - (n >> 3)] & SB[n & 7]) != 0;
    }

    public BigInt toBigInt() {
        return new BigInt(1, this.p);
    }
}

