/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.ECException;
import com.phaos.math.EllipticCurve;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;

public abstract class ECPoint {
    protected Field field;
    protected EllipticCurve curve;
    protected FieldElement x;
    protected FieldElement y;
    protected boolean pointAtInfinity = false;
    static final int COMPRESSED = 0;
    static final int UNCOMPRESSED = 1;
    static final int HYBRID = 2;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected ECPoint() {
    }

    protected ECPoint(EllipticCurve ellipticCurve, FieldElement fieldElement, FieldElement fieldElement2) {
        this.curve = ellipticCurve;
        this.field = ellipticCurve.getField();
        this.x = fieldElement;
        this.y = fieldElement2;
    }

    protected ECPoint(EllipticCurve ellipticCurve, byte[] byArray) {
        this.curve = ellipticCurve;
        this.field = ellipticCurve.getField();
        this.fromByteArray(byArray);
    }

    public abstract ECPoint add(ECPoint var1) throws ECException;

    abstract int compressY();

    abstract FieldElement decompressY(FieldElement var1, int var2);

    public abstract ECPoint doubling();

    public boolean equals(Object object) {
        boolean bl = false;
        ECPoint eCPoint = (ECPoint)object;
        if (object != null && object instanceof ECPoint && this.curve.equals(((ECPoint)object).getCurve()) && (bl = this.isPointZero()) == ((ECPoint)object).isPointZero() && !bl) {
            bl = this.x.equals(eCPoint.x) && this.y.equals(eCPoint.y);
        }
        return bl;
    }

    private void fromByteArray(byte[] byArray) {
        byte by;
        int n = (this.field.getBitLength() + 7) / 8;
        byte by2 = by = byArray.length == 0 ? (byte)0 : byArray[0];
        if (by == 0 && byArray.length <= 1) {
            this.pointAtInfinity = true;
        } else {
            if (by == 2 || by == 3) {
                if (byArray.length != n + 1) {
                    throw new IllegalArgumentException("Bad octet string for EC point.");
                }
                int n2 = by == 2 ? 0 : 1;
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 1, byArray2, 0, n);
                this.x = this.field.createFieldElement(byArray2);
                this.y = this.decompressY(this.x, n2);
            } else if (by == 4 || by == 5 || by == 6) {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Bad octet string for EC point.");
                }
                byte[] byArray3 = new byte[n];
                byte[] byArray4 = new byte[n];
                System.arraycopy(byArray, 1, byArray3, 0, n);
                System.arraycopy(byArray, n + 1, byArray4, 0, n);
                this.x = this.field.createFieldElement(byArray3);
                this.y = this.field.createFieldElement(byArray4);
            } else {
                throw new IllegalArgumentException("Bad octet string for EC point.");
            }
            if (!this.curve.isPointOnCurve(this.x, this.y)) {
                throw new IllegalArgumentException("Bad octet string for EC point.");
            }
        }
    }

    public EllipticCurve getCurve() {
        return this.curve;
    }

    public FieldElement getX() {
        if (this.pointAtInfinity) {
            return null;
        }
        return this.x;
    }

    public FieldElement getY() {
        if (this.pointAtInfinity) {
            return null;
        }
        return this.y;
    }

    public int hashCode() {
        String string = String.valueOf(this.curve.hashCode());
        if (this.isPointZero()) {
            string.concat(String.valueOf(new byte[1]));
        } else {
            string.concat(String.valueOf(this.x.hashCode()));
            string.concat(String.valueOf(this.y.hashCode()));
        }
        return string.hashCode();
    }

    public boolean isPointZero() {
        return this.pointAtInfinity;
    }

    public ECPoint multiply(int n) {
        return this.multiply(BigInt.valueOf(n));
    }

    public abstract ECPoint multiply(BigInt var1);

    public abstract ECPoint multiplyAndAdd(BigInt var1, ECPoint var2, BigInt var3) throws ECException;

    public abstract ECPoint negate();

    public ECPoint subtract(ECPoint eCPoint) throws ECException {
        return this.add(eCPoint.negate());
    }

    public byte[] toByteArray() {
        return this.toByteArray(1);
    }

    byte[] toByteArray(int n) {
        int n2 = (this.field.getBitLength() + 7) / 8;
        byte[] byArray = null;
        if (this.pointAtInfinity) {
            byArray = new byte[1];
        } else if (n == 0) {
            byArray = new byte[n2 + 1];
            byArray[0] = (byte)(this.compressY() == 0 ? 2 : 3);
            System.arraycopy(this.x.toByteArray(), 0, byArray, 1, n2);
        } else if (n == 1) {
            byArray = new byte[2 * n2 + 1];
            byArray[0] = 4;
            System.arraycopy(this.x.toByteArray(), 0, byArray, 1, n2);
            System.arraycopy(this.y.toByteArray(), 0, byArray, n2 + 1, n2);
        } else if (n == 2) {
            byArray = new byte[2 * n2 + 1];
            byArray[0] = (byte)(this.compressY() == 0 ? 6 : 7);
            System.arraycopy(this.x.toByteArray(), 0, byArray, 1, n2);
            System.arraycopy(this.y.toByteArray(), 0, byArray, n2 + 1, n2);
        } else {
            throw new IllegalArgumentException("Unknown encoding form.");
        }
        return byArray;
    }
}

