/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.ECC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.BinaryField;
import com.phaos.math.ECException;
import com.phaos.math.EllipticCurve;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;
import com.phaos.math.PrimeField;
import com.phaos.utils.Utils;

public class ECUtils {
    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public static byte[] computeR(byte[] byArray, int n, int n2) {
        int n3 = n2 - 160 * n;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        BigInt bigInt = new BigInt(1, byArray);
        int n4 = bigInt.bitLength();
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.computeCurrent();
        BigInt bigInt2 = new BigInt(1, messageDigest.getDigestBits());
        int n5 = n3;
        while (n5 < 160) {
            bigInt2 = bigInt2.clearBit(n5);
            ++n5;
        }
        byte[] byArray2 = Utils.toByteArray(bigInt2);
        byte[] byArray3 = new byte[20 * n + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        int n6 = 1;
        while (n6 <= n) {
            messageDigest.init();
            messageDigest.update(Utils.toByteArray(bigInt.add(BigInt.valueOf(n6)).mod(ECC.ONE.shiftLeft(n4))));
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.getDigestBits(), 0, byArray3, byArray2.length + 20 * (n6 - 1), 20);
            ++n6;
        }
        return byArray3;
    }

    public static int[] computeWindowNAF(int n, BigInt bigInt) {
        if (n < 2 || bigInt.signum() <= 0) {
            throw new IllegalArgumentException("w must be larger than 1 and k must be positive.");
        }
        int[] nArray = new int[bigInt.bitLength() + 1];
        int n2 = 1 << n;
        int n3 = 0;
        while (bigInt.signum() != 0) {
            if (bigInt.testBit(0)) {
                nArray[n3] = bigInt.intValue() & n2 - 1;
                if ((nArray[n3] & n2 >> 1) != 0) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] - n2;
                }
                bigInt = bigInt.subtract(BigInt.valueOf(nArray[n3]));
            }
            bigInt = bigInt.shiftRight(1);
            ++n3;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private static EllipticCurve genBinaryECVR(BinaryField binaryField) throws ECException {
        RandomBitsSource randomBitsSource = RandomBitsSource.getDefault();
        byte[] byArray = new byte[20];
        int n = binaryField.getM();
        int n2 = (n - 1) / 160;
        FieldElement fieldElement = binaryField.getElementZero();
        while (fieldElement.isElementZero()) {
            byArray = randomBitsSource.randomBytes(byArray);
            fieldElement = binaryField.createFieldElement(ECUtils.computeR(byArray, n2, n));
        }
        FieldElement fieldElement2 = binaryField.createFieldElement(randomBitsSource.randomBigInt(n));
        return EllipticCurve.getInstance(fieldElement2, fieldElement, byArray);
    }

    public static BigInt[] genLucasSequence(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4) {
        BigInt bigInt5 = bigInt.pow(2).subtract(bigInt2.shiftLeft(2));
        BigInt bigInt6 = ECC.ONE;
        BigInt bigInt7 = bigInt;
        int n = bigInt4.bitLength() - 1;
        while (n >= 0) {
            BigInt bigInt8 = bigInt6;
            if (bigInt4.testBit(n)) {
                bigInt8 = bigInt.multiply(bigInt6).add(bigInt7).shiftRight(1).mod(bigInt3);
                bigInt7 = bigInt3.multiply(bigInt7).subtract(bigInt5.multiply(bigInt6)).shiftRight(1).mod(bigInt3);
                bigInt6 = bigInt8;
            } else {
                bigInt8 = bigInt6.multiply(bigInt7).mod(bigInt3);
                bigInt7 = bigInt7.multiply(bigInt7).add(bigInt5.multiply(bigInt6.multiply(bigInt6))).shiftRight(1).mod(bigInt3);
                bigInt6 = bigInt8;
            }
            --n;
        }
        return new BigInt[]{bigInt6, bigInt7};
    }

    private static EllipticCurve genPrimeECVR(PrimeField primeField) throws ECException {
        RandomBitsSource randomBitsSource = RandomBitsSource.getDefault();
        byte[] byArray = new byte[20];
        BigInt bigInt = primeField.getP();
        int n = bigInt.bitLength() - 1;
        int n2 = (n - 1) / 160;
        BigInt bigInt2 = null;
        do {
            byArray = randomBitsSource.randomBytes(byArray);
            bigInt2 = new BigInt(1, ECUtils.computeR(byArray, n2, n));
        } while ((bigInt2 = bigInt2.clearBit(n)).signum() == 0 || bigInt2.shiftLeft(2).add(ECC.TWENTY_SEVEN).mod(bigInt).signum() == 0);
        return EllipticCurve.getInstance((Field)primeField, bigInt2, bigInt2, byArray);
    }

    public static EllipticCurve generateEllipticCurveVR(Field field) throws ECException {
        if (field.getFieldType().equals(ECC.BINARY_FIELD)) {
            return ECUtils.genBinaryECVR((BinaryField)field);
        }
        if (field.getFieldType().equals(ECC.PRIME_FIELD)) {
            return ECUtils.genPrimeECVR((PrimeField)field);
        }
        throw new IllegalArgumentException("Unsupported field type.");
    }

    public static FieldElement solveBinaryQuadraticEqt(FieldElement fieldElement) {
        Field field = fieldElement.getField();
        if (!field.getFieldType().equals(ECC.BINARY_FIELD)) {
            throw new IllegalArgumentException("Not an element over a binary field.");
        }
        int n = ((BinaryField)field).getM();
        FieldElement fieldElement2 = null;
        if (n % 2 != 0) {
            FieldElement fieldElement3 = fieldElement;
            int n2 = (n - 1) / 2;
            while (n2 > 0) {
                fieldElement3 = fieldElement3.pow(4).add(fieldElement);
                --n2;
            }
            if (fieldElement3.pow(2).add(fieldElement3).equals(fieldElement)) {
                fieldElement2 = fieldElement3;
            }
        } else {
            do {
                FieldElement fieldElement4 = field.createFieldElement(RandomBitsSource.getDefault().randomBigInt(n));
                fieldElement2 = field.getElementZero();
                FieldElement fieldElement5 = field.createFieldElement(fieldElement.toBigInt());
                int n3 = n - 1;
                while (n3 > 0) {
                    fieldElement2 = fieldElement2.pow(2).add(fieldElement5.pow(2).multiply(fieldElement4));
                    fieldElement5 = fieldElement5.pow(2).add(fieldElement);
                    --n3;
                }
                if (fieldElement5.isElementZero()) continue;
                return null;
            } while (fieldElement2.pow(2).add(fieldElement2).isElementZero());
        }
        return fieldElement2;
    }

    public static FieldElement sqrt(FieldElement fieldElement) {
        block8: {
            Field field = fieldElement.getField();
            if (field.getFieldType().equals(ECC.BINARY_FIELD)) {
                return fieldElement.pow(field.size().shiftRight(1));
            }
            if (!field.getFieldType().equals(ECC.PRIME_FIELD)) break block8;
            BigInt bigInt = ((PrimeField)field).getP();
            BigInt bigInt2 = fieldElement.toBigInt();
            if (bigInt.mod(ECC.FOUR).compareTo(ECC.THREE) == 0) {
                BigInt bigInt3 = bigInt.subtract(ECC.THREE).shiftRight(2);
                BigInt bigInt4 = bigInt2.modPow(bigInt3.add(ECC.ONE), bigInt);
                if (bigInt4.modPow(ECC.TWO, bigInt).compareTo(bigInt2) == 0) {
                    return field.createFieldElement(bigInt4);
                }
            } else if (bigInt.mod(ECC.EIGHT).compareTo(ECC.FIVE) == 0) {
                BigInt bigInt5 = bigInt.subtract(ECC.FIVE).shiftRight(3);
                BigInt bigInt6 = bigInt2.add(bigInt2).modPow(bigInt5, bigInt);
                BigInt bigInt7 = bigInt2.add(bigInt2).multiply(bigInt6.multiply(bigInt6));
                if ((bigInt7 = bigInt2.multiply(bigInt7.subtract(ECC.ONE)).multiply(bigInt6)).modPow(ECC.TWO, bigInt).compareTo(bigInt2) == 0) {
                    return field.createFieldElement(bigInt7);
                }
            } else {
                BigInt bigInt8;
                BigInt bigInt9 = bigInt.subtract(ECC.ONE).shiftRight(2);
                BigInt bigInt10 = fieldElement.toBigInt();
                do {
                    BigInt bigInt11 = RandomBitsSource.getDefault().randomBigInt(bigInt.bitLength()).mod(bigInt);
                    BigInt[] bigIntArray = ECUtils.genLucasSequence(bigInt11, bigInt10, bigInt, bigInt9.shiftLeft(1).add(ECC.ONE));
                    bigInt8 = bigIntArray[0].mod(bigInt);
                    if (bigIntArray[1].modPow(ECC.TWO, bigInt).compareTo(bigInt10.shiftLeft(2)) != 0) continue;
                    return field.createFieldElement(bigIntArray[1].shiftRight(1).mod(bigInt));
                } while (bigInt8.compareTo(ECC.ONE) == 0 || bigInt8.compareTo(ECC.ONE.negate()) == 0);
            }
        }
        return null;
    }
}

