/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.ECException;
import com.phaos.math.ECPoint;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;
import com.phaos.utils.OIDManager;

public abstract class EllipticCurve {
    protected Field field;
    protected FieldElement a;
    protected FieldElement b;
    protected byte[] seed;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected EllipticCurve() {
    }

    public ECPoint createECPoint(BigInt bigInt, BigInt bigInt2) {
        return this.createECPoint(this.field.createFieldElement(bigInt), this.field.createFieldElement(bigInt2));
    }

    public abstract ECPoint createECPoint(FieldElement var1, FieldElement var2);

    public abstract ECPoint createECPoint(byte[] var1);

    public ECPoint createECPoint(byte[] byArray, byte[] byArray2) {
        return this.createECPoint(this.field.createFieldElement(byArray), this.field.createFieldElement(byArray2));
    }

    public abstract ECPoint createRandomPoint();

    public boolean equals(Object object) {
        if (object != null && object instanceof EllipticCurve) {
            return this.a.equals(((EllipticCurve)object).getA()) && this.b.equals(((EllipticCurve)object).getB());
        }
        return false;
    }

    public FieldElement getA() {
        return this.a;
    }

    public FieldElement getB() {
        return this.b;
    }

    public Field getField() {
        return this.field;
    }

    public static EllipticCurve getInstance(Field field, BigInt bigInt, BigInt bigInt2, byte[] byArray) throws ECException {
        return EllipticCurve.getInstance(field.createFieldElement(bigInt), field.createFieldElement(bigInt2), byArray);
    }

    public static EllipticCurve getInstance(Field field, byte[] byArray, byte[] byArray2, byte[] byArray3) throws ECException {
        return EllipticCurve.getInstance(field.createFieldElement(byArray), field.createFieldElement(byArray2), byArray3);
    }

    public static EllipticCurve getInstance(FieldElement fieldElement, FieldElement fieldElement2, byte[] byArray) throws ECException {
        ASN1ObjectID aSN1ObjectID;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(aSN1ObjectID = fieldElement.getField().getFieldType(), "ec");
        if (clazz == null) {
            throw new ECException("No class found for elliptic curve over the field of type " + aSN1ObjectID);
        }
        EllipticCurve ellipticCurve = null;
        try {
            ellipticCurve = (EllipticCurve)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ECException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new ECException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new ECException("Class does not implement Message Digest.");
        }
        ellipticCurve.field = fieldElement.getField();
        if (!ellipticCurve.field.equals(fieldElement2.getField())) {
            throw new ECException("These two elements are on different fields.");
        }
        ellipticCurve.a = fieldElement;
        ellipticCurve.b = fieldElement2;
        if (byArray != null) {
            ellipticCurve.seed = byArray;
        }
        return ellipticCurve;
    }

    public ECPoint getPointZero() {
        return this.createECPoint(new byte[0]);
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public int hashCode() {
        String string = String.valueOf(this.a.hashCode());
        string.concat(String.valueOf(this.b.hashCode()));
        return string.hashCode();
    }

    public abstract boolean isEllipticCurveVR();

    public abstract boolean isNonsingular();

    public abstract boolean isPointOnCurve(FieldElement var1, FieldElement var2);
}

