/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.ECC;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.FieldElement;
import com.phaos.math.FieldException;
import com.phaos.math.FieldValue;
import com.phaos.utils.OIDManager;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Field
implements ASN1Object {
    protected FieldValue modulus;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected Field() {
    }

    protected Field(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public abstract FieldElement createFieldElement(BigInt var1);

    public abstract FieldElement createFieldElement(byte[] var1);

    public boolean equals(Object object) {
        if (object != null && object instanceof Field) {
            return Utils.areEqual(Utils.toBytes(this), Utils.toBytes((Field)object));
        }
        return false;
    }

    public abstract int getBitLength();

    public FieldElement getElementOne() {
        return this.createFieldElement(ECC.ONE);
    }

    public FieldElement getElementZero() {
        return this.createFieldElement(ECC.ZERO);
    }

    public abstract ASN1ObjectID getFieldType();

    public static Field getInstance(ASN1ObjectID aSN1ObjectID, BigInt bigInt) throws FieldException {
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(aSN1ObjectID, "field");
        if (clazz == null) {
            throw new FieldException("No class found for finite field of type " + aSN1ObjectID);
        }
        Field field = null;
        try {
            field = (Field)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FieldException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new FieldException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new FieldException("Class does not implement Message Digest.");
        }
        field.initialize(aSN1ObjectID, bigInt);
        return field;
    }

    public static Field getInstance(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
        ASN1Object aSN1Object = aSN1Sequence.elementAt(1);
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(aSN1ObjectID, "field");
        if (clazz == null) {
            throw new IOException("No class found for finite field of type " + aSN1ObjectID);
        }
        Field field = null;
        try {
            field = (Field)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class does not implement Message Digest.");
        }
        field.initialize(aSN1ObjectID, aSN1Object);
        return field;
    }

    public FieldValue getModulus() {
        return this.modulus;
    }

    public int hashCode() {
        return new String(Utils.toBytes(this)).hashCode();
    }

    protected abstract void initialize(ASN1ObjectID var1, ASN1Object var2) throws IOException;

    protected abstract void initialize(ASN1ObjectID var1, BigInt var2);

    public void input(InputStream inputStream) throws IOException {
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            this.initialize((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Sequence.elementAt(1));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public abstract boolean isValidField();

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    public abstract BigInt size();

    abstract ASN1Sequence toASN1Sequence();
}

