/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.Field;
import com.phaos.math.FieldValue;
import com.phaos.utils.Utils;

public class FieldElement {
    private Field field;
    private FieldValue val;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    FieldElement(Field field, FieldValue fieldValue) {
        if (fieldValue.toBigInt().signum() < 0 || fieldValue.toBigInt().compareTo(field.getModulus().toBigInt()) >= 0) {
            throw new IllegalArgumentException("Invalid value for an element in the field!");
        }
        this.field = field;
        this.val = fieldValue;
    }

    public FieldElement add(FieldElement fieldElement) {
        if (!this.field.equals(fieldElement.getField())) {
            throw new ArithmeticException("Illegal to add elements on different fields");
        }
        return new FieldElement(this.field, this.val.add(fieldElement.getFieldValue()).mod(this.field));
    }

    public FieldElement divide(FieldElement fieldElement) {
        if (!this.field.equals(fieldElement.getField())) {
            throw new ArithmeticException("Illegal to divide by element of different fields");
        }
        if (fieldElement.isElementZero()) {
            throw new ArithmeticException("Cannot be divided by zero element.");
        }
        return new FieldElement(this.field, this.val.multiply(fieldElement.getFieldValue().modInverse(this.field)).mod(this.field));
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FieldElement) {
            return this.field.equals(((FieldElement)object).getField()) && this.val.equals(((FieldElement)object).val);
        }
        return false;
    }

    public Field getField() {
        return this.field;
    }

    public FieldValue getFieldValue() {
        return this.val;
    }

    public int hashCode() {
        String string = new String(Utils.toBytes(this.field));
        string.concat(new String(this.toByteArray()));
        return string.hashCode();
    }

    public FieldElement inverse() {
        if (this.isElementZero()) {
            throw new ArithmeticException("zero elmement has no inverse.");
        }
        return new FieldElement(this.field, this.val.modInverse(this.field.getModulus()));
    }

    public boolean isElementOne() {
        return this.val.isOne();
    }

    public boolean isElementZero() {
        return this.val.isZero();
    }

    public FieldElement multiply(int n) {
        if (n == 0) {
            return this.field.getElementZero();
        }
        if (n < 0) {
            return this.multiply(-n).negate();
        }
        FieldElement fieldElement = new FieldElement(this.field, this.val);
        int n2 = 0;
        while (n2 < n) {
            fieldElement = this.add(this);
            ++n2;
        }
        return fieldElement;
    }

    public FieldElement multiply(FieldElement fieldElement) {
        if (!this.field.equals(fieldElement.getField())) {
            throw new ArithmeticException("Illegal to multiply elements of different fields");
        }
        return new FieldElement(this.field, this.val.multiply(fieldElement.getFieldValue()).mod(this.field));
    }

    public FieldElement negate() {
        return new FieldElement(this.field, this.val.negate().mod(this.field));
    }

    public FieldElement pow(int n) {
        return this.pow(BigInt.valueOf(n));
    }

    public FieldElement pow(BigInt bigInt) {
        if (bigInt.signum() == 0) {
            return this.field.getElementOne();
        }
        if (bigInt.signum() < 0) {
            return this.pow(bigInt.negate()).inverse();
        }
        FieldElement fieldElement = new FieldElement(this.field, this.val);
        int n = bigInt.bitLength() - 2;
        while (n >= 0) {
            fieldElement = fieldElement.square();
            if (bigInt.testBit(n)) {
                fieldElement = this.multiply(fieldElement);
            }
            --n;
        }
        return fieldElement;
    }

    public FieldElement square() {
        return new FieldElement(this.field, this.val.square().mod(this.field));
    }

    public FieldElement subtract(FieldElement fieldElement) {
        if (!this.field.equals(fieldElement.getField())) {
            throw new ArithmeticException("Illegal to sutract elements of different fields");
        }
        return new FieldElement(this.field, this.val.subtract(fieldElement.getFieldValue()).mod(this.field));
    }

    public BigInt toBigInt() {
        return this.val.toBigInt();
    }

    public byte[] toByteArray() {
        int n = (this.field.getBitLength() + 7) / 8;
        byte[] byArray = Utils.toByteArray(this.toBigInt());
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        return byArray2;
    }
}

