/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.ECC;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.Field;

public abstract class FieldValue {
    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected FieldValue() {
    }

    public abstract FieldValue add(FieldValue var1);

    public int bitLength() {
        return this.toBigInt().bitLength();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FieldValue) {
            return this.toBigInt().compareTo(((FieldValue)object).toBigInt()) == 0;
        }
        return false;
    }

    public abstract FieldValue gcd(FieldValue var1);

    public int hashCode() {
        return this.toBigInt().hashCode();
    }

    public abstract boolean isIrreducible();

    public boolean isOne() {
        return this.toBigInt().compareTo(ECC.ONE) == 0;
    }

    public boolean isZero() {
        return this.toBigInt().signum() == 0;
    }

    public FieldValue mod(Field field) {
        return this.mod(field.getModulus());
    }

    public abstract FieldValue mod(FieldValue var1);

    public FieldValue modInverse(Field field) {
        return this.modInverse(field.getModulus());
    }

    public abstract FieldValue modInverse(FieldValue var1);

    public abstract FieldValue multiply(FieldValue var1);

    public abstract FieldValue negate();

    public abstract FieldValue square();

    public abstract FieldValue subtract(FieldValue var1);

    public abstract BigInt toBigInt();
}

