/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import java.math.BigInteger;

public class Prime {
    private static final int[] intSmallPrimes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511, 1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993, 1997, 1999};
    private static final BigInt[] smallPrimes = new BigInt[intSmallPrimes.length];

    static {
        int n = 0;
        int n2 = smallPrimes.length;
        while (n < n2) {
            Prime.smallPrimes[n] = BigInt.valueOf(intSmallPrimes[n]);
            ++n;
        }
        FIPS_140_2.powerUpSelfTest();
    }

    public static BigInt generateBigIntPrime(int n, int n2, RandomBitsSource randomBitsSource) {
        BigInt bigInt;
        do {
            bigInt = randomBitsSource.randomBigInt(n);
        } while (!Prime.isProbablePrime(bigInt = bigInt.setBit(0).setBit(n - 1), n2, randomBitsSource));
        return bigInt;
    }

    public static BigInt generateBigIntPrime(int n, RandomBitsSource randomBitsSource) {
        return Prime.generateBigIntPrime(n, 100, randomBitsSource);
    }

    public static BigInteger generatePrime(int n, int n2, RandomBitsSource randomBitsSource) {
        return new BigInteger(Prime.generateBigIntPrime(n, n2, randomBitsSource).toByteArray());
    }

    public static BigInteger generatePrime(int n, RandomBitsSource randomBitsSource) {
        return new BigInteger(Prime.generateBigIntPrime(n, randomBitsSource).toByteArray());
    }

    public static boolean isProbablePrime(BigInt bigInt, int n, RandomBitsSource randomBitsSource) {
        if (bigInt.equals(BigInt.ONE)) {
            return false;
        }
        int n2 = 0;
        int n3 = smallPrimes.length;
        while (n2 < n3) {
            if (bigInt.equals(smallPrimes[n2])) {
                return true;
            }
            if (bigInt.remainder(smallPrimes[n2]).signum() == 0) {
                return false;
            }
            ++n2;
        }
        BigInt bigInt2 = bigInt.subtract(BigInt.ONE);
        BigInt bigInt3 = bigInt.subtract(BigInt.ONE);
        int n4 = bigInt3.getLowestSetBit();
        bigInt3 = bigInt3.shiftRight(n4);
        int n5 = 0;
        int n6 = (n + 1) / 2;
        while (n5 < n6) {
            BigInt bigInt4;
            boolean bl = false;
            while ((bigInt4 = randomBitsSource.randomBigInt(bigInt.bitLength())).signum() == 0 || bigInt4.compareTo(bigInt) >= 0) {
            }
            BigInt bigInt5 = bigInt4.modPow(bigInt3, bigInt);
            if (bigInt5.compareTo(BigInt.ONE) == 0) {
                bl = true;
            }
            int n7 = 0;
            while (n7 < n4 && !bl) {
                if (bigInt5.compareTo(bigInt2) == 0) {
                    bl = true;
                } else {
                    bigInt5 = bigInt5.modPow(BigInt.TWO, bigInt);
                }
                ++n7;
            }
            if (!bl) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public static boolean isProbablePrime(BigInteger bigInteger, int n, RandomBitsSource randomBitsSource) {
        return Prime.isProbablePrime(BigInt.getInstance(bigInteger), n, randomBitsSource);
    }
}

