/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.ECC;
import com.phaos.math.BigInt;
import com.phaos.math.ECException;
import com.phaos.math.ECPoint;
import com.phaos.math.ECUtils;
import com.phaos.math.EllipticCurve;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;
import com.phaos.math.PrimeField;
import com.phaos.utils.Utils;

public class PrimeECPoint
extends ECPoint {
    private static final EllipticCurve P_192_CURVE;
    private static final BigInt[][][] P192;
    private static final BigInt[][] M192;

    static {
        BigInt bigInt = ECC.p_192.subtract(ECC.THREE);
        BigInt bigInt2 = new BigInt(1, Utils.fromHexString("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1"));
        BigInt bigInt3 = new BigInt(1, Utils.fromHexString("188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012"));
        BigInt bigInt4 = new BigInt(1, Utils.fromHexString("07192b95ffc8da78631011ed6b24cdd573f977a11e794811"));
        try {
            P_192_CURVE = EllipticCurve.getInstance((Field)new PrimeField(ECC.p_192), bigInt, bigInt2, null);
        }
        catch (ECException eCException) {
            throw new RuntimeException(eCException.toString());
        }
        P192 = PrimeECPoint.preComputeFBC(ECC.p_192, bigInt, bigInt3, bigInt4, 5);
        M192 = PrimeECPoint.preComputeINME(ECC.p_192, bigInt, bigInt3, bigInt4, 4);
    }

    PrimeECPoint(EllipticCurve ellipticCurve, FieldElement fieldElement, FieldElement fieldElement2) {
        super(ellipticCurve, fieldElement, fieldElement2);
    }

    PrimeECPoint(EllipticCurve ellipticCurve, byte[] byArray) {
        super(ellipticCurve, byArray);
    }

    public ECPoint add(ECPoint eCPoint) throws ECException {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new ECException("The points are on different curves.");
        }
        if (this.isPointZero()) {
            return eCPoint;
        }
        if (eCPoint.isPointZero()) {
            return new PrimeECPoint(this.curve, this.x, this.y);
        }
        BigInt[] bigIntArray = PrimeECPoint.addAffine(this.field.size(), this.curve.getA().toBigInt(), new BigInt[]{this.x.toBigInt(), this.y.toBigInt()}, new BigInt[]{eCPoint.x.toBigInt(), eCPoint.y.toBigInt()}, null);
        if (bigIntArray.length == 0) {
            return this.curve.getPointZero();
        }
        return new PrimeECPoint(this.curve, this.field.createFieldElement(bigIntArray[0]), this.field.createFieldElement(bigIntArray[1]));
    }

    private static BigInt[] addAffine(BigInt bigInt, BigInt bigInt2, BigInt[] bigIntArray, BigInt[] bigIntArray2, BigInt[] bigIntArray3) {
        int n;
        int n2 = n = bigIntArray.length == 0 && bigIntArray2.length == 0 ? 0 : 2;
        if (bigIntArray3 == null || bigIntArray3.length != n) {
            bigIntArray3 = new BigInt[n];
        }
        if (bigIntArray.length == 0) {
            bigIntArray3 = (BigInt[])bigIntArray2.clone();
        } else if (bigIntArray2.length == 0) {
            bigIntArray3 = (BigInt[])bigIntArray.clone();
        } else {
            bigIntArray3[0] = bigIntArray[0].subtract(bigIntArray2[0]);
            bigIntArray3[1] = bigIntArray[1].subtract(bigIntArray2[1]);
            if (bigIntArray3[0].signum() != 0) {
                bigIntArray3[1] = bigIntArray3[1].multiply(bigIntArray3[0].modInverse(bigInt)).mod(bigInt);
            } else if (bigIntArray3[1].signum() != 0 || bigIntArray2[1].signum() == 0) {
                bigIntArray3 = new BigInt[]{};
            } else {
                bigIntArray3[1] = bigIntArray2[0].multiply(bigIntArray2[0]).mod(bigInt);
                bigIntArray3[1] = bigIntArray3[1].shiftLeft(1).add(bigIntArray3[1]).add(bigInt2).multiply(bigIntArray2[1].shiftLeft(1).modInverse(bigInt)).mod(bigInt);
            }
            if (bigIntArray3.length > 0) {
                bigIntArray3[0] = bigIntArray3[1].multiply(bigIntArray3[1]).subtract(bigIntArray3[0].add(bigIntArray2[0].shiftLeft(1))).mod(bigInt);
                bigIntArray3[1] = bigIntArray2[0].subtract(bigIntArray3[0]).multiply(bigIntArray3[1]).subtract(bigIntArray2[1]).mod(bigInt);
            }
        }
        return bigIntArray3;
    }

    private static BigInt[] addPA(BigInt bigInt, BigInt bigInt2, BigInt[] bigIntArray, BigInt[] bigIntArray2, BigInt[] bigIntArray3) {
        int n;
        int n2 = n = bigIntArray.length == 0 && bigIntArray2.length == 0 ? 0 : 3;
        if (bigIntArray3 == null || bigIntArray3.length != n) {
            bigIntArray3 = new BigInt[n];
        }
        if (bigIntArray2.length == 0) {
            bigIntArray3 = (BigInt[])bigIntArray.clone();
        } else if (bigIntArray.length == 0) {
            bigIntArray3[0] = bigIntArray2[0];
            bigIntArray3[1] = bigIntArray2[1];
            bigIntArray3[2] = ECC.ONE;
        } else {
            bigIntArray3[0] = bigIntArray[0];
            bigIntArray3[1] = bigIntArray[1];
            bigIntArray3[2] = bigIntArray[2];
            BigInt bigInt3 = bigIntArray2[0];
            BigInt bigInt4 = bigIntArray2[1];
            BigInt bigInt5 = bigIntArray3[2].multiply(bigIntArray3[2]).mod(bigInt);
            bigInt3 = bigInt3.multiply(bigInt5).mod(bigInt);
            bigInt5 = bigIntArray3[2].multiply(bigInt5).mod(bigInt);
            bigInt4 = bigIntArray3[1].subtract(bigInt4.multiply(bigInt5).mod(bigInt));
            if ((bigInt3 = bigIntArray3[0].subtract(bigInt3).mod(bigInt)).signum() == 0) {
                bigIntArray3 = bigInt4.mod(bigInt).signum() == 0 ? PrimeECPoint.doubling(bigInt, bigInt2, bigIntArray2, bigIntArray3, 1) : new BigInt[]{};
            } else {
                bigIntArray3[0] = bigIntArray3[0].shiftLeft(1).subtract(bigInt3);
                bigIntArray3[1] = bigIntArray3[1].shiftLeft(1).subtract(bigInt4);
                bigIntArray3[2] = bigIntArray3[2].multiply(bigInt3).mod(bigInt);
                bigInt5 = bigInt3.multiply(bigInt3).mod(bigInt);
                bigInt3 = bigInt3.multiply(bigInt5).mod(bigInt);
                bigInt5 = bigIntArray3[0].multiply(bigInt5).mod(bigInt);
                bigIntArray3[0] = bigInt4.multiply(bigInt4).subtract(bigInt5).mod(bigInt);
                bigInt5 = bigInt5.subtract(bigIntArray3[0].shiftLeft(1));
                bigIntArray3[1] = bigInt4.multiply(bigInt5).subtract(bigIntArray3[1].multiply(bigInt3)).mod(bigInt);
                bigIntArray3[1] = (bigIntArray3[1].testBit(0) ? bigIntArray3[1].add(bigInt) : bigIntArray3[1]).shiftRight(1);
            }
        }
        return bigIntArray3;
    }

    int compressY() {
        return this.y.toBigInt().testBit(0) ? 1 : 0;
    }

    FieldElement decompressY(FieldElement fieldElement, int n) {
        int n2;
        FieldElement fieldElement2 = ECUtils.sqrt(fieldElement.pow(3).add(this.curve.getA().multiply(fieldElement)).add(this.curve.getB()));
        int n3 = n2 = fieldElement2.toBigInt().testBit(0) ? 1 : 0;
        if (n2 == n) {
            return fieldElement2;
        }
        return fieldElement2.negate();
    }

    public ECPoint doubling() {
        if (this.isPointZero() || this.y.isElementZero()) {
            return this.curve.getPointZero();
        }
        BigInt[] bigIntArray = new BigInt[]{this.x.toBigInt(), this.y.toBigInt()};
        bigIntArray = PrimeECPoint.addAffine(this.field.size(), this.curve.getA().toBigInt(), bigIntArray, bigIntArray, null);
        return new PrimeECPoint(this.curve, this.field.createFieldElement(bigIntArray[0]), this.field.createFieldElement(bigIntArray[1]));
    }

    private static BigInt[] doubling(BigInt bigInt, BigInt bigInt2, BigInt[] bigIntArray, BigInt[] bigIntArray2, int n) {
        if (bigIntArray.length == 0 || bigIntArray[1].signum() == 0) {
            bigIntArray2 = new BigInt[]{};
        } else {
            if (bigIntArray2 == null || bigIntArray2.length != 3) {
                bigIntArray2 = new BigInt[]{bigIntArray[0], bigIntArray[1], bigIntArray.length == 3 ? bigIntArray[2] : ECC.ONE};
            }
            boolean bl = bigInt2.add(ECC.THREE).compareTo(bigInt) == 0;
            while (n-- > 0) {
                BigInt bigInt3;
                BigInt bigInt4;
                if (bigIntArray2[1].signum() == 0) {
                    bigIntArray2 = new BigInt[]{};
                    break;
                }
                if (bl) {
                    bigInt4 = bigIntArray2[2].multiply(bigIntArray2[2]).mod(bigInt);
                    bigInt3 = bigIntArray2[0].subtract(bigInt4);
                    bigInt4 = bigIntArray2[0].add(bigInt4);
                    bigInt3 = bigInt4.multiply(bigInt3).mod(bigInt);
                    bigInt4 = bigInt3.shiftLeft(1).add(bigInt3);
                } else {
                    bigInt3 = bigIntArray2[2].modPow(ECC.FOUR, bigInt).multiply(bigInt2).mod(bigInt);
                    bigInt4 = bigIntArray2[0].multiply(bigIntArray2[0]).mod(bigInt);
                    bigInt4 = bigInt4.shiftLeft(1).add(bigInt4).add(bigInt3);
                }
                bigIntArray2[2] = bigIntArray2[1].multiply(bigIntArray2[2].shiftLeft(1)).mod(bigInt);
                bigIntArray2[1] = bigIntArray2[1].multiply(bigIntArray2[1]).mod(bigInt);
                bigInt3 = bigIntArray2[0].shiftLeft(2).multiply(bigIntArray2[1]).mod(bigInt);
                bigIntArray2[0] = bigInt4.multiply(bigInt4).subtract(bigInt3.shiftLeft(1)).mod(bigInt);
                bigInt3 = bigInt4.multiply(bigInt3.subtract(bigIntArray2[0])).mod(bigInt);
                bigIntArray2[1] = bigInt3.subtract(bigIntArray2[1].multiply(bigIntArray2[1]).shiftLeft(3)).mod(bigInt);
            }
        }
        return bigIntArray2;
    }

    public ECPoint multiply(BigInt bigInt) {
        if (this.isPointZero() || bigInt.signum() == 0) {
            return this.curve.getPointZero();
        }
        if (bigInt.signum() < 0) {
            return this.multiply(bigInt.negate()).negate();
        }
        BigInt bigInt2 = this.field.size();
        BigInt bigInt3 = this.curve.getA().toBigInt();
        BigInt[] bigIntArray = new BigInt[]{};
        if (this.curve.equals(P_192_CURVE) && this.x.toBigInt().compareTo(P192[0][1][0]) == 0 && this.y.toBigInt().compareTo(P192[0][1][1]) == 0) {
            int n = 19;
            while (n >= 0) {
                bigIntArray = PrimeECPoint.doubling(bigInt2, bigInt3, bigIntArray, bigIntArray, 1);
                int n2 = (bigInt.testBit(n) ? 1 : 0) + (bigInt.testBit(39 + n) ? 2 : 0) + (bigInt.testBit(78 + n) ? 4 : 0) + (bigInt.testBit(117 + n) ? 8 : 0) + (bigInt.testBit(156 + n) ? 16 : 0);
                bigIntArray = PrimeECPoint.addPA(bigInt2, bigInt3, bigIntArray, P192[0][n2], bigIntArray);
                if (n != 19) {
                    n2 = (bigInt.testBit(20 + n) ? 1 : 0) + (bigInt.testBit(59 + n) ? 2 : 0) + (bigInt.testBit(98 + n) ? 4 : 0) + (bigInt.testBit(137 + n) ? 8 : 0) + (bigInt.testBit(176 + n) ? 16 : 0);
                    bigIntArray = PrimeECPoint.addPA(bigInt2, bigInt3, bigIntArray, P192[1][n2], bigIntArray);
                }
                --n;
            }
        } else {
            int[] nArray = ECUtils.computeWindowNAF(4, bigInt);
            BigInt[][] bigIntArray2 = new BigInt[4][2];
            bigIntArray2[0][0] = this.x.toBigInt();
            bigIntArray2[0][1] = this.y.toBigInt();
            bigIntArray = PrimeECPoint.addAffine(bigInt2, bigInt3, bigIntArray2[0], bigIntArray2[0], bigIntArray);
            bigIntArray2[1] = PrimeECPoint.addAffine(bigInt2, bigInt3, bigIntArray, bigIntArray2[0], bigIntArray2[1]);
            bigIntArray2[2] = PrimeECPoint.addAffine(bigInt2, bigInt3, bigIntArray, bigIntArray2[1], bigIntArray2[2]);
            bigIntArray2[3] = PrimeECPoint.addAffine(bigInt2, bigInt3, bigIntArray, bigIntArray2[2], bigIntArray2[3]);
            bigIntArray = new BigInt[]{};
            int n = nArray.length - 1;
            while (n >= 0) {
                bigIntArray = PrimeECPoint.doubling(bigInt2, bigInt3, bigIntArray, bigIntArray, 1);
                int n3 = nArray[n];
                if (n3 > 0) {
                    bigIntArray = PrimeECPoint.addPA(bigInt2, bigInt3, bigIntArray, bigIntArray2[(n3 - 1) / 2], bigIntArray);
                } else if (n3 < 0) {
                    bigIntArray = PrimeECPoint.negate(bigInt2, PrimeECPoint.addPA(bigInt2, bigInt3, PrimeECPoint.negate(bigInt2, bigIntArray, bigIntArray), bigIntArray2[(-n3 - 1) / 2], bigIntArray), bigIntArray);
                }
                --n;
            }
        }
        if (bigIntArray.length == 0) {
            return this.curve.getPointZero();
        }
        bigIntArray = PrimeECPoint.toAffine(bigInt2, bigIntArray, null);
        return new PrimeECPoint(this.curve, this.field.createFieldElement(bigIntArray[0]), this.field.createFieldElement(bigIntArray[1]));
    }

    public ECPoint multiplyAndAdd(BigInt bigInt, ECPoint eCPoint, BigInt bigInt2) throws ECException {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new ECException("The points are on different curves");
        }
        BigInt bigInt3 = this.field.size();
        BigInt bigInt4 = this.curve.getA().toBigInt();
        BigInt[][][] bigIntArray = new BigInt[2][8][2];
        bigIntArray[1] = PrimeECPoint.preComputeINME(bigInt3, bigInt4, eCPoint.x.toBigInt(), eCPoint.y.toBigInt(), 4);
        if (this.curve.equals(P_192_CURVE) && this.x.toBigInt().compareTo(M192[0][0]) == 0 && this.y.toBigInt().compareTo(M192[0][1]) == 0) {
            System.arraycopy(M192, 0, bigIntArray[0], 0, 8);
        } else {
            bigIntArray[0] = PrimeECPoint.preComputeINME(bigInt3, bigInt4, this.x.toBigInt(), this.y.toBigInt(), 4);
        }
        int[][] nArray = new int[][]{ECUtils.computeWindowNAF(5, bigInt), ECUtils.computeWindowNAF(5, bigInt2)};
        BigInt[] bigIntArray2 = new BigInt[]{};
        int n = Math.max(nArray[0].length, nArray[1].length) - 1;
        while (n >= 0) {
            bigIntArray2 = PrimeECPoint.doubling(bigInt3, bigInt4, bigIntArray2, bigIntArray2, 1);
            int n2 = 1;
            while (n2 >= 0) {
                if (n < nArray[n2].length) {
                    int n3 = nArray[n2][n];
                    if (n3 > 0) {
                        bigIntArray2 = PrimeECPoint.addPA(bigInt3, bigInt4, bigIntArray2, bigIntArray[n2][(n3 - 1) / 2], bigIntArray2);
                    } else if (n3 < 0) {
                        bigIntArray2 = PrimeECPoint.negate(bigInt3, PrimeECPoint.addPA(bigInt3, bigInt4, PrimeECPoint.negate(bigInt3, bigIntArray2, bigIntArray2), bigIntArray[n2][(-n3 - 1) / 2], bigIntArray2), bigIntArray2);
                    }
                }
                --n2;
            }
            --n;
        }
        if (bigIntArray2.length == 0) {
            return this.curve.getPointZero();
        }
        bigIntArray2 = PrimeECPoint.toAffine(bigInt3, bigIntArray2, null);
        return new PrimeECPoint(this.curve, this.field.createFieldElement(bigIntArray2[0]), this.field.createFieldElement(bigIntArray2[1]));
    }

    public ECPoint negate() {
        if (this.isPointZero()) {
            return this.curve.getPointZero();
        }
        return new PrimeECPoint(this.curve, this.x, this.y.negate());
    }

    private static BigInt[] negate(BigInt bigInt, BigInt[] bigIntArray, BigInt[] bigIntArray2) {
        if (bigIntArray.length == 0) {
            bigIntArray2 = new BigInt[]{};
        } else {
            bigIntArray2 = (BigInt[])bigIntArray.clone();
            bigIntArray2[1] = bigIntArray2[1].negate().add(bigInt);
        }
        return bigIntArray2;
    }

    private static BigInt[][][] preComputeFBC(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, int n) {
        int n2 = 1 << n;
        int n3 = (bigInt.bitLength() - 1 + n - 1) / n;
        int n4 = (n3 + 1) / 2;
        BigInt[][][] bigIntArray = new BigInt[2][n2][];
        bigIntArray[0][0] = new BigInt[0];
        bigIntArray[1][0] = new BigInt[0];
        bigIntArray[0][1] = new BigInt[]{bigInt3, bigInt4};
        BigInt[] bigIntArray2 = new BigInt[3];
        int n5 = 0;
        while (n5 < n) {
            int n6 = 1 << n5;
            if (n5 > 0) {
                bigIntArray[0][n6] = PrimeECPoint.toAffine(bigInt, PrimeECPoint.doubling(bigInt, bigInt2, bigIntArray[0][n6 / 2], bigIntArray2, n3), null);
            }
            bigIntArray[1][n6] = PrimeECPoint.toAffine(bigInt, PrimeECPoint.doubling(bigInt, bigInt2, bigIntArray[0][n6], bigIntArray2, n4), null);
            ++n5;
        }
        BigInt[] bigIntArray3 = new BigInt[3];
        int n7 = 3;
        while (n7 < n2) {
            if (bigIntArray[0][n7] == null) {
                boolean bl = true;
                int n8 = n - 1;
                while (n8 >= 0) {
                    int n9 = 1 << n8;
                    if ((n7 & n9) != 0) {
                        if (bl) {
                            bigIntArray2[0] = bigIntArray[0][n9][0];
                            bigIntArray2[1] = bigIntArray[0][n9][1];
                            bigIntArray2[2] = BigInt.ONE;
                            bigIntArray3[0] = bigIntArray[1][n9][0];
                            bigIntArray3[1] = bigIntArray[1][n9][1];
                            bigIntArray3[2] = BigInt.ONE;
                            bl = false;
                        } else {
                            bigIntArray2 = PrimeECPoint.addPA(bigInt, bigInt2, bigIntArray2, bigIntArray[0][n9], bigIntArray2);
                            bigIntArray3 = PrimeECPoint.addPA(bigInt, bigInt2, bigIntArray3, bigIntArray[1][n9], bigIntArray3);
                        }
                    }
                    --n8;
                }
                bigIntArray[0][n7] = PrimeECPoint.toAffine(bigInt, bigIntArray2, null);
                bigIntArray[1][n7] = PrimeECPoint.toAffine(bigInt, bigIntArray3, null);
            }
            ++n7;
        }
        return bigIntArray;
    }

    private static BigInt[][] preComputeINME(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, int n) {
        int n2 = 1 << n - 1;
        BigInt[][] bigIntArray = new BigInt[n2][2];
        bigIntArray[0][0] = bigInt3;
        bigIntArray[0][1] = bigInt4;
        bigIntArray[n2 - 1] = PrimeECPoint.addAffine(bigInt, bigInt2, bigIntArray[0], bigIntArray[0], bigIntArray[n2 - 1]);
        int n3 = 1;
        while (n3 < n2) {
            bigIntArray[n3] = PrimeECPoint.addAffine(bigInt, bigInt2, bigIntArray[n2 - 1], bigIntArray[n3 - 1], bigIntArray[n3]);
            ++n3;
        }
        return bigIntArray;
    }

    private static BigInt[] toAffine(BigInt bigInt, BigInt[] bigIntArray, BigInt[] bigIntArray2) {
        if (bigIntArray.length == 0) {
            bigIntArray2 = new BigInt[]{};
        } else {
            if (bigIntArray2 == null || bigIntArray2.length != 2) {
                bigIntArray2 = new BigInt[2];
            }
            bigIntArray2[1] = bigIntArray[2].modInverse(bigInt);
            bigIntArray2[0] = bigIntArray2[1].modPow(ECC.TWO, bigInt);
            bigIntArray2[1] = bigIntArray[1].multiply(bigIntArray2[0]).mod(bigInt).multiply(bigIntArray2[1]).mod(bigInt);
            bigIntArray2[0] = bigIntArray[0].multiply(bigIntArray2[0]).mod(bigInt);
        }
        return bigIntArray2;
    }
}

