/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.BigInt;
import com.phaos.math.ECPoint;
import com.phaos.math.ECUtils;
import com.phaos.math.EllipticCurve;
import com.phaos.math.FieldElement;
import com.phaos.math.PrimeECPoint;
import com.phaos.math.PrimeField;

public class PrimeEllipticCurve
extends EllipticCurve {
    public ECPoint createECPoint(FieldElement fieldElement, FieldElement fieldElement2) {
        if (!this.isPointOnCurve(fieldElement, fieldElement2)) {
            throw new IllegalArgumentException("The elements do not define a point on this curve.");
        }
        return new PrimeECPoint(this, fieldElement, fieldElement2);
    }

    public ECPoint createECPoint(byte[] byArray) {
        return new PrimeECPoint(this, byArray);
    }

    public ECPoint createRandomPoint() {
        BigInt bigInt = ((PrimeField)this.field).getP();
        FieldElement fieldElement = null;
        FieldElement fieldElement2 = null;
        while (fieldElement2 == null) {
            BigInt bigInt2 = null;
            while ((bigInt2 = RandomBitsSource.getDefault().randomBigInt(bigInt.bitLength())).compareTo(bigInt) >= 0 || bigInt2.signum() < 0) {
            }
            fieldElement = this.field.createFieldElement(bigInt2);
            FieldElement fieldElement3 = fieldElement.pow(3).add(this.a.multiply(fieldElement)).add(this.b);
            if (fieldElement3.isElementZero()) {
                return new PrimeECPoint(this, fieldElement, fieldElement3);
            }
            fieldElement2 = ECUtils.sqrt(fieldElement3);
        }
        return new PrimeECPoint(this, fieldElement, fieldElement2);
    }

    public boolean isEllipticCurveVR() {
        if (this.seed == null) {
            throw new IllegalStateException("Seed value must be present for the verification.");
        }
        int n = this.field.getBitLength() - 1;
        int n2 = (n - 1) / 160;
        BigInt bigInt = new BigInt(1, ECUtils.computeR(this.seed, n2, n));
        bigInt = bigInt.clearBit(n);
        return this.field.createFieldElement(bigInt).multiply(this.b.pow(2)).equals(this.a.pow(3));
    }

    public boolean isNonsingular() {
        return this.a.pow(3).multiply(4).add(this.b.pow(2).multiply(27)).isElementZero() ^ true;
    }

    public boolean isPointOnCurve(FieldElement fieldElement, FieldElement fieldElement2) {
        if (!this.field.equals(fieldElement.getField()) || !this.field.equals(fieldElement2.getField())) {
            return false;
        }
        return fieldElement2.pow(2).equals(fieldElement.pow(3).add(this.a.multiply(fieldElement)).add(this.b));
    }
}

