/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.ECC;
import com.phaos.math.BigInt;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;
import com.phaos.math.PrimeFieldValue;
import java.io.IOException;
import java.io.InputStream;

public class PrimeField
extends Field {
    private BigInt p;
    private ASN1Sequence contents;

    PrimeField() {
    }

    public PrimeField(BigInt bigInt) {
        this.p = bigInt;
        this.modulus = new PrimeFieldValue(bigInt);
    }

    public PrimeField(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public FieldElement createFieldElement(BigInt bigInt) {
        return new FieldElement(this, new PrimeFieldValue(bigInt));
    }

    public FieldElement createFieldElement(byte[] byArray) {
        return new FieldElement(this, new PrimeFieldValue(byArray));
    }

    public int getBitLength() {
        return this.p.bitLength();
    }

    public ASN1ObjectID getFieldType() {
        return ECC.PRIME_FIELD;
    }

    public BigInt getP() {
        return this.p;
    }

    protected void initialize(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) throws IOException {
        if (!aSN1ObjectID.equals(ECC.PRIME_FIELD)) {
            throw new IllegalArgumentException("Wrong prime field type OID" + aSN1ObjectID);
        }
        try {
            this.p = ((ASN1Integer)aSN1Object).getBigIntValue();
            this.modulus = new PrimeFieldValue(this.p);
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    protected void initialize(ASN1ObjectID aSN1ObjectID, BigInt bigInt) {
        if (!aSN1ObjectID.equals(ECC.PRIME_FIELD)) {
            throw new IllegalArgumentException("Wrong prime field type OID" + aSN1ObjectID);
        }
        this.p = bigInt;
        this.modulus = new PrimeFieldValue(bigInt);
    }

    public boolean isValidField() {
        return this.modulus.isIrreducible();
    }

    public BigInt size() {
        return this.p;
    }

    ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(ECC.PRIME_FIELD);
            aSN1Sequence.addElement(new ASN1Integer(this.p));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }
}

