/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.BigInt;
import com.phaos.math.Field;
import com.phaos.math.FieldValue;
import com.phaos.math.Prime;

public class PrimeFieldValue
extends FieldValue {
    BigInt b;

    public PrimeFieldValue(BigInt bigInt) {
        this.b = bigInt;
    }

    public PrimeFieldValue(byte[] byArray) {
        this(new BigInt(1, byArray));
    }

    public FieldValue add(FieldValue fieldValue) {
        return new PrimeFieldValue(this.b.add(((PrimeFieldValue)fieldValue).b));
    }

    public FieldValue gcd(FieldValue fieldValue) {
        return new PrimeFieldValue(this.b.gcd(((PrimeFieldValue)fieldValue).b));
    }

    public boolean isIrreducible() {
        return Prime.isProbablePrime(this.b, 100, RandomBitsSource.getDefault());
    }

    public FieldValue mod(FieldValue fieldValue) {
        return new PrimeFieldValue(this.b.mod(((PrimeFieldValue)fieldValue).b));
    }

    public FieldValue modInverse(Field field) {
        return this.modInverse(field.getModulus());
    }

    public FieldValue modInverse(FieldValue fieldValue) {
        return new PrimeFieldValue(this.b.modInverse(((PrimeFieldValue)fieldValue).b));
    }

    public FieldValue multiply(FieldValue fieldValue) {
        return new PrimeFieldValue(this.b.multiply(((PrimeFieldValue)fieldValue).b));
    }

    public FieldValue negate() {
        return new PrimeFieldValue(this.b.negate());
    }

    public FieldValue square() {
        return new PrimeFieldValue(this.b.pow(2));
    }

    public FieldValue subtract(FieldValue fieldValue) {
        return new PrimeFieldValue(this.b.subtract(((PrimeFieldValue)fieldValue).b));
    }

    public BigInt toBigInt() {
        return this.b;
    }
}

