/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.fips.FIPS_140_2;

public class ArrayVector {
    protected static final int INITIAL_SIZE = 32;
    protected static final int GROWTH_FACTOR = 2;
    protected Object[] elements;
    protected int count;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public ArrayVector() {
        this(32);
    }

    public ArrayVector(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid value for initialSize: " + n);
        }
        this.count = 0;
        this.elements = new Object[n];
    }

    public ArrayVector(Object[] objectArray) {
        if (objectArray.length == 0) {
            this.elements = new Object[32];
        } else {
            this.elements = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        }
        this.count = objectArray.length;
    }

    public void addElement(Object object) {
        if (this.count >= this.elements.length) {
            Object[] objectArray = new Object[this.elements.length != 0 ? this.elements.length * 2 : 32];
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
            this.elements = objectArray;
        }
        this.elements[this.count++] = object;
    }

    public void addElementAt(Object object, int n) {
        if (n == this.count) {
            this.addElement(object);
        } else {
            Object[] objectArray = null;
            if (this.count >= this.elements.length) {
                objectArray = new Object[this.elements.length != 0 ? this.elements.length * 2 : 32];
                System.arraycopy(this.elements, 0, objectArray, 0, n);
            } else {
                objectArray = this.elements;
            }
            System.arraycopy(this.elements, n, objectArray, n + 1, this.count - n);
            objectArray[n] = object;
            this.elements = objectArray;
            ++this.count;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.count) {
            this.elements[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public Object elementAt(int n) {
        if (n >= this.count) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.elements[n];
    }

    public Object[] getElements() {
        Object[] objectArray = new Object[this.count];
        System.arraycopy(this.elements, 0, objectArray, 0, this.count);
        return objectArray;
    }

    public void getElements(Object[] objectArray) {
        System.arraycopy(this.elements, 0, objectArray, 0, this.count);
    }

    public void setElementAt(Object object, int n) {
        if (n >= this.count) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.elements[n] = object;
    }

    public int size() {
        return this.count;
    }
}

