/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.DESKey;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SHA;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.OIDManager;
import com.phaos.utils.StreamableInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CryptoUtils {
    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public static boolean checkKeyParity(SymmetricKey symmetricKey, int n) {
        return DESKey.checkParity(symmetricKey, n);
    }

    public static byte[] generateKeyID(PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        SHA sHA = new SHA();
        sHA.update(Utils.toBytes(publicKey.getContents()));
        sHA.computeCurrent();
        return sHA.getDigestBits();
    }

    public static byte[] getIV(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)algorithmIdentifier).getIV();
        }
        CBCAlgorithmIdentifier cBCAlgorithmIdentifier = new CBCAlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters());
        return cBCAlgorithmIdentifier.getIV();
    }

    public static KeyPair inputKeyPair(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        if (aSN1Sequence.size() == 9) {
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
            try {
                rSAPrivateKey.initialize(AlgID.rsaEncryption, aSN1Sequence);
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IOException(algorithmIdentifierException.toString());
            }
            return new KeyPair(rSAPrivateKey.getPublicKey(), rSAPrivateKey);
        }
        if (aSN1Sequence.size() == 6) {
            if (((ASN1Integer)aSN1Sequence.elementAt(0)).getValue().intValue() != 0) {
                throw new ASN1FormatException("Invalid key pair format");
            }
            DSAParams dSAParams = new DSAParams(((ASN1Integer)aSN1Sequence.elementAt(1)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(3)).getValue());
            DSAPublicKey dSAPublicKey = new DSAPublicKey(((ASN1Integer)aSN1Sequence.elementAt(4)).getValue(), dSAParams);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(((ASN1Integer)aSN1Sequence.elementAt(5)).getValue(), dSAParams);
            ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
            return new KeyPair(dSAPublicKey, dSAPrivateKey);
        }
        throw new ASN1FormatException("Unknown key pair format");
    }

    public static PrivateKey inputPrivateKey(File file) throws IOException {
        return CryptoUtils.inputPrivateKey(new FileInputStream(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey inputPrivateKey(InputStream inputStream) throws IOException {
        PrivateKey privateKey;
        ASN1TaggedObject aSN1TaggedObject;
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        Object object = null;
        try {
            Object object2;
            aSN1TaggedObject = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!((ASN1Integer)aSN1TaggedObject).equals(0)) {
                throw new VersionException(((ASN1Integer)aSN1TaggedObject).getValue(), 0);
            }
            AlgorithmIdentifier algorithmIdentifier = null;
            if (aSN1Sequence.size() == 9) {
                algorithmIdentifier = AlgID.rsaEncryption;
                object = aSN1Sequence;
            } else if (aSN1Sequence.size() == 5) {
                algorithmIdentifier = AlgID.dsaWithSHA1;
                object = aSN1Sequence;
            } else {
                algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
                object2 = aSN1Sequence.elementAt(2);
                if (object2 instanceof ASN1OctetString) {
                    object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1OctetString)object2).getValue()));
                } else {
                    if (!(object2 instanceof ASN1Sequence)) throw new IOException("Invalid private key contents");
                    object = object2;
                }
            }
            object2 = OIDManager.getOIDManager();
            Class clazz = ((OIDManager)object2).getMapping(algorithmIdentifier.getOID(), "privateKey");
            if (clazz == null) {
                throw new IOException("Unrecognized algorithm identifier");
            }
            try {
                PrivateKey privateKey2 = (PrivateKey)clazz.newInstance();
                privateKey2.initialize(algorithmIdentifier, (ASN1Object)object);
                privateKey = privateKey2;
                Object var5_13 = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Class does not implement PrivateKey");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IOException(algorithmIdentifierException.toString());
            }
            if (aSN1Sequence.size() == 9) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
                return privateKey;
            }
            if (aSN1Sequence.size() == 5) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                return privateKey;
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            if (aSN1Sequence.size() == 9) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
                throw throwable;
            }
            if (aSN1Sequence.size() == 5) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                throw throwable;
            }
            if (aSN1Sequence.elementAt(2) instanceof ASN1OctetString) {
                Utils.setArray(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue(), (byte)0);
            }
            if (object == null) throw throwable;
            if (!(object instanceof ASN1Sequence)) {
                if (!(object instanceof ASN1Integer)) throw throwable;
                ((ASN1Integer)object).erase();
                throw throwable;
            }
            Object object3 = object;
            if (((ASN1Sequence)object3).size() == 9) {
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(3)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(4)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(5)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(6)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(7)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(8)).erase();
                throw throwable;
            }
            if (((ASN1Sequence)object3).size() != 5) throw throwable;
            ((ASN1Integer)((ASN1Sequence)object3).elementAt(3)).erase();
            throw throwable;
        }
        if (aSN1Sequence.elementAt(2) instanceof ASN1OctetString) {
            Utils.setArray(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue(), (byte)0);
        }
        if (object == null) return privateKey;
        if (object instanceof ASN1Sequence) {
            aSN1TaggedObject = (ASN1Sequence)object;
            if (((ASN1Sequence)aSN1TaggedObject).size() == 9) {
                ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(3)).erase();
                ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(4)).erase();
                ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(5)).erase();
                ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(6)).erase();
                ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(7)).erase();
                ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(8)).erase();
                return privateKey;
            }
            if (((ASN1Sequence)aSN1TaggedObject).size() != 5) return privateKey;
            ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(3)).erase();
            return privateKey;
        }
        if (!(object instanceof ASN1Integer)) return privateKey;
        ((ASN1Integer)object).erase();
        return privateKey;
    }

    public static PublicKey inputSPKI(ASN1Sequence aSN1Sequence) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(Utils.toBytes(aSN1Sequence)));
    }

    public static PublicKey inputSPKI(InputStream inputStream) throws IOException {
        PublicKey publicKey;
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "publicKey");
        if (clazz == null) {
            throw new IOException("Unrecognized algorithm identifier.");
        }
        try {
            publicKey = (PublicKey)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class does not implement PublicKey.");
        }
        ASN1Object aSN1Object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(ASN1BitString.inputValue(aSN1SequenceInputStream)));
        try {
            publicKey.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
        return publicKey;
    }

    public static PublicKey inputSPKI(byte[] byArray) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(byArray));
    }

    public static boolean isDesPossiblyWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isPossiblyWeak(symmetricKey);
    }

    public static boolean isDesSemiWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isSemiWeak(symmetricKey);
    }

    public static boolean isDesWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isWeak(symmetricKey);
    }

    public static ASN1Sequence makeAlgID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1ObjectID);
        if (!aSN1ObjectID.equals(DSA.dsaSigOID)) {
            aSN1Sequence.addElement(new ASN1Null());
        }
        return aSN1Sequence;
    }

    public static Signature makeSignature(PrivateKey privateKey) throws SignatureException {
        Signature signature;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new SignatureException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new SignatureException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return signature;
    }

    public static Signature makeSignature(PublicKey publicKey) throws AuthenticationException {
        Signature signature;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new AuthenticationException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        return signature;
    }

    public static ASN1Sequence privateKeyInfo(PrivateKey privateKey) {
        byte[] byArray = privateKey.getEncoded();
        try {
            return new ASN1Sequence(new UnsyncByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public static void setKeyParity(SymmetricKey symmetricKey, int n) {
        DESKey.setParity(symmetricKey, n);
    }

    public static byte[] sign(byte[] byArray, PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.sign(byArray, privateKey, RandomBitsSource.getDefault());
    }

    public static byte[] sign(byte[] byArray, PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        FIPS_140_2.assertReadyState();
        try {
            Signature signature = Signature.getInstance(privateKey.getAlgID());
            signature.setDocument(byArray);
            signature.setRandomBitsSource(randomBitsSource);
            signature.sign();
            return signature.getSigBytes();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.signASN1(aSN1Object, privateKey, RandomBitsSource.getDefault());
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        FIPS_140_2.assertReadyState();
        Signature signature = Signature.getInstance(privateKey);
        signature.setDocument(Utils.toBytes(aSN1Object));
        signature.setRandomBitsSource(randomBitsSource);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1Object);
        aSN1Sequence.addElement(signature.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(signature.sign()));
        return aSN1Sequence;
    }

    public static ASN1Sequence subjectPublicKeyInfo(PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(publicKey.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(publicKey.getContents())));
        return aSN1Sequence;
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws AuthenticationException {
        FIPS_140_2.assertReadyState();
        Signature signature = Signature.getInstance(publicKey);
        signature.setDocument(byArray);
        signature.setSigBytes(byArray2);
        return signature.verify();
    }

    public static boolean verifySignedASN1(ASN1Sequence aSN1Sequence, PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        try {
            byte[] byArray = Utils.toBytes(aSN1Sequence.elementAt(0));
            byte[] byArray2 = ((ASN1BitString)aSN1Sequence.elementAt(2)).getValue();
            Signature signature = Signature.getInstance(new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(1))));
            signature.setPublicKey(publicKey);
            signature.setDocument(byArray);
            signature.setSigBytes(byArray2);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            return false;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

