/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.fips.FIPS_140_2;
import java.io.IOException;
import java.io.InputStream;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;
    private boolean isClosed;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public UnsyncByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.count = byArray.length;
    }

    public UnsyncByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = this.mark = n;
        this.count = Math.min(n + n2, byArray.length);
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("input stream closed");
        }
    }

    public int available() throws IOException {
        this.assertOpen();
        return this.count - this.pos;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        this.assertOpen();
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public void reset() throws IOException {
        this.assertOpen();
        this.pos = this.mark;
    }

    public long skip(long l) throws IOException {
        this.assertOpen();
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l <= 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }
}

