/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.fips.FIPS_140_2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class UnsyncHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient UnsyncHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public UnsyncHashtable() {
        this(101, 0.75f);
    }

    public UnsyncHashtable(int n) {
        this(n, 0.75f);
    }

    public UnsyncHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new UnsyncHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public void clear() {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n = unsyncHashtableEntryArray.length;
        while (--n >= 0) {
            unsyncHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            UnsyncHashtable unsyncHashtable = (UnsyncHashtable)super.clone();
            unsyncHashtable.table = new UnsyncHashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtable.table[n] = this.table[n] != null ? (UnsyncHashtableEntry)this.table[n].clone() : null;
            }
            return unsyncHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n = unsyncHashtableEntryArray.length;
        while (n-- > 0) {
            UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n];
            while (unsyncHashtableEntry != null) {
                if (unsyncHashtableEntry.value.equals(object)) {
                    return true;
                }
                unsyncHashtableEntry = unsyncHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.hash == n && unsyncHashtableEntry.key.equals(object)) {
                return true;
            }
            unsyncHashtableEntry = unsyncHashtableEntry.next;
        }
        return false;
    }

    public Enumeration elements() {
        return new UnsyncHashtableEnumerator(this.table, false);
    }

    public Object get(Object object) {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.hash == n && unsyncHashtableEntry.key.equals(object)) {
                return unsyncHashtableEntry.value;
            }
            unsyncHashtableEntry = unsyncHashtableEntry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new UnsyncHashtableEnumerator(this.table, true);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.hash == n && unsyncHashtableEntry.key.equals(object)) {
                Object object3 = unsyncHashtableEntry.value;
                unsyncHashtableEntry.value = object2;
                return object3;
            }
            unsyncHashtableEntry = unsyncHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        UnsyncHashtableEntry unsyncHashtableEntry2 = new UnsyncHashtableEntry();
        unsyncHashtableEntry2.hash = n;
        unsyncHashtableEntry2.key = object;
        unsyncHashtableEntry2.value = object2;
        unsyncHashtableEntry2.next = unsyncHashtableEntryArray[n2];
        unsyncHashtableEntryArray[n2] = unsyncHashtableEntry2;
        ++this.count;
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new UnsyncHashtableEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    protected void rehash() {
        int n = this.table.length;
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        UnsyncHashtableEntry[] unsyncHashtableEntryArray2 = new UnsyncHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = unsyncHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n3];
            while (unsyncHashtableEntry != null) {
                UnsyncHashtableEntry unsyncHashtableEntry2 = unsyncHashtableEntry;
                unsyncHashtableEntry = unsyncHashtableEntry.next;
                int n4 = (unsyncHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                unsyncHashtableEntry2.next = unsyncHashtableEntryArray2[n4];
                unsyncHashtableEntryArray2[n4] = unsyncHashtableEntry2;
            }
        }
    }

    public Object remove(Object object) {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        UnsyncHashtableEntry unsyncHashtableEntry2 = null;
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.hash == n && unsyncHashtableEntry.key.equals(object)) {
                if (unsyncHashtableEntry2 != null) {
                    unsyncHashtableEntry2.next = unsyncHashtableEntry.next;
                } else {
                    unsyncHashtableEntryArray[n2] = unsyncHashtableEntry.next;
                }
                --this.count;
                return unsyncHashtableEntry.value;
            }
            unsyncHashtableEntry2 = unsyncHashtableEntry;
            unsyncHashtableEntry = unsyncHashtableEntry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(String.valueOf(string) + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            UnsyncHashtableEntry unsyncHashtableEntry = this.table[n];
            while (unsyncHashtableEntry != null) {
                objectOutputStream.writeObject(unsyncHashtableEntry.key);
                objectOutputStream.writeObject(unsyncHashtableEntry.value);
                unsyncHashtableEntry = unsyncHashtableEntry.next;
            }
            --n;
        }
    }

    private class UnsyncHashtableEntry {
        int hash;
        Object key;
        Object value;
        UnsyncHashtableEntry next;

        UnsyncHashtableEntry() {
        }

        protected Object clone() {
            UnsyncHashtableEntry unsyncHashtableEntry = new UnsyncHashtableEntry();
            unsyncHashtableEntry.hash = this.hash;
            unsyncHashtableEntry.key = this.key;
            unsyncHashtableEntry.value = this.value;
            unsyncHashtableEntry.next = this.next != null ? (UnsyncHashtableEntry)this.next.clone() : null;
            return unsyncHashtableEntry;
        }
    }

    private class UnsyncHashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        UnsyncHashtableEntry[] table;
        UnsyncHashtableEntry entry;

        UnsyncHashtableEnumerator(UnsyncHashtableEntry[] unsyncHashtableEntryArray, boolean bl) {
            this.table = unsyncHashtableEntryArray;
            this.keys = bl;
            this.index = unsyncHashtableEntryArray.length;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.index-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                UnsyncHashtableEntry unsyncHashtableEntry = this.entry;
                this.entry = unsyncHashtableEntry.next;
                return this.keys ? unsyncHashtableEntry.key : unsyncHashtableEntry.value;
            }
            throw new NoSuchElementException("UnsyncHashtableEnumerator");
        }
    }
}

