/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ConstraintGroup
extends Constraint {
    private static final LogicalOp DEFAULT_OP = LogicalOp.OR;
    private List constraints;
    private LogicalOp op;

    private void init() {
        this.constraints = new LinkedList();
        this.op = DEFAULT_OP;
    }

    public ConstraintGroup() {
        this.init();
        ((Constraint)this).constraints = new LinkedList();
        this.container = true;
    }

    void setConstant() {
        this.constant = true;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            constraint.setConstant();
        }
    }

    List getConstraints() {
        return this.constraints;
    }

    public void add(Constraint constraint) {
        Lib.CheckParam(constraint, "constraint");
        if (constraint.isRequired()) {
            this.setRequired();
        }
        constraint.setConstant();
        this.constraints.add(constraint);
    }

    LogicalOp getLogicalOp() {
        return this.op;
    }

    public void setOperator(LogicalOp logicalOp) {
        Lib.CheckParam(logicalOp, "someOp");
        this.op = logicalOp;
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    boolean isValid(Parameter parameter, String string) {
        if (this.op == LogicalOp.AND) {
            return this.applyANDGroup(parameter, string);
        }
        if (this.op == LogicalOp.OR) {
            return this.applyORGroup(parameter, string);
        }
        throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
    }

    String getLegalValues() {
        int n = this.constraints.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            Constraint constraint = (Constraint)this.constraints.get(0);
            return constraint.getLegalValues();
        }
        int n2 = 1;
        StringBuffer stringBuffer = new StringBuffer(32 * n);
        stringBuffer.append("(");
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            stringBuffer.append(constraint.toString());
            if (n2 < n) {
                stringBuffer.append(" " + this.op.toString() + " ");
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private boolean applyANDGroup(Parameter parameter, String string) {
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (constraint.isValid(parameter, string)) continue;
            return false;
        }
        return true;
    }

    private boolean applyORGroup(Parameter parameter, String string) {
        Object var5_3 = null;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (!constraint.isValid(parameter, string)) continue;
            return true;
        }
        return false;
    }
}

