/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Context;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSElement;
import com.novell.nds.dirxml.driver.xds.XDSMethodInvocationContextException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.NamespaceName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
implements XDSElement {
    private static final int DEFAULT_POSITION = -1;
    private static final boolean DEFAULT_ANY_CONTENT = false;
    DocumentImpl document;
    Element element;
    private List children;
    private int position;
    protected boolean anyContent;

    ElementImpl() {
    }

    protected ElementImpl(Element element, DocumentImpl documentImpl) {
        this.document = documentImpl;
        this.element = element;
        this.children = Collections.EMPTY_LIST;
        this.position = -1;
        this.anyContent = false;
    }

    public String tagName() {
        return this.element.getTagName();
    }

    public Element domElement() {
        return this.element;
    }

    public Document domDocument() {
        return this.document.domDocument();
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        return null;
    }

    protected void passText(String string) throws XDSParseException {
        if (this.document.isStrict()) {
            throw new XDSParseException(Errors.IllegalText(this.tagName()));
        }
    }

    void setPosition(int n) {
        this.position = n;
    }

    public int position() {
        return this.position;
    }

    List children() {
        return this.children;
    }

    List children(int n) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList(n);
        }
        return this.children;
    }

    protected void handleUnrecognizedElement(Element element, String string, int n, int n2) throws XDSParseException {
        if (!this.anyContent && this.document.isStrict()) {
            throw new XDSParseException(Errors.IllegalElement(this.tagName(), string));
        }
        NonXDSElement nonXDSElement = new NonXDSElement(element, this.document);
        nonXDSElement.setPosition(n);
        this.children(n2).add(nonXDSElement);
    }

    protected void parseChildNodes() throws XDSParseException {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Text text;
            String string;
            short s = nodeList.item(n4).getNodeType();
            if (s == 1) {
                int n5;
                String string2;
                Element element = (Element)nodeList.item(n4);
                ElementImpl elementImpl = this.parseChildElement(element, string2 = element.getTagName(), n2, n5 = n - n3);
                if (elementImpl != XDS.IGNORE) {
                    if (elementImpl == null) {
                        this.handleUnrecognizedElement(element, string2, n2, n5);
                    } else {
                        elementImpl.setPosition(n2);
                        this.children(n5).add(elementImpl);
                    }
                    ++n2;
                }
            } else if (s == 3 && Lib.IsValue(string = (text = (Text)nodeList.item(n4)).getData())) {
                this.passText(string);
            }
            ++n3;
            ++n4;
        }
    }

    protected ElementImpl(DocumentImpl documentImpl, Element element, String string) {
        this.document = documentImpl;
        this.children = Collections.EMPTY_LIST;
        this.position = -1;
        this.anyContent = false;
        this.element = this.document.domDocument().createElement(string);
        element.appendChild(this.element);
    }

    public String attributeValueGet(String string) {
        if (string == null) {
            return null;
        }
        return Lib.ToNull(this.element.getAttribute(string));
    }

    protected void setAttributeValue(String string, Object object, DTDVersion dTDVersion) {
        if (string == null || object == null) {
            return;
        }
        this.element.setAttribute(string, object.toString());
    }

    protected void setAttributeValue(String string, String string2, DTDVersion dTDVersion) {
        if (string == null || Lib.NoValue(string2)) {
            return;
        }
        this.element.setAttribute(string, string2);
    }

    public void attributeValueSet(String string, String string2) {
        if (string == null || Lib.NoValue(string2)) {
            return;
        }
        this.element.setAttribute(string, string2);
    }

    protected void setAttributeValue(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        this.element.setAttribute(string, object.toString());
    }

    public String localName() {
        return DOMUtil.getLocalName((Node)this.element);
    }

    public String namespaceName() {
        return DOMUtil.getNamespaceName((Node)this.element).getString();
    }

    public String attributeValueGet(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return this.attributeValueGet(string2);
        }
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string3;
            NamespaceName namespaceName;
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string4 = DOMUtil.getLocalName((Node)attr);
            if (string4.equals(string2) && (namespaceName = DOMUtil.getNamespaceName((Node)attr)) != null && !namespaceName.isEmpty() && string.equals(string3 = namespaceName.getString())) {
                return Lib.ToNull(attr.getNodeValue());
            }
            ++n2;
        }
        return null;
    }

    protected void throwMissingAttributeException(String string) throws XDSParseException {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            throw new XDSParseException(Errors.NoAttribute(string));
        }
        throw new XDSParseException(Errors.NoAttributeValue(string));
    }

    public List childElements() {
        return Lib.GetElements(this, this.children);
    }

    protected void doNotCall(int n) {
        throw new XDSMethodInvocationContextException(Errors.WrongContext(Context.ToString(n)));
    }
}

