/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Context;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSMethodInvocationContextException;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Lib {
    Lib() {
    }

    static int NormalizeCompare(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    static ElementImpl OptionsElement_parseChildElement(ElementImpl elementImpl, Element element, String string, int n, int n2, List[] listArray, List[] listArray2) throws XDSParseException {
        ElementImpl elementImpl2 = null;
        if ("instance".compareTo(string) == 0) {
            if (listArray2[0] == Collections.EMPTY_LIST) {
                listArray2[0] = new LinkedList();
            }
            elementImpl2 = new XDSInstanceElement(element, elementImpl.document);
            listArray2[0].add(elementImpl2);
        } else {
            if (listArray[0] == Collections.EMPTY_LIST) {
                listArray[0] = new ArrayList(n2);
            }
            elementImpl2 = new NonXDSElement(element, elementImpl.document);
            listArray[0].add(elementImpl2);
        }
        return elementImpl2;
    }

    static void ExtractParams(Map map, Map map2) throws XDSParameterException {
        Lib.CheckParam(map, "paramElements");
        Lib.CheckParam(map2, "params");
        XDSParameterException xDSParameterException = null;
        XDSParameterException xDSParameterException2 = null;
        XDSParameterException xDSParameterException3 = null;
        Iterator iterator = map2.values().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            ParamElement paramElement = (ParamElement)map.get(parameter.tagName());
            if (paramElement == null) {
                if (!parameter.isRequired()) continue;
                xDSParameterException3 = new XDSParameterException(Errors.NoParam(parameter.tagName()));
                if (xDSParameterException2 == null) {
                    xDSParameterException = xDSParameterException3;
                    xDSParameterException2 = xDSParameterException3;
                    continue;
                }
                xDSParameterException2.setNext(xDSParameterException3);
                xDSParameterException2 = xDSParameterException3;
                continue;
            }
            parameter.setParamElement(paramElement);
            String string = paramElement.attributeValueGet("display-name");
            if (string == null) {
                string = parameter.getDescription();
            } else {
                parameter.setDescription(string);
            }
            try {
                parameter.setValue(paramElement.extractText());
            }
            catch (XDSParameterException xDSParameterException4) {
                if (xDSParameterException2 == null) {
                    xDSParameterException = xDSParameterException4;
                    xDSParameterException2 = xDSParameterException4;
                    continue;
                }
                xDSParameterException2.setNext(xDSParameterException4);
                xDSParameterException2 = xDSParameterException4;
            }
        }
        if (xDSParameterException != null) {
            throw xDSParameterException;
        }
    }

    static ElementImpl StateElement_parseChildElement(ElementImpl elementImpl, Element element, String string, int n, int n2, List[] listArray) throws XDSParseException {
        NonXDSElement nonXDSElement = new NonXDSElement(element, elementImpl.document);
        if (listArray[0] == Collections.EMPTY_LIST) {
            listArray[0] = new ArrayList(n2);
        }
        listArray[0].add(nonXDSElement);
        return nonXDSElement;
    }

    static void ParamParent_populateMap(ElementImpl elementImpl, Map[] mapArray, List list) throws XDSParameterException {
        if (mapArray[0] == XDS.EMPTY_MAP && list.size() > 0) {
            mapArray[0] = new HashMap(list.size());
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ParamElement paramElement = (ParamElement)listIterator.next();
                ParamElement paramElement2 = mapArray[0].put(paramElement.tagName(), paramElement);
                if (paramElement2 == null) continue;
                throw new XDSParameterException(Errors.DuplicateParam(elementImpl.tagName(), paramElement.tagName()));
            }
        }
    }

    static ParamElement ParamParent_paramElement(ElementImpl elementImpl, Map map, String string) {
        return (ParamElement)map.get(string);
    }

    static String ParamParent_paramText(ElementImpl elementImpl, Map map, String string) {
        ParamElement paramElement = (ParamElement)map.get(string);
        return paramElement == null ? null : paramElement.extractText();
    }

    static String GetText(ElementImpl elementImpl, TextParent textParent) {
        if (textParent == null) {
            return null;
        }
        return textParent.extractText();
    }

    static boolean GetValue(ElementImpl elementImpl, _Boolean _Boolean2) {
        if (_Boolean2 == null) {
            return false;
        }
        return _Boolean2.toPrimitive();
    }

    static String GetValue(ElementImpl elementImpl, String string) {
        return string;
    }

    static String GetAttributeValue(ElementImpl elementImpl, String string) {
        return elementImpl.attributeValueGet(string);
    }

    static void CheckParam(String string, String string2) {
        if (string == null || "".compareTo(string) == 0) {
            throw new IllegalArgumentException(Errors.NoParamValue(string2));
        }
    }

    static _Boolean ToBoolean(String string, _Boolean _Boolean2) {
        if (string == null) {
            return _Boolean2;
        }
        if (string.compareTo("true") == 0) {
            return _Boolean.TRUE;
        }
        if (string.compareTo("false") == 0) {
            return _Boolean.FALSE;
        }
        return new _Boolean(string);
    }

    public static String ToNull(String string) {
        if (Lib.NoValue(string)) {
            return null;
        }
        return string;
    }

    static boolean IsValue(String string) {
        return string != null && "".compareTo(string) != 0;
    }

    static boolean NoValue(String string) {
        return string == null || "".compareTo(string) == 0;
    }

    static void CheckParam(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(Errors.NoParamValue(string));
        }
    }

    static void AssociationElementParent_validate(ElementImpl elementImpl, XDSAssociationElement xDSAssociationElement, int n, boolean bl) throws XDSParseException {
        if (xDSAssociationElement != null) {
            if (n > 1) {
                throw new XDSParseException(Errors.DuplicateElement("association"));
            }
            if (elementImpl.document.isStrict() && xDSAssociationElement.position() != 1) {
                throw new XDSParseException(Errors.MisplacedElement(elementImpl.tagName(), "association", 1));
            }
        }
    }

    static XDSAssociationElement AssociationElementParent_appendAssociationElement(ElementImpl elementImpl, String string) {
        XDSAssociationElement xDSAssociationElement = new XDSAssociationElement(elementImpl.document, elementImpl.element);
        xDSAssociationElement.appendText(string);
        return xDSAssociationElement;
    }

    static XDSAssociationElement AssociationElementParent_associationElement(ElementImpl elementImpl, XDSAssociationElement xDSAssociationElement) {
        return xDSAssociationElement;
    }

    static String AssociationElementParent_associationText(ElementImpl elementImpl, XDSAssociationElement xDSAssociationElement) {
        if (xDSAssociationElement == null) {
            return null;
        }
        return xDSAssociationElement.extractText();
    }

    static void CheckVersion(DTDVersion dTDVersion, DTDVersion dTDVersion2) {
        if (dTDVersion.compareTo(dTDVersion2) == -1) {
            throw new XDSMethodInvocationContextException(Errors.WrongDTDVersion(dTDVersion2.toString()));
        }
    }

    static void CheckContext(int n, int n2) {
        if (n != n2) {
            throw new XDSMethodInvocationContextException(Errors.WrongContext(Context.ToString(n2)));
        }
    }

    static List GetElements(DocumentImpl documentImpl, List list) {
        return list;
    }

    static List GetElements(ElementImpl elementImpl, List list) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    static List ValueElementParent_extractValueElements(ElementImpl elementImpl, List[] listArray) {
        if (listArray == null) {
            return Collections.EMPTY_LIST;
        }
        return listArray[0];
    }

    static XDSValueElement ValueElementParent_appendValueElement(ElementImpl elementImpl, ValueType valueType, String string) {
        XDSValueElement xDSValueElement = new XDSValueElement(elementImpl.document, elementImpl.element, valueType);
        if (string != null) {
            xDSValueElement.appendText(string);
        }
        return xDSValueElement;
    }

    static ElementImpl ValueElementParent_parseChildElement(ElementImpl elementImpl, Element element, String string, int n, List[] listArray) throws XDSParseException {
        XDSValueElement xDSValueElement = null;
        if ("value".compareTo(string) == 0) {
            xDSValueElement = new XDSValueElement(element, elementImpl.document);
            if (listArray[0] == Collections.EMPTY_LIST) {
                listArray[0] = new ArrayList(n);
            }
            listArray[0].add(xDSValueElement);
        }
        return xDSValueElement;
    }

    static void ValueElementsParent_validate(ElementImpl elementImpl) throws XDSParseException {
        if (elementImpl.children() == Collections.EMPTY_LIST) {
            throw new XDSParseException(Errors.NoElement("value"));
        }
    }

    static void TextParent_appendText(ElementImpl elementImpl, String string) {
        if (Lib.NoValue(string)) {
            return;
        }
        Text text = elementImpl.document.document.createTextNode(string);
        elementImpl.element.appendChild(text);
    }

    static String TextParent_text(ElementImpl elementImpl, String string) {
        return Lib.ToNull(string);
    }

    static String SomeAttrElement_getAttrName(ElementImpl elementImpl, String string) {
        return string;
    }

    static void SomeAttrElement_setAttrName(ElementImpl elementImpl, String string) {
        elementImpl.attributeValueSet("attr-name", string);
    }

    static void SomeAttrElement_validate(ElementImpl elementImpl, String string) throws XDSParseException {
        if (string == null) {
            elementImpl.throwMissingAttributeException("attr-name");
        }
    }

    static XmlDocument WriteableDocument_toXML(DocumentImpl documentImpl) {
        return new XmlDocument(documentImpl.document);
    }

    static XDSModifyAssociationElement WriteableDocument_appendModifyAssociationElement(DocumentImpl documentImpl) {
        return new XDSModifyAssociationElement(documentImpl, documentImpl.ioElement);
    }

    static XDSInitParamsElement StateDocument_appendInitParamsElement(DocumentImpl documentImpl, XDSInitParamsElement[] xDSInitParamsElementArray) {
        if (xDSInitParamsElementArray[0] == null) {
            xDSInitParamsElementArray[0] = new XDSInitParamsElement(documentImpl, documentImpl.ioElement);
        }
        return xDSInitParamsElementArray[0];
    }

    static XDSSourceElement WriteableDocument_appendSourceElement(DocumentImpl documentImpl, XDSSourceElement xDSSourceElement) {
        if (xDSSourceElement == null) {
            xDSSourceElement = new XDSSourceElement(documentImpl, documentImpl.rootElement);
            Element element = xDSSourceElement.domElement();
            documentImpl.rootElement.removeChild(element);
            documentImpl.rootElement.insertBefore(element, documentImpl.ioElement);
        }
        return xDSSourceElement;
    }

    static XDSStatusElement StatusDocument_appendHeartbeat(DocumentImpl documentImpl) {
        XDSStatusElement xDSStatusElement = Lib.StatusDocument_appendStatusElement(documentImpl);
        xDSStatusElement.setLevel(StatusLevel.SUCCESS);
        xDSStatusElement.setType(StatusType.HEARTBEAT);
        return xDSStatusElement;
    }

    static XDSStatusElement StatusDocument_appendStatusElement(DocumentImpl documentImpl) {
        return new XDSStatusElement(documentImpl, documentImpl.ioElement);
    }

    static void WriteableDocument_setEmpty(DocumentImpl documentImpl) {
        Element element = documentImpl.document.createElement(documentImpl.tagName);
        documentImpl.rootElement.replaceChild(element, documentImpl.ioElement);
        documentImpl.ioElement = element;
    }

    static void CommandElement_setEventID(ElementImpl elementImpl, String string) {
        elementImpl.attributeValueSet("event-id", string);
    }

    static String CommandElement_getEventID(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("event-id");
    }

    static String CommandElement_getSrcDN(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("src-dn");
    }

    static String CommandElement_getQualifiedSrcDN(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("qualified-src-dn");
    }

    static String CommandElement_getSrcEntryID(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("src-entry-id");
    }

    static XDSPasswordElement PasswordElementParent_passwordElement(ElementImpl elementImpl, XDSPasswordElement xDSPasswordElement) {
        return xDSPasswordElement;
    }

    static String PasswordElementParent_passwordText(ElementImpl elementImpl, XDSPasswordElement xDSPasswordElement) {
        return Lib.GetText(elementImpl, xDSPasswordElement);
    }

    static DTDVersion ReadableDocument_dtdVersion(DocumentImpl documentImpl) {
        return documentImpl.version;
    }

    static XDSSourceElement ReadableDocument_sourceElement(DocumentImpl documentImpl) {
        return documentImpl.source;
    }

    static void QueryResultDocument_Sort(Map map) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Collections.sort(list);
        }
    }

    static void QueryResultDocument_PopulateMap(Map[] mapArray, List list) {
        if (mapArray[0] == XDS.EMPTY_MAP) {
            mapArray[0] = new HashMap(list.size());
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                XDSStatusElement xDSStatusElement = (XDSStatusElement)listIterator.next();
                String string = xDSStatusElement.getEventID();
                if (string == null) continue;
                LinkedList<XDSStatusElement> linkedList = (LinkedList<XDSStatusElement>)mapArray[0].get(string);
                if (linkedList == null) {
                    linkedList = new LinkedList<XDSStatusElement>();
                    linkedList.add(xDSStatusElement);
                    mapArray[0].put(string, linkedList);
                    continue;
                }
                linkedList.add(xDSStatusElement);
            }
            Lib.QueryResultDocument_Sort(mapArray[0]);
        }
    }

    public static StatusLevel ResultDocument_mostSevereStatusLevel(String string, Map[] mapArray, List list, XDSStatusElement xDSStatusElement) {
        XDSStatusElement xDSStatusElement2 = Lib.ResultDocument_mostSevereStatusElement(string, mapArray, list, xDSStatusElement);
        return xDSStatusElement2 == null ? StatusLevel.SUCCESS : xDSStatusElement2.getLevel();
    }

    static XDSStatusElement ResultDocument_mostSevereStatusElement(String string, Map[] mapArray, List list, XDSStatusElement xDSStatusElement) {
        Lib.QueryResultDocument_PopulateMap(mapArray, list);
        List list2 = (List)mapArray[0].get(string);
        if (list2 != null && !list2.isEmpty()) {
            return (XDSStatusElement)list2.get(0);
        }
        return xDSStatusElement;
    }

    static List QueryResultDocument_extractStatusElements(Map[] mapArray, List list, String string) {
        Lib.QueryResultDocument_PopulateMap(mapArray, list);
        list = (List)mapArray[0].get(string);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    static ElementImpl QueryResultDocument_parseChildElement(DocumentImpl documentImpl, Element element, String string, int n, int n2, List[] listArray, List[] listArray2, XDSStatusElement[] xDSStatusElementArray) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("status".compareTo(string) == 0) {
            elementImpl = new XDSStatusElement(element, documentImpl);
            if (xDSStatusElementArray[0] == null) {
                xDSStatusElementArray[0] = elementImpl;
            } else {
                ElementImpl elementImpl2 = xDSStatusElementArray[0] = xDSStatusElementArray[0].compareTo(elementImpl) == 1 ? elementImpl : xDSStatusElementArray[0];
            }
            if (listArray[0] == Collections.EMPTY_LIST) {
                listArray[0] = new LinkedList();
            }
            listArray[0].add(elementImpl);
        } else if ("instance".compareTo(string) == 0) {
            if (listArray2[0] == Collections.EMPTY_LIST) {
                listArray2[0] = new LinkedList();
            }
            elementImpl = new XDSInstanceElement(element, documentImpl);
            listArray2[0].add(elementImpl);
        }
        return elementImpl;
    }

    static Node CloneSubtree(Document document, Node node) {
        try {
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Element element = (Element)node;
                    Element element2 = document.createElement(element.getNodeName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        object = (Attr)namedNodeMap.item(n);
                        element2.setAttribute(object.getName(), object.getValue());
                        ++n;
                    }
                    object = element.getChildNodes();
                    int n2 = 0;
                    while (n2 < object.getLength()) {
                        element2.appendChild(Lib.CloneSubtree(document, object.item(n2)));
                        ++n2;
                    }
                    return element2;
                }
                case 2: {
                    Attr attr = document.createAttribute(((Attr)node).getName());
                    attr.setValue(((Attr)node).getValue());
                    return attr;
                }
                case 3: {
                    return document.createTextNode(((Text)node).getData());
                }
                case 4: {
                    return document.createCDATASection(((CDATASection)node).getData());
                }
                case 5: {
                    return document.createEntityReference(node.getNodeName());
                }
                case 7: {
                    return document.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                }
                case 8: {
                    return document.createComment(node.getNodeValue());
                }
                case 11: {
                    DocumentFragment documentFragment = document.createDocumentFragment();
                    NodeList nodeList = node.getChildNodes();
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        documentFragment.appendChild(Lib.CloneSubtree(document, nodeList.item(n)));
                        ++n;
                    }
                    return documentFragment;
                }
            }
        }
        catch (DOMException dOMException) {}
        return null;
    }

    static XDSInstanceElement QueryResultDocument_appendInstanceElement(DocumentImpl documentImpl) {
        return new XDSInstanceElement(documentImpl, documentImpl.ioElement);
    }
}

