/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.ParamParent;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSServerElement;
import com.novell.nds.dirxml.driver.xds.XDSUserElement;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class XDSAuthenticationInfoElement
extends ElementImpl
implements ParamParent {
    private XDSServerElement server;
    private XDSUserElement user;
    private XDSPasswordElement password;
    private int noOfServers;
    private int noOfUsers;
    private int noOfPasswords;
    private Map[] paramMap;

    private void init() {
        this.server = null;
        this.user = null;
        this.password = null;
        this.noOfServers = 0;
        this.noOfUsers = 0;
        this.noOfPasswords = 0;
        this.paramMap = new Map[1];
        this.paramMap[0] = XDS.EMPTY_MAP;
    }

    XDSAuthenticationInfoElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfServers > 1) {
                throw new XDSParseException(Errors.DuplicateElement("server"));
            }
            if (this.noOfUsers > 1) {
                throw new XDSParseException(Errors.DuplicateElement("user"));
            }
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.document.isStrict()) {
                if (this.password != null && this.password.position() != this.children().size()) {
                    throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
                }
                if (this.server != null && this.server.position() != 1) {
                    throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "server", 1));
                }
            }
        }
    }

    private void setPassword(XDSPasswordElement xDSPasswordElement) {
        if (this.password == null) {
            this.password = xDSPasswordElement;
        }
        ++this.noOfPasswords;
    }

    private void setUser(XDSUserElement xDSUserElement) {
        if (this.user == null) {
            this.user = xDSUserElement;
        }
        ++this.noOfUsers;
    }

    private void setServer(XDSServerElement xDSServerElement) {
        if (this.server == null) {
            this.server = xDSServerElement;
        }
        ++this.noOfServers;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("password".compareTo(string) == 0) {
            elementImpl = new XDSPasswordElement(element, this.document);
            this.setPassword((XDSPasswordElement)elementImpl);
        } else if ("user".compareTo(string) == 0) {
            elementImpl = new XDSUserElement(element, this.document);
            this.setUser((XDSUserElement)elementImpl);
        } else if ("server".compareTo(string) == 0) {
            elementImpl = new XDSServerElement(element, this.document);
            this.setServer((XDSServerElement)elementImpl);
        }
        return elementImpl;
    }

    public XDSServerElement extractServerElement() {
        return this.server;
    }

    public String extractServerText() {
        return Lib.GetText(this, this.server);
    }

    public XDSUserElement extractUserElement() {
        return this.user;
    }

    public String extractUserText() {
        return Lib.GetText(this, this.user);
    }

    public XDSPasswordElement extractPasswordElement() {
        return this.password;
    }

    public String extractPasswordText() {
        return Lib.GetText(this, this.password);
    }

    public List childElements() {
        return super.childElements();
    }

    public ParamElement paramElement(String string) throws XDSParameterException {
        Lib.ParamParent_populateMap(this, this.paramMap, this.children());
        return Lib.ParamParent_paramElement(this, this.paramMap[0], string);
    }

    public String paramText(String string) throws XDSParameterException {
        Lib.ParamParent_populateMap(this, this.paramMap, this.children());
        return Lib.ParamParent_paramText(this, this.paramMap[0], string);
    }

    public void parameters(Map map) throws XDSParameterException {
        Lib.ParamParent_populateMap(this, this.paramMap, this.children());
        Lib.ExtractParams(this.paramMap[0], map);
    }
}

