/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSDeleteElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;

    private void init() {
        this.association = null;
        this.noOfAssociations = 0;
    }

    XDSDeleteElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
        }
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSAssociationElement xDSAssociationElement = null;
        if ("association".compareTo(string) == 0) {
            xDSAssociationElement = new XDSAssociationElement(element, this.document);
            this.setAssociation(xDSAssociationElement);
        }
        return xDSAssociationElement;
    }

    XDSDeleteElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "delete");
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }
}

