/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.ParamParent;
import com.novell.nds.dirxml.driver.xds.XDSAuthenticationInfoElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverFilterElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverStateElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPublisherOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSPublisherStateElement;
import com.novell.nds.dirxml.driver.xds.XDSSubscriberOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSSubscriberStateElement;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class XDSInitParamsElement
extends ElementImpl {
    private static final int INDEX_AUTHENTICATION_INFO = 0;
    private static final int INDEX_DRIVER_FILTER = 1;
    private static final int INDEX_DRIVER_STATE = 2;
    private static final int INDEX_PUBLISHER_STATE = 3;
    private static final int INDEX_SUBSCRIBER_STATE = 4;
    private static final int INDEX_DRIVER_OPTIONS = 5;
    private static final int INDEX_PUBLISHER_OPTIONS = 6;
    private static final int INDEX_SUBSCRIBER_OPTIONS = 7;
    private static final int NO_OF_ELEMENTS = 8;
    private static final String[] TAG_NAMES = new String[8];
    private String srcDN;
    private int[] noOfElements;
    private DriverFilter filter;
    private XDSDriverFilterElement driverFilter;
    private XDSAuthenticationInfoElement authenticationInfo;
    private XDSDriverStateElement driverState;
    private XDSPublisherStateElement publisherState;
    private XDSSubscriberStateElement subscriberState;
    private XDSDriverOptionsElement driverOptions;
    private XDSPublisherOptionsElement publisherOptions;
    private XDSSubscriberOptionsElement subscriberOptions;
    private Map paramMap;
    private boolean unique;

    private void init() {
        this.srcDN = null;
        this.noOfElements = new int[8];
        this.paramMap = new HashMap();
        this.unique = true;
        int n = 0;
        while (n < this.noOfElements.length) {
            this.noOfElements[n] = 0;
            ++n;
        }
        this.filter = null;
        this.driverFilter = null;
        this.authenticationInfo = null;
        this.driverState = null;
        this.publisherState = null;
        this.subscriberState = null;
        this.driverOptions = null;
        this.publisherOptions = null;
        this.subscriberOptions = null;
    }

    XDSInitParamsElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            int n = 0;
            while (n < 8) {
                if (this.noOfElements[n] > 1) {
                    throw new XDSParseException(Errors.DuplicateElement(TAG_NAMES[n]));
                }
                ++n;
            }
            if (this.document.isStrict()) {
                int n2 = 1;
                if (this.authenticationInfo != null) {
                    if (this.authenticationInfo.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "authentication-info", n2));
                    }
                    ++n2;
                }
                if (this.driverFilter != null) {
                    if (this.driverFilter.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "driver-filter", n2));
                    }
                    ++n2;
                }
                if (this.driverOptions != null) {
                    if (this.driverOptions.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "driver-options", n2));
                    }
                    ++n2;
                }
                if (this.subscriberOptions != null) {
                    if (this.subscriberOptions.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "subscriber-options", n2));
                    }
                    ++n2;
                }
                if (this.publisherOptions != null) {
                    if (this.publisherOptions.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "publisher-options", n2));
                    }
                    ++n2;
                }
                if (this.driverState != null) {
                    if (this.driverState.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "driver-state", n2));
                    }
                    ++n2;
                }
                if (this.subscriberState != null) {
                    if (this.subscriberState.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "subscriber-state", n2));
                    }
                    ++n2;
                }
                if (this.publisherState != null) {
                    if (this.publisherState.position() > n2) {
                        throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "publisher-state", n2));
                    }
                    ++n2;
                }
            }
        }
    }

    private void parseAttributes() {
        this.srcDN = this.attributeValueGet("src-dn");
    }

    boolean uniqueParams() {
        return this.unique;
    }

    public String rdn() {
        if (this.srcDN == null) {
            return null;
        }
        int n = this.srcDN.lastIndexOf("\\");
        String string = n == -1 ? this.srcDN : this.srcDN.substring(n + 1, this.srcDN.length());
        return "".compareTo(string) == 0 ? null : string;
    }

    public String treeName() {
        if (this.srcDN == null) {
            return null;
        }
        int n = this.srcDN.indexOf("\\");
        int n2 = this.srcDN.indexOf("\\", n + 1);
        String string = n == -1 ? this.srcDN : (n2 == -1 ? this.srcDN.substring(n + 1, this.srcDN.length()) : this.srcDN.substring(n + 1, n2));
        return "".compareTo(string) == 0 ? null : string;
    }

    public String containerDN() {
        if (this.srcDN == null) {
            return null;
        }
        int n = this.srcDN.lastIndexOf("\\");
        String string = n == -1 ? this.srcDN : this.srcDN.substring(0, n);
        return "".compareTo(string) == 0 ? null : string;
    }

    public String getSrcDN() {
        return this.srcDN;
    }

    public XDSDriverFilterElement extractDriverFilterElement() {
        return this.driverFilter;
    }

    public DriverFilter driverFilter() {
        if (this.driverFilter == null) {
            return new DriverFilter();
        }
        return new DriverFilter(this.driverFilter.domElement());
    }

    public XDSDriverOptionsElement extractDriverOptionsElement() {
        return this.driverOptions;
    }

    public XDSSubscriberOptionsElement extractSubscriberOptionsElement() {
        return this.subscriberOptions;
    }

    public XDSPublisherOptionsElement extractPublisherOptionsElement() {
        return this.publisherOptions;
    }

    public XDSDriverStateElement extractDriverStateElement() {
        return this.driverState;
    }

    public XDSSubscriberStateElement extractSubscriberStateElement() {
        return this.subscriberState;
    }

    public XDSPublisherStateElement extractPublisherStateElement() {
        return this.publisherState;
    }

    public XDSAuthenticationInfoElement extractAuthenticationInfoElement() {
        return this.authenticationInfo;
    }

    Map paramMap() {
        return this.paramMap;
    }

    private void addToMap(ParamParent paramParent) {
        ListIterator listIterator = paramParent.childElements().listIterator();
        while (listIterator.hasNext()) {
            ParamElement paramElement;
            Object object = listIterator.next();
            if (!(object instanceof ParamElement) || (object = this.paramMap.put((paramElement = (ParamElement)object).tagName(), paramElement)) == null) continue;
            this.unique = false;
        }
    }

    private void setAuthenticationInfo(XDSAuthenticationInfoElement xDSAuthenticationInfoElement) {
        if (this.authenticationInfo == null) {
            this.authenticationInfo = xDSAuthenticationInfoElement;
            this.addToMap(this.authenticationInfo);
        }
        this.noOfElements[0] = this.noOfElements[0] + 1;
    }

    private void setDriverFilter(XDSDriverFilterElement xDSDriverFilterElement) {
        if (this.driverFilter == null) {
            this.driverFilter = xDSDriverFilterElement;
        }
        this.noOfElements[1] = this.noOfElements[1] + 1;
    }

    private void setDriverState(XDSDriverStateElement xDSDriverStateElement) {
        if (this.driverState == null) {
            this.driverState = xDSDriverStateElement;
            this.addToMap(this.driverState);
        }
        this.noOfElements[2] = this.noOfElements[2] + 1;
    }

    private void setPublisherState(XDSPublisherStateElement xDSPublisherStateElement) {
        if (this.publisherState == null) {
            this.publisherState = xDSPublisherStateElement;
            this.addToMap(this.publisherState);
        }
        this.noOfElements[3] = this.noOfElements[3] + 1;
    }

    private void setSubscriberState(XDSSubscriberStateElement xDSSubscriberStateElement) {
        if (this.subscriberState == null) {
            this.subscriberState = xDSSubscriberStateElement;
            this.addToMap(this.subscriberState);
        }
        this.noOfElements[4] = this.noOfElements[4] + 1;
    }

    private void setDriverOptions(XDSDriverOptionsElement xDSDriverOptionsElement) {
        if (this.driverOptions == null) {
            this.driverOptions = xDSDriverOptionsElement;
            this.addToMap(this.driverOptions);
        }
        this.noOfElements[5] = this.noOfElements[5] + 1;
    }

    private void setPublisherOptions(XDSPublisherOptionsElement xDSPublisherOptionsElement) {
        if (this.publisherOptions == null) {
            this.publisherOptions = xDSPublisherOptionsElement;
            this.addToMap(this.publisherOptions);
        }
        this.noOfElements[6] = this.noOfElements[6] + 1;
    }

    private void setSubscriberOptions(XDSSubscriberOptionsElement xDSSubscriberOptionsElement) {
        if (this.subscriberOptions == null) {
            this.subscriberOptions = xDSSubscriberOptionsElement;
            this.addToMap(this.subscriberOptions);
        }
        this.noOfElements[7] = this.noOfElements[7] + 1;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("authentication-info".compareTo(string) == 0) {
            elementImpl = new XDSAuthenticationInfoElement(element, this.document);
            this.setAuthenticationInfo((XDSAuthenticationInfoElement)elementImpl);
        } else if ("driver-filter".compareTo(string) == 0) {
            elementImpl = new XDSDriverFilterElement(element, this.document);
            this.setDriverFilter((XDSDriverFilterElement)elementImpl);
        } else if ("driver-state".compareTo(string) == 0) {
            elementImpl = new XDSDriverStateElement(element, this.document);
            this.setDriverState((XDSDriverStateElement)elementImpl);
        } else if ("publisher-state".compareTo(string) == 0) {
            elementImpl = new XDSPublisherStateElement(element, this.document);
            this.setPublisherState((XDSPublisherStateElement)elementImpl);
        } else if ("subscriber-state".compareTo(string) == 0) {
            elementImpl = new XDSSubscriberStateElement(element, this.document);
            this.setSubscriberState((XDSSubscriberStateElement)elementImpl);
        } else if ("driver-options".compareTo(string) == 0) {
            elementImpl = new XDSDriverOptionsElement(element, this.document);
            this.setDriverOptions((XDSDriverOptionsElement)elementImpl);
        } else if ("publisher-options".compareTo(string) == 0) {
            elementImpl = new XDSPublisherOptionsElement(element, this.document);
            this.setPublisherOptions((XDSPublisherOptionsElement)elementImpl);
        } else if ("subscriber-options".compareTo(string) == 0) {
            elementImpl = new XDSSubscriberOptionsElement(element, this.document);
            this.setSubscriberOptions((XDSSubscriberOptionsElement)elementImpl);
        }
        return elementImpl;
    }

    XDSInitParamsElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "init-params");
    }

    public XDSDriverStateElement appendDriverStateElement() {
        if (this.driverState == null) {
            this.driverState = new XDSDriverStateElement(this.document, this.element);
        }
        return this.driverState;
    }

    public XDSPublisherStateElement appendPublisherStateElement() {
        if (this.publisherState == null) {
            this.publisherState = new XDSPublisherStateElement(this.document, this.element);
        }
        return this.publisherState;
    }

    public XDSSubscriberStateElement appendSubscriberStateElement() {
        if (this.subscriberState == null) {
            this.subscriberState = new XDSSubscriberStateElement(this.document, this.element);
        }
        return this.subscriberState;
    }

    static {
        XDSInitParamsElement.TAG_NAMES[1] = "driver-filter";
        XDSInitParamsElement.TAG_NAMES[0] = "authentication-info";
        XDSInitParamsElement.TAG_NAMES[2] = "driver-state";
        XDSInitParamsElement.TAG_NAMES[3] = "publisher-state";
        XDSInitParamsElement.TAG_NAMES[4] = "subscriber-state";
        XDSInitParamsElement.TAG_NAMES[5] = "driver-options";
        XDSInitParamsElement.TAG_NAMES[6] = "publisher-options";
        XDSInitParamsElement.TAG_NAMES[7] = "subscriber-options";
    }
}

