/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.SomeAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyAttrElement
extends ElementImpl
implements SomeAttrElement {
    private String attrName;

    private void init() {
        this.attrName = null;
    }

    XDSModifyAttrElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.attrName = this.attributeValueGet("attr-name");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.attrName == null) {
                this.throwMissingAttributeException("attr-name");
            }
            if (this.children() == Collections.EMPTY_LIST) {
                throw new XDSParseException(Errors.NoChildElements("modify-attr"));
            }
        }
    }

    public String getAttrName() {
        return Lib.SomeAttrElement_getAttrName(this, this.attrName);
    }

    public List childElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("remove-value".compareTo(string) == 0) {
            elementImpl = new XDSRemoveValueElement(element, this.document);
        } else if ("remove-all-values".compareTo(string) == 0) {
            elementImpl = new XDSRemoveAllValuesElement(element, this.document);
        } else if ("add-value".compareTo(string) == 0) {
            elementImpl = new XDSAddValueElement(element, this.document);
        }
        return elementImpl;
    }

    XDSModifyAttrElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "modify-attr");
    }

    public void setAttrName(String string) {
        Lib.SomeAttrElement_setAttrName(this, string);
    }

    public XDSAddValueElement appendAddValueElement() {
        return new XDSAddValueElement(this.document, this.element);
    }

    public XDSRemoveValueElement appendRemoveValueElement() {
        return new XDSRemoveValueElement(this.document, this.element);
    }

    public XDSRemoveAllValuesElement appendRemoveAllValuesElement() {
        return new XDSRemoveAllValuesElement(this.document, this.element);
    }
}

