/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private List modifyAttrs;
    private int noOfAssociations;
    private String className;

    private void init() {
        this.association = null;
        this.className = null;
        this.noOfAssociations = 0;
        this.modifyAttrs = Collections.EMPTY_LIST;
    }

    XDSModifyElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.document.context == 1 && this.className == null) {
                throw new XDSParseException(Errors.NoAttributeValue("class-name"));
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            if (this.children() == Collections.EMPTY_LIST) {
                throw new XDSParseException(Errors.NoElement("modify-attr"));
            }
        }
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    public List childElements() {
        return super.childElements();
    }

    public List extractModifyAttrElements() {
        return Lib.GetElements(this, this.modifyAttrs);
    }

    private List modifyAttrs(int n) {
        if (this.modifyAttrs == Collections.EMPTY_LIST) {
            this.modifyAttrs = new ArrayList(n);
        }
        return this.modifyAttrs;
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("modify-attr".equals(string)) {
            elementImpl = new XDSModifyAttrElement(element, this.document);
            this.modifyAttrs(n2).add(elementImpl);
        } else if ("association".compareTo(string) == 0) {
            elementImpl = new XDSAssociationElement(element, this.document);
            this.setAssociation((XDSAssociationElement)elementImpl);
        }
        return elementImpl;
    }

    XDSModifyElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "modify");
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public XDSModifyAttrElement appendModifyAttrElement() {
        return new XDSModifyAttrElement(this.document, this.element);
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }
}

