/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.List;
import org.w3c.dom.Element;

public class XDSMoveElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSParentElement parentElement;
    private int noOfParents;

    private void init() {
        this.association = null;
        this.noOfAssociations = 0;
        this.parentElement = null;
        this.noOfParents = 0;
    }

    XDSMoveElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            if (this.parentElement == null) {
                throw new XDSParseException(Errors.NoElement("parent"));
            }
            if (this.noOfParents > 1) {
                throw new XDSParseException(Errors.DuplicateElement("parent"));
            }
        }
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getQualifiedOldSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-old-src-dn");
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getOldSrcDN() {
        return Lib.GetAttributeValue(this, "old-src-dn");
    }

    public XDSParentElement extractParentElement() {
        return this.parentElement;
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setParent(XDSParentElement xDSParentElement) {
        if (this.parentElement == null) {
            this.parentElement = xDSParentElement;
        }
        ++this.noOfParents;
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("parent".compareTo(string) == 0) {
            elementImpl = new XDSParentElement(element, this.document);
            this.setParent((XDSParentElement)elementImpl);
        } else if ("association".compareTo(string) == 0) {
            elementImpl = new XDSAssociationElement(element, this.document);
            this.setAssociation((XDSAssociationElement)elementImpl);
        }
        return elementImpl;
    }

    public List childElements() {
        return this.childElements();
    }

    XDSMoveElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "move");
    }

    public XDSParentElement appendParentElement() {
        return new XDSParentElement(this.document, this.element);
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public void setOldSrcDN(String string) {
        this.attributeValueSet("old-src-dn", string);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }
}

