/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DNFormat;
import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSClassDefElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import org.w3c.dom.Element;

public class XDSSchemaDefElement
extends ElementImpl {
    private static final _Boolean DEFAULT_HIERARCHICAL = _Boolean.FALSE;
    private _Boolean hierarchical;

    private void init() {
        this.hierarchical = DEFAULT_HIERARCHICAL;
    }

    XDSSchemaDefElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.hierarchical.equals(_Boolean.ILLEGAL)) {
            throw new XDSParseException(Errors.BadBooleanType(this.hierarchical.toString()));
        }
    }

    private void parseAttributes() throws XDSParseException {
        this.hierarchical = Lib.ToBoolean(this.attributeValueGet("hierarchical"), DEFAULT_HIERARCHICAL);
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSClassDefElement xDSClassDefElement = null;
        if ("class-def".compareTo(string) == 0) {
            xDSClassDefElement = new XDSClassDefElement(element, this.document);
        }
        return xDSClassDefElement;
    }

    String getApplicationName() {
        return this.attributeValueGet("application-name");
    }

    boolean getHierarchical() {
        return this.hierarchical.toPrimitive();
    }

    XDSSchemaDefElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "schema-def");
    }

    public void setApplicationName(String string) {
        this.attributeValueSet("application-name", string);
    }

    public void setHierarchical(boolean bl) {
        this.attributeValueSet("hierarchical", DTD.GetStringValue(bl));
    }

    public void setDNFormat(DNFormat dNFormat) {
        this.setAttributeValue("dn-format", dNFormat, DTDVersion.V2_0);
    }

    public void setDNDelims(String string) {
        this.setAttributeValue("dn-delims", string, DTDVersion.V2_0);
    }

    public XDSClassDefElement appendClassDefElement() {
        return new XDSClassDefElement(this.document, this.element);
    }
}

