/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DescriptionElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.ExceptionElement;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDSStatusElement
extends ElementImpl
implements TextParent,
Comparable {
    private static final String TAG_DOCUMENT = "document";
    private static final String COMMENT_SUPPRESSED = "content suppressed";
    private String level;
    private StatusLevel statusLevel;
    private StatusType statusType;
    private DescriptionElement description;
    private String text;

    private void init() {
        this.level = null;
        this.statusLevel = null;
        this.statusType = null;
        this.description = null;
        this.text = "";
        this.anyContent = true;
    }

    XDSStatusElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    protected void passText(String string) throws XDSParseException {
        this.text = this.text + string;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.statusLevel == null) {
            if (this.level == null) {
                this.throwMissingAttributeException("level");
            } else {
                throw new XDSParseException(Errors.BadAttributeValue("level", this.level));
            }
        }
    }

    private void parseAttributes() throws XDSParseException {
        this.level = this.attributeValueGet("level");
        this.statusLevel = StatusLevel.Lookup(this.level);
        this.statusType = StatusType.Lookup(this.attributeValueGet("type"));
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        DescriptionElement descriptionElement = null;
        if ("description".compareTo(string) == 0) {
            this.description = descriptionElement = new DescriptionElement(element, this.document);
        }
        return descriptionElement;
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public StatusType getType() {
        return this.statusType;
    }

    public StatusLevel getLevel() {
        return this.statusLevel;
    }

    public String getEventID() {
        return Lib.GetAttributeValue(this, "event-id");
    }

    public DescriptionElement descriptionElementExtract() {
        return this.description;
    }

    public String descriptionTextExtract() {
        return Lib.GetText(this, this.description);
    }

    XDSStatusElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "status");
    }

    public void setLevel(StatusLevel statusLevel) {
        if (statusLevel != null) {
            this.element.setAttribute("level", statusLevel.toString());
        }
    }

    public void setType(StatusType statusType) {
        this.setAttributeValue("type", statusType, DTDVersion.V1_1);
    }

    public void setEventID(String string) {
        this.attributeValueSet("event-id", string);
    }

    public void appendText(String string) {
        Lib.TextParent_appendText(this, string);
    }

    public void parametersAppend(Map map) {
        Lib.CheckParam(map, "params");
        Collection collection = map.values();
        if (collection.size() > 0) {
            ArrayList arrayList = new ArrayList(collection.size());
            arrayList.addAll(collection);
            Collections.sort(arrayList);
            Document document = this.domDocument();
            Element element = document.createElement("parameters");
            this.element.appendChild(element);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Parameter parameter = (Parameter)listIterator.next();
                Element element2 = document.createElement(parameter.tagName());
                String string = parameter.getDescription();
                if (string != null) {
                    element2.setAttribute("display-name", string);
                }
                CharacterData characterData = parameter.isContentSensitive() ? document.createComment("content suppressed!") : document.createTextNode(parameter.toString());
                element2.appendChild(characterData);
                element.appendChild(element2);
            }
        }
    }

    public void descriptionAppend(String string) {
        if (Lib.IsValue(string)) {
            DescriptionElement descriptionElement = new DescriptionElement(this.document, this.element);
            descriptionElement.appendText(string);
        }
    }

    public void documentAppend(XmlDocument xmlDocument) {
        if (xmlDocument != null) {
            Element element = this.document.document.createElement(TAG_DOCUMENT);
            this.element.appendChild(element);
            xmlDocument = XDSStatusElement.SuppressContent(xmlDocument);
            Node node = Lib.CloneSubtree(this.document.document, xmlDocument.getDocument().getDocumentElement());
            element.appendChild(node);
        }
    }

    private static XmlDocument SuppressContent(XmlDocument xmlDocument) {
        Node node;
        Node node2;
        Document document = xmlDocument.getDocument();
        NodeList nodeList = document.getElementsByTagName("password");
        Element element = document.createElement("password");
        Comment comment = document.createComment(COMMENT_SUPPRESSED);
        element.appendChild(comment);
        int n = 0;
        while (n < nodeList.getLength()) {
            node2 = nodeList.item(n);
            node = node2.getParentNode();
            if (node != null) {
                node.replaceChild(element, node2);
            }
            ++n;
        }
        nodeList = document.getElementsByTagName("old-password");
        element = document.createElement("old-password");
        comment = document.createComment(COMMENT_SUPPRESSED);
        element.appendChild(comment);
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            node2 = nodeList.item(n2);
            node = node2.getParentNode();
            if (node != null) {
                node.replaceChild(element, node2);
            }
            ++n2;
        }
        return new XmlDocument(document);
    }

    public void exceptionAppend(Exception exception, boolean bl) {
        if (exception != null) {
            ExceptionElement exceptionElement = new ExceptionElement(this.document, this.element);
            exceptionElement.attributeValueSet("class-name", exception.getClass().getName());
            exceptionElement.messageAppend(exception);
            if (bl) {
                exceptionElement.stackTraceAppend(exception);
            }
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (this.statusLevel == null) {
            return 1;
        }
        return this.statusLevel.compareTo(((XDSStatusElement)object).getLevel());
    }
}

