/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.nds.schema.extend;

import java.util.StringTokenizer;
import java.util.Vector;

class ASNOne {
    static final int FIRST_OCTET_MULTIPLIER = 40;
    static final int RADIX = 128;
    static final byte OID_TAG_BYTE = 6;
    static final int MAX_ASN1_NAME = 32;
    static final int ERR_INVALID_IDENTITY = -677;
    static final int ERR_INSUFFICIENT_BUFFER = -649;
    byte[] asn1;
    String ldapString;

    public ASNOne(String string) {
        this.ldapString = string;
        if (this.ldapString != null) {
            this.asn1 = this.getASN1ID();
        }
    }

    public ASNOne(byte[] byArray) {
        this.asn1 = byArray;
        if (this.asn1 == null || this.Asn1IDToLdapOdi() != 0) {
            this.ldapString = new String("");
        }
    }

    private int Asn1IDToLdapOdi() {
        long l;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.asn1 == null || this.asn1[n2] == 0) {
            return -677;
        }
        if ((l = (long)this.asn1[n2++]) != 6L) {
            return -677;
        }
        if ((n = this.asn1[n2++]) > 127 || n < 2) {
            return -677;
        }
        l = (long)this.asn1[n2] / 40L;
        stringBuffer.append(l);
        l = (long)this.asn1[n2++] % 40L;
        stringBuffer.append("." + l);
        n = n + n2 - 1;
        while (n2 < n) {
            l = 0L;
            while ((this.asn1[n2] & 0x80) == 128) {
                l = 128L * l + ((long)this.asn1[n2++] & 0x7FL);
            }
            l = 128L * l + (long)this.asn1[n2++];
            stringBuffer.append("." + l);
        }
        this.ldapString = new String(stringBuffer.toString());
        return 0;
    }

    public String getOid() {
        return this.ldapString;
    }

    public byte[] getAsn1() {
        return this.asn1;
    }

    public byte[] getNullAsn1() {
        return new byte[32];
    }

    private byte[] getASN1ID() {
        if (this.asn1 == null) {
            Vector<Byte> vector = null;
            if (this.ldapString != null) {
                Byte by;
                StringTokenizer stringTokenizer = new StringTokenizer(this.ldapString, ".");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                if (stringArray.length == 0) {
                    return null;
                }
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                String string = stringArray[0];
                String string2 = null;
                if (stringArray.length > 2) {
                    string2 = stringArray[1];
                }
                if ((by = this.firstOctetEncoder(string, string2)) != null) {
                    if (vector == null) {
                        vector = new Vector<Byte>();
                    }
                    vector.addElement(by);
                    int n2 = 2;
                    while (n2 < stringArray.length) {
                        byte[] byArray = this.parseLDAPComponent(stringArray[n2]);
                        if (byArray == null) {
                            vector = null;
                            break;
                        }
                        int n3 = 0;
                        while (n3 < byArray.length) {
                            vector.addElement(new Byte(byArray[n3]));
                            ++n3;
                        }
                        ++n2;
                    }
                    if (vector != null) {
                        Object[] objectArray = new Byte[vector.size()];
                        vector.copyInto(objectArray);
                        this.asn1 = new byte[32];
                        this.asn1[0] = 6;
                        this.asn1[1] = (byte)objectArray.length;
                        int n4 = 2;
                        int n5 = 0;
                        while (n4 < this.asn1.length && n5 < objectArray.length) {
                            this.asn1[n4] = (Byte)objectArray[n5];
                            ++n4;
                            ++n5;
                        }
                    }
                }
            }
        }
        return this.asn1;
    }

    protected Byte firstOctetEncoder(String string, String string2) {
        byte by = 0;
        Byte by2 = null;
        boolean bl = false;
        try {
            byte by3 = Byte.valueOf(string);
            if (by3 >= 0 && by3 < 3) {
                if (string2 != null && ((by = Byte.valueOf(string2).byteValue()) < 0 || by > 39)) {
                    bl = true;
                }
                if (!bl) {
                    by2 = new Byte((byte)(40 * by3 + by));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return by2;
    }

    public byte[] parseLDAPComponent(String string) {
        byte[] byArray = null;
        Vector<Byte> vector = null;
        try {
            long l = Long.parseLong(string);
            do {
                byte by = (byte)(l % 128L);
                l /= 128L;
                if (vector == null) {
                    vector = new Vector<Byte>();
                }
                vector.addElement(new Byte(by));
            } while (l != 0L);
        }
        catch (NumberFormatException numberFormatException) {}
        if (vector != null) {
            byArray = new byte[vector.size()];
            int n = byArray.length - 1;
            int n2 = 0;
            while (n > 0) {
                byArray[n2] = (byte)((Byte)vector.elementAt(n) | 0x80);
                --n;
                ++n2;
            }
            byArray[n2] = (Byte)vector.elementAt(0);
        }
        return byArray;
    }

    public String toString() {
        return this.ldapString;
    }
}

