/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.nds.schema.extend;

import com.novell.utility.nds.schema.extend.ASN1ID;
import com.novell.utility.nds.schema.extend.AttributeDefinition;
import com.novell.utility.nds.schema.extend.ClassDefinition;
import com.novell.utility.nds.schema.extend.CommentFilter;
import com.novell.utility.nds.schema.extend.SchemaSymbolTable;
import com.novell.utility.nds.schema.extend.SchemaTokenizer;
import com.novell.utility.nds.schema.extend.TokenizerState;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

class SchemaParser {
    private static final TokenizerState normal = new TokenizerState();
    private static final TokenizerState rule = new TokenizerState();
    InputStream in;

    public SchemaParser(InputStream inputStream) {
        this.in = new CommentFilter(inputStream);
    }

    private void forceRuleOperator(SchemaTokenizer schemaTokenizer) throws IOException {
        rule.applySelf(schemaTokenizer);
        schemaTokenizer.forceToken(1536);
        normal.applySelf(schemaTokenizer);
    }

    public SchemaSymbolTable parseSchema() throws IOException {
        SchemaTokenizer schemaTokenizer = new SchemaTokenizer(this.in);
        String string = schemaTokenizer.getWord();
        ASN1ID aSN1ID = schemaTokenizer.peekASN1ID();
        SchemaSymbolTable schemaSymbolTable = new SchemaSymbolTable(string, aSN1ID);
        schemaTokenizer.forceToken(768);
        this.forceRuleOperator(schemaTokenizer);
        schemaTokenizer.forceToken(256);
        while (schemaTokenizer.peekToken() != 512) {
            String string2 = schemaTokenizer.getWord();
            int n = schemaTokenizer.peekToken();
            switch (n) {
                case 1024: {
                    schemaSymbolTable.addClassDefinition(this.parseClassDefinition(schemaTokenizer, string2));
                    break;
                }
                case 1280: {
                    schemaSymbolTable.addAttributeDefinition(this.parseAttributeDefinition(schemaTokenizer, string2));
                    break;
                }
                default: {
                    schemaTokenizer.throwError("invalid definition token: 0x" + Integer.toHexString(n));
                    break;
                }
            }
        }
        schemaTokenizer.forceToken(512);
        return schemaSymbolTable;
    }

    private ClassDefinition parseClassDefinition(SchemaTokenizer schemaTokenizer, String string) throws IOException {
        schemaTokenizer.forceToken(1024);
        this.forceRuleOperator(schemaTokenizer);
        schemaTokenizer.forceToken(123);
        String[] stringArray = null;
        String[] stringArray2 = null;
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        boolean bl = true;
        block5: while (schemaTokenizer.peekToken() != 125) {
            if (!bl) {
                schemaTokenizer.forceToken(44);
            }
            bl = false;
            int n = schemaTokenizer.nextToken();
            switch (n) {
                case 4608: {
                    stringArray = (String[])this.getClassDefinitionMember(schemaTokenizer, n);
                    hashtable.put(new Integer(n), stringArray);
                    continue block5;
                }
                case 4864: {
                    stringArray2 = (String[])this.getClassDefinitionMember(schemaTokenizer, n);
                    hashtable.put(new Integer(n), stringArray2);
                    continue block5;
                }
                case 4096: 
                case 4352: 
                case 5120: 
                case 5376: 
                case 5632: 
                case 5888: {
                    hashtable.put(new Integer(n), this.getClassDefinitionMember(schemaTokenizer, n));
                    continue block5;
                }
            }
            schemaTokenizer.throwError("invalid class param: 0x" + Integer.toHexString(n));
        }
        schemaTokenizer.forceToken(125);
        ClassDefinition classDefinition = new ClassDefinition(string, stringArray, stringArray2);
        classDefinition.setMembers(hashtable);
        return classDefinition;
    }

    private Object getClassDefinitionMember(SchemaTokenizer schemaTokenizer, int n) throws IOException {
        switch (n) {
            case 4096: {
                return new Integer(schemaTokenizer.getOperation());
            }
            case 4352: {
                return new Integer(schemaTokenizer.getClassFlags());
            }
            case 4608: 
            case 4864: 
            case 5120: 
            case 5376: 
            case 5632: {
                return schemaTokenizer.getWordList();
            }
            case 5888: {
                return schemaTokenizer.getASN1ID();
            }
        }
        return null;
    }

    private AttributeDefinition parseAttributeDefinition(SchemaTokenizer schemaTokenizer, String string) throws IOException {
        schemaTokenizer.forceToken(1280);
        this.forceRuleOperator(schemaTokenizer);
        schemaTokenizer.forceToken(123);
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        boolean bl = true;
        block3: while (schemaTokenizer.peekToken() != 125) {
            if (!bl) {
                schemaTokenizer.forceToken(44);
            }
            bl = false;
            int n = schemaTokenizer.nextToken();
            switch (n) {
                case 4096: 
                case 4352: 
                case 5888: 
                case 6144: 
                case 6400: 
                case 6656: {
                    hashtable.put(new Integer(n), this.getAttributeDefinitionMember(schemaTokenizer, n));
                    continue block3;
                }
            }
            schemaTokenizer.throwError("invalid attribute param: 0x" + Integer.toHexString(n));
        }
        schemaTokenizer.forceToken(125);
        AttributeDefinition attributeDefinition = new AttributeDefinition(string);
        attributeDefinition.setMembers(hashtable);
        return attributeDefinition;
    }

    private Object getAttributeDefinitionMember(SchemaTokenizer schemaTokenizer, int n) throws IOException {
        switch (n) {
            case 4096: {
                return new Integer(schemaTokenizer.getOperation());
            }
            case 6144: {
                return new Integer(schemaTokenizer.getSyntaxID());
            }
            case 6400: 
            case 6656: {
                return new Integer(schemaTokenizer.getInteger());
            }
            case 4352: {
                return new Integer(schemaTokenizer.getAttributeFlags());
            }
            case 5888: {
                return schemaTokenizer.getASN1ID();
            }
        }
        return null;
    }

    static {
        normal.wordChars(97, 122);
        normal.wordChars(65, 90);
        normal.wordChars(95, 95);
        normal.wordChars(160, 255);
        normal.whitespaceChars(0, 32);
        normal.commentChar(47);
        normal.quoteChar(34);
        normal.quoteChar(39);
        normal.parseNumbers();
        rule.resetSyntax();
        rule.wordChars(58, 58);
        rule.wordChars(61, 61);
        rule.whitespaceChars(0, 32);
    }
}

