/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.nds.schema.extend;

import com.novell.utility.nds.schema.extend.ASN1ID;
import com.novell.utility.nds.schema.extend.AttributeDefinition;
import com.novell.utility.nds.schema.extend.ClassDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class SchemaSymbolTable {
    Hashtable classDefinitions = new Hashtable();
    Hashtable attributeDefinitions = new Hashtable();
    String name;
    ASN1ID id;

    public SchemaSymbolTable(String string, ASN1ID aSN1ID) {
        this.name = string;
        this.id = aSN1ID;
    }

    public String getName() {
        return this.name;
    }

    public ASN1ID getASN1ID() {
        return this.id;
    }

    public void addClassDefinition(ClassDefinition classDefinition) {
        this.classDefinitions.put(classDefinition.getName().toLowerCase(), classDefinition);
    }

    public void addAttributeDefinition(AttributeDefinition attributeDefinition) {
        this.attributeDefinitions.put(attributeDefinition.getName().toLowerCase(), attributeDefinition);
    }

    private void pushDependentClassDefs(Stack stack, ClassDefinition classDefinition) {
        int n;
        stack.push(classDefinition);
        String[] stringArray = classDefinition.getParentNames();
        String[] stringArray2 = classDefinition.getContainedByNames();
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                classDefinition = (ClassDefinition)this.classDefinitions.get(stringArray2[n].toLowerCase());
                if (classDefinition != null) {
                    this.pushDependentClassDefs(stack, classDefinition);
                }
                ++n;
            }
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                classDefinition = (ClassDefinition)this.classDefinitions.get(stringArray[n].toLowerCase());
                if (classDefinition != null) {
                    this.pushDependentClassDefs(stack, classDefinition);
                }
                ++n;
            }
        }
    }

    public Enumeration getClassDefinitions() {
        Enumeration enumeration = this.classDefinitions.elements();
        new Vector();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
            Stack stack = new Stack();
            this.pushDependentClassDefs(stack, classDefinition);
            while (!stack.empty()) {
                Object e = stack.pop();
                if (vector.contains(e)) continue;
                vector.addElement(e);
            }
        }
        return vector.elements();
    }

    public Enumeration getAttributeDefinitions() {
        return this.attributeDefinitions.elements();
    }

    public ClassDefinition getClassDefinition(String string) {
        return (ClassDefinition)this.classDefinitions.get(string.toLowerCase());
    }

    public AttributeDefinition getAttributeDefinition(String string) {
        return (AttributeDefinition)this.attributeDefinitions.get(string.toLowerCase());
    }
}

