/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.nds.schema.extend;

import com.novell.utility.nds.schema.extend.ASN1ID;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;

class SchemaTokenizer
extends StreamTokenizer {
    private static Hashtable tokens = new Hashtable();
    private static Hashtable classFlags;
    private static Hashtable attrFlags;
    private static Hashtable syntaxes;
    private static Hashtable operations;
    public static final int TT_BEGIN = 256;
    public static final int TT_END = 512;
    public static final int TT_DEFINITIONS = 768;
    public static final int TT_OBJECT_CLASS = 1024;
    public static final int TT_ATTRIBUTE = 1280;
    public static final int TT_RULE_OPERATOR = 1536;
    public static final int TT_OPERATION = 4096;
    public static final int TT_FLAGS = 4352;
    public static final int TT_SUBCLASSOF = 4608;
    public static final int TT_CONTAINEDBY = 4864;
    public static final int TT_NAMEDBY = 5120;
    public static final int TT_MUSTCONTAIN = 5376;
    public static final int TT_MAYCONTAIN = 5632;
    public static final int TT_ASN1OBJID = 5888;
    public static final int TT_SYNTAXID = 6144;
    public static final int TT_LOWERBOUND = 6400;
    public static final int TT_UPPERBOUND = 6656;
    public static final int DS_CONTAINER_CLASS = 1;
    public static final int DS_EFFECTIVE_CLASS = 2;
    public static final int DS_NONREMOVABLE_CLASS = 4;
    public static final int DS_AMBIGUOUS_NAMING = 8;
    public static final int DS_AMBIGUOUS_CONTAINMENT = 16;
    public static final int DS_AUXILIARY_CLASS = 32;
    public static final int DS_OPERATIONAL_CLASS = 64;
    public static final int DS_SINGLE_VALUED_ATTR = 1;
    public static final int DS_SIZED_ATTR = 2;
    public static final int DS_NONREMOVABLE_ATTR = 4;
    public static final int DS_READ_ONLY_ATTR = 8;
    public static final int DS_HIDDEN_ATTR = 16;
    public static final int DS_STRING_ATTR = 32;
    public static final int DS_SYNC_IMMEDIATE = 64;
    public static final int DS_PUBLIC_READ = 128;
    public static final int DS_SERVER_READ = 256;
    public static final int DS_WRITE_MANAGED = 512;
    public static final int DS_PER_REPLICA = 1024;
    public static final int DS_SCHEDULE_SYNC_NEVER = 2048;
    public static final int DS_OPERATIONAL = 4096;
    public static final int SYN_UNKNOWN = 0;
    public static final int SYN_DIST_NAME = 1;
    public static final int SYN_CE_STRING = 2;
    public static final int SYN_CI_STRING = 3;
    public static final int SYN_PR_STRING = 4;
    public static final int SYN_NU_STRING = 5;
    public static final int SYN_CI_LIST = 6;
    public static final int SYN_BOOLEAN = 7;
    public static final int SYN_INTEGER = 8;
    public static final int SYN_OCTET_STRING = 9;
    public static final int SYN_TEL_NUMBER = 10;
    public static final int SYN_FAX_NUMBER = 11;
    public static final int SYN_NET_ADDRESS = 12;
    public static final int SYN_OCTET_LIST = 13;
    public static final int SYN_EMAIL_ADDRESS = 14;
    public static final int SYN_PATH = 15;
    public static final int SYN_REPLICA_POINTER = 16;
    public static final int SYN_OBJECT_ACL = 17;
    public static final int SYN_PO_ADDRESS = 18;
    public static final int SYN_TIMESTAMP = 19;
    public static final int SYN_CLASS_NAME = 20;
    public static final int SYN_STREAM = 21;
    public static final int SYN_COUNTER = 22;
    public static final int SYN_BACK_LINK = 23;
    public static final int SYN_TIME = 24;
    public static final int SYN_TYPED_NAME = 25;
    public static final int SYN_HOLD = 26;
    public static final int SYN_INTERVAL = 27;
    public static final int OP_ADD = 0;
    public static final int OP_REMOVE = 1;
    public static final int OP_MODIFY = 2;

    public SchemaTokenizer(Reader reader) {
        super(reader);
    }

    public SchemaTokenizer(InputStream inputStream) {
        super(new InputStreamReader(inputStream));
    }

    public int nextToken() throws IOException {
        Integer n;
        int n2 = super.nextToken();
        if (n2 == -3 && (n = (Integer)tokens.get(this.sval)) != null) {
            n2 = n;
        }
        this.ttype = n2;
        return n2;
    }

    public String getWord() throws IOException {
        int n = this.nextToken();
        if (n == -3 || n == 39 || n == 34) {
            return this.sval;
        }
        this.throwError("invalid word; token = 0x" + Integer.toHexString(n));
        return null;
    }

    public int getInteger() throws IOException {
        if (this.nextToken() == -2) {
            return (int)this.nval;
        }
        this.throwError("invalid number");
        return 0;
    }

    public ASN1ID getASN1ID() throws IOException {
        int n;
        this.forceToken(123);
        Vector<Integer> vector = new Vector<Integer>();
        while ((n = this.peekToken()) != 125) {
            vector.addElement(new Integer(this.getInteger()));
        }
        this.forceToken(125);
        return new ASN1ID(vector);
    }

    public ASN1ID peekASN1ID() throws IOException {
        if (this.peekToken() == 123) {
            return this.getASN1ID();
        }
        return null;
    }

    public int getClassFlags() throws IOException {
        return this.getFlags(classFlags);
    }

    public int getAttributeFlags() throws IOException {
        return this.getFlags(attrFlags);
    }

    private int getFlags(Hashtable hashtable) throws IOException {
        this.forceToken(123);
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = true;
        while (this.peekToken() != 125) {
            if (!bl) {
                this.forceToken(44);
            }
            bl = false;
            String string = this.getWord();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) {
                this.throwError("invalid flag: " + string);
            }
            vector.addElement(n);
        }
        this.forceToken(125);
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            n |= ((Integer)vector.elementAt(n2)).intValue();
            ++n2;
        }
        return n;
    }

    public int getSyntaxID() throws IOException {
        String string = this.getWord();
        Integer n = (Integer)syntaxes.get(string);
        if (n == null) {
            this.throwError("invalid syntax: " + string);
        }
        return n;
    }

    public int getOperation() throws IOException {
        String string = this.getWord();
        Integer n = (Integer)operations.get(string);
        if (n == null) {
            this.throwError("invalid operation: " + string);
        }
        return n;
    }

    public String[] getWordList() throws IOException {
        this.forceToken(123);
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        while (this.peekToken() != 125) {
            if (!bl) {
                this.forceToken(44);
            }
            bl = false;
            vector.addElement(this.getWord());
        }
        this.forceToken(125);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int peekToken() throws IOException {
        int n = this.nextToken();
        this.pushBack();
        return n;
    }

    public void forceToken(int n) throws IOException {
        int n2 = this.nextToken();
        if (n2 != n) {
            this.throwError("expected token: 0x" + Integer.toHexString(n) + "; found: 0x" + Integer.toHexString(n2));
        }
    }

    protected void throwError(String string) throws IOException {
        if (string != null) {
            throw new IOException("line " + this.lineno() + ": " + string);
        }
        throw new IOException("line " + this.lineno());
    }

    static {
        tokens.put("BEGIN", new Integer(256));
        tokens.put("END", new Integer(512));
        tokens.put("DEFINITIONS", new Integer(768));
        tokens.put("OBJECT-CLASS", new Integer(1024));
        tokens.put("ATTRIBUTE", new Integer(1280));
        tokens.put("::=", new Integer(1536));
        tokens.put("Operation", new Integer(4096));
        tokens.put("Flags", new Integer(4352));
        tokens.put("SubClassOf", new Integer(4608));
        tokens.put("ContainedBy", new Integer(4864));
        tokens.put("NamedBy", new Integer(5120));
        tokens.put("MustContain", new Integer(5376));
        tokens.put("MayContain", new Integer(5632));
        tokens.put("ASN1ObjID", new Integer(5888));
        tokens.put("SyntaxID", new Integer(6144));
        tokens.put("LowerBound", new Integer(6400));
        tokens.put("UpperBound", new Integer(6656));
        classFlags = new Hashtable();
        classFlags.put("DS_CONTAINER_CLASS", new Integer(1));
        classFlags.put("DS_EFFECTIVE_CLASS", new Integer(2));
        classFlags.put("DS_NONREMOVABLE_CLASS", new Integer(4));
        classFlags.put("DS_AMBIGUOUS_NAMING", new Integer(8));
        classFlags.put("DS_AMBIGUOUS_CONTAINMENT", new Integer(16));
        classFlags.put("DS_AUXILIARY_CLASS", new Integer(32));
        classFlags.put("DS_OPERATIONAL_CLASS", new Integer(64));
        attrFlags = new Hashtable();
        attrFlags.put("DS_SINGLE_VALUED_ATTR", new Integer(1));
        attrFlags.put("DS_SIZED_ATTR", new Integer(2));
        attrFlags.put("DS_NONREMOVABLE_ATTR", new Integer(4));
        attrFlags.put("DS_READ_ONLY_ATTR", new Integer(8));
        attrFlags.put("DS_HIDDEN_ATTR", new Integer(16));
        attrFlags.put("DS_STRING_ATTR", new Integer(32));
        attrFlags.put("DS_SYNC_IMMEDIATE", new Integer(64));
        attrFlags.put("DS_PUBLIC_READ", new Integer(128));
        attrFlags.put("DS_SERVER_READ", new Integer(256));
        attrFlags.put("DS_WRITE_MANAGED", new Integer(512));
        attrFlags.put("DS_PER_REPLICA", new Integer(1024));
        attrFlags.put("DS_SCHEDULE_SYNC_NEVER", new Integer(2048));
        attrFlags.put("DS_OPERATIONAL", new Integer(4096));
        syntaxes = new Hashtable();
        syntaxes.put("SYN_UNKNOWN", new Integer(0));
        syntaxes.put("SYN_DIST_NAME", new Integer(1));
        syntaxes.put("SYN_CE_STRING", new Integer(2));
        syntaxes.put("SYN_CI_STRING", new Integer(3));
        syntaxes.put("SYN_PR_STRING", new Integer(4));
        syntaxes.put("SYN_NU_STRING", new Integer(5));
        syntaxes.put("SYN_CI_LIST", new Integer(6));
        syntaxes.put("SYN_BOOLEAN", new Integer(7));
        syntaxes.put("SYN_INTEGER", new Integer(8));
        syntaxes.put("SYN_OCTET_STRING", new Integer(9));
        syntaxes.put("SYN_TEL_NUMBER", new Integer(10));
        syntaxes.put("SYN_FAX_NUMBER", new Integer(11));
        syntaxes.put("SYN_NET_ADDRESS", new Integer(12));
        syntaxes.put("SYN_OCTET_LIST", new Integer(13));
        syntaxes.put("SYN_EMAIL_ADDRESS", new Integer(14));
        syntaxes.put("SYN_PATH", new Integer(15));
        syntaxes.put("SYN_REPLICA_POINTER", new Integer(16));
        syntaxes.put("SYN_OBJECT_ACL", new Integer(17));
        syntaxes.put("SYN_PO_ADDRESS", new Integer(18));
        syntaxes.put("SYN_TIMESTAMP", new Integer(19));
        syntaxes.put("SYN_CLASS_NAME", new Integer(20));
        syntaxes.put("SYN_STREAM", new Integer(21));
        syntaxes.put("SYN_COUNTER", new Integer(22));
        syntaxes.put("SYN_BACK_LINK", new Integer(23));
        syntaxes.put("SYN_TIME", new Integer(24));
        syntaxes.put("SYN_TYPED_NAME", new Integer(25));
        syntaxes.put("SYN_HOLD", new Integer(26));
        syntaxes.put("SYN_INTERVAL", new Integer(27));
        operations = new Hashtable();
        operations.put("ADD", new Integer(0));
        operations.put("REMOVE", new Integer(1));
        operations.put("MODIFY", new Integer(2));
    }
}

