/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.nds.schema.extend;

import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;

class TokenizerState
implements Cloneable {
    protected static final byte CT_ORDINARY = 0;
    protected static final byte CT_WHITESPACE = 1;
    protected static final byte CT_DIGIT = 2;
    protected static final byte CT_ALPHA = 3;
    protected static final byte CT_QUOTE = 4;
    protected static final byte CT_COMMENT = 5;
    boolean forceLower = false;
    boolean eolIsSignificantP = false;
    boolean slashSlashCommentsP = false;
    boolean slashStarCommentsP = false;
    boolean parseNumbers = false;
    Vector state = new Vector();

    public void resetSyntax() {
        this.state.removeAllElements();
        this.forceLower = false;
        this.eolIsSignificantP = false;
        this.slashSlashCommentsP = false;
        this.slashStarCommentsP = false;
        this.parseNumbers = false;
    }

    public void wordChars(int n, int n2) {
        this.state.addElement(new CharState(3, n, n2));
    }

    public void whitespaceChars(int n, int n2) {
        this.state.addElement(new CharState(1, n, n2));
    }

    public void ordinaryChars(int n, int n2) {
        this.state.addElement(new CharState(0, n, n2));
    }

    public void ordinaryChar(int n) {
        this.state.addElement(new CharState(0, n));
    }

    public void commentChar(int n) {
        this.state.addElement(new CharState(5, n));
    }

    public void quoteChar(int n) {
        this.state.addElement(new CharState(4, n));
    }

    public void parseNumbers() {
        this.parseNumbers = true;
    }

    public void eolIsSignificant(boolean bl) {
        this.eolIsSignificantP = bl;
    }

    public void slashStarComments(boolean bl) {
        this.slashStarCommentsP = bl;
    }

    public void slashSlashComments(boolean bl) {
        this.slashSlashCommentsP = bl;
    }

    public void applySelf(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.eolIsSignificant(this.eolIsSignificantP);
        streamTokenizer.slashStarComments(this.slashStarCommentsP);
        streamTokenizer.slashSlashComments(this.slashSlashCommentsP);
        if (this.parseNumbers) {
            streamTokenizer.parseNumbers();
        }
        Enumeration enumeration = this.state.elements();
        while (enumeration.hasMoreElements()) {
            ((CharState)enumeration.nextElement()).applySelf(streamTokenizer);
        }
    }

    TokenizerState() {
    }

    class CharState
    implements Cloneable {
        byte ctype;
        int low;
        int hi;
        boolean single;

        public CharState(byte by, int n) {
            TokenizerState.this = TokenizerState.this;
            this.ctype = by;
            this.low = n;
            this.hi = n;
            this.single = true;
        }

        public CharState(byte by, int n, int n2) {
            TokenizerState.this = TokenizerState.this;
            this.ctype = by;
            this.low = n;
            this.hi = n2;
            this.single = false;
        }

        public void applySelf(StreamTokenizer streamTokenizer) {
            if (this.single) {
                switch (this.ctype) {
                    case 0: {
                        streamTokenizer.ordinaryChar(this.low);
                        return;
                    }
                    case 4: {
                        streamTokenizer.quoteChar(this.low);
                        return;
                    }
                    case 5: {
                        streamTokenizer.commentChar(this.low);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (this.ctype) {
                case 0: {
                    streamTokenizer.ordinaryChars(this.low, this.hi);
                    return;
                }
                case 1: {
                    streamTokenizer.whitespaceChars(this.low, this.hi);
                    return;
                }
                case 3: {
                    streamTokenizer.wordChars(this.low, this.hi);
                    return;
                }
            }
        }
    }
}

