/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.SQLErrorCodes;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class BaseResultSet
implements ResultSet,
LDAPSQLExceptionCodes,
SQLErrorCodes {
    private SQLWarning m_firstWarning = null;
    private SQLWarning m_lastWarning = null;

    protected void addWarning(SQLWarning sQLWarning) {
        if (this.m_firstWarning == null) {
            this.m_firstWarning = sQLWarning;
        }
        if (this.m_lastWarning != null) {
            this.m_lastWarning.setNextWarning(sQLWarning);
        }
        this.m_lastWarning = sQLWarning;
    }

    public abstract boolean next() throws SQLException;

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public String getString(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "String");
    }

    public boolean getBoolean(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Boolean");
    }

    public byte getByte(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Byte");
    }

    public short getShort(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Short");
    }

    public int getInt(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Int");
    }

    public long getLong(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Long");
    }

    public float getFloat(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Float");
    }

    public double getDouble(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Double");
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "BigDecimal");
    }

    public byte[] getBytes(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "byte array");
    }

    public Date getDate(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Date");
    }

    public Time getTime(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Time");
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Timestamp");
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Ascii Stream");
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Unicode Stream");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Binary Stream");
    }

    public String getString(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "String");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Boolean");
    }

    public byte getByte(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Byte");
    }

    public short getShort(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Short");
    }

    public int getInt(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Int");
    }

    public long getLong(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Long");
    }

    public float getFloat(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Float");
    }

    public double getDouble(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Double");
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "BigDecimal");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Byte array");
    }

    public Date getDate(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Date");
    }

    public Time getTime(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Time");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Timestamp");
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Ascii stream");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Unicode stream");
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Binary stream");
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.m_lastWarning = null;
        this.m_firstWarning = null;
    }

    public String getCursorName() throws SQLException {
        throw Errors.sqlException(1, "Positioned update");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw Errors.sqlException(1, "ResultSet.getMetaData()");
    }

    public Object getObject(int n) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Object");
    }

    public Object getObject(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "Object");
    }

    public abstract int findColumn(String var1) throws SQLException;
}

