/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.BaseResultSet;
import com.novell.sql.Errors;
import com.novell.sql.LDAPResultSetMetaData;
import com.novell.sql.LDAPStatement;
import com.novell.sql.ObjectRef;
import com.novell.sql.Results;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.Value;
import com.novell.sql.ValueTimestamp;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class LDAPResultSet
extends BaseResultSet
implements SQLErrorCodes {
    LDAPStatement m_statement;
    ObjectRef m_valueRef;
    boolean m_wasNull;
    boolean m_closed;

    protected LDAPResultSet(LDAPStatement lDAPStatement) {
        this.m_statement = lDAPStatement;
        this.m_valueRef = new ObjectRef(null);
        this.m_wasNull = false;
        this.m_closed = false;
    }

    private Value GetValueObject(int n) throws SQLException {
        int n2 = Results.SQLGetData(this.m_statement, n, this.m_valueRef);
        if (n2 != 0) {
            throw Errors.sqlException(this.m_statement.getErrorCode(), this.m_statement.getErrorMsg());
        }
        this.m_wasNull = this.m_valueRef.object == null;
        return (Value)this.m_valueRef.object;
    }

    public boolean next() throws SQLException {
        int n = Results.SQLFetch(this.m_statement);
        if (n == 1037) {
            return false;
        }
        if (n != 0) {
            throw Errors.sqlException(n, this.m_statement.getErrorMsg());
        }
        return true;
    }

    public void close() throws SQLException {
        this.m_closed = true;
    }

    public boolean wasNull() throws SQLException {
        return this.m_wasNull;
    }

    public String getString(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return false;
        }
        return value.getBoolean();
    }

    public byte getByte(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return 0;
        }
        return value.getByte();
    }

    public short getShort(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return 0;
        }
        return value.getShort();
    }

    public int getInt(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return 0;
        }
        return value.getInt();
    }

    public long getLong(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return 0L;
        }
        return value.getLong();
    }

    public float getFloat(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return 0.0f;
        }
        return value.getFloat();
    }

    public double getDouble(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return 0.0;
        }
        return value.getDouble();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getBigDecimal();
    }

    public byte[] getBytes(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getBytes();
    }

    public Date getDate(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getDate();
    }

    public Time getTime(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getTime();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        ValueTimestamp valueTimestamp = (ValueTimestamp)this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return valueTimestamp.getTimestamp();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getAsciiStream();
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getUnicodeStream();
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getBinaryStream();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getBigDecimal(name)");
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getWarnings(name)");
    }

    public void clearWarnings() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getWarnings(name)");
    }

    public String getCursorName() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getCursorName(name)");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new LDAPResultSetMetaData(this.m_statement);
    }

    public Object getObject(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getObject();
    }

    public Object getObject(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getObject(name)");
    }

    public int findColumn(String string) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        if (resultSetMetaData == null) {
            return 0;
        }
        int n = 1;
        while (n <= resultSetMetaData.getColumnCount()) {
            if (string.equalsIgnoreCase(resultSetMetaData.getColumnName(n))) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public boolean absolute(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.absolute(row)");
    }

    public void afterLast() throws SQLException {
    }

    public void beforeFirst() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void deleteRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.deleteRow()");
    }

    public boolean first() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.first()");
    }

    public Array getArray(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getArray()");
    }

    public Array getArray(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getArray()");
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Value value = this.GetValueObject(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getBigDecimal();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw Errors.sqlException(9, "SQLType", "BigDecimal");
    }

    public Blob getBlob(int n) throws SQLException {
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getCharacterStream()");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getCharacterStream()");
    }

    public Clob getClob(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getClob()");
    }

    public Clob getClob(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getClob()");
    }

    public int getConcurrency() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getConcurrency()");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public int getFetchDirection() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getFetchDirection()");
    }

    public int getFetchSize() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getFetchSize()");
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public Ref getRef(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getRef()");
    }

    public int getRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getRow()");
    }

    public Statement getStatement() throws SQLException {
        return this.m_statement;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getTime()");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getTime()");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getTimestamp()");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getTimestamp()");
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public URL getURL(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getURL()");
    }

    public URL getURL(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.getURL()");
    }

    public void insertRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.insertRow()");
    }

    public void moveToCurrentRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.moveToCurrentRow()");
    }

    public void moveToInsertRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.moveToInsertRow()");
    }

    public void refreshRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.refreshRow()");
    }

    public void updateRow() throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.updateRow()");
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.updateRow()");
    }

    public void setFetchSize(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.setFetchSize()");
    }

    public void updateNull(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPResultSet.updateNull()");
    }

    public boolean relative(int n) throws SQLException {
        return false;
    }

    public void updateByte(int n, byte by) throws SQLException {
    }

    public void updateDouble(int n, double d) throws SQLException {
    }

    public void updateFloat(int n, float f) throws SQLException {
    }

    public void updateInt(int n, int n2) throws SQLException {
    }

    public void updateLong(int n, long l) throws SQLException {
    }

    public void updateShort(int n, short s) throws SQLException {
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
    }

    public void updateObject(int n, Object object) throws SQLException {
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
    }

    public void updateString(int n, String string) throws SQLException {
    }

    public void updateNull(String string) throws SQLException {
    }

    public void updateByte(String string, byte by) throws SQLException {
    }

    public void updateDouble(String string, double d) throws SQLException {
    }

    public void updateFloat(String string, float f) throws SQLException {
    }

    public void updateInt(String string, int n) throws SQLException {
    }

    public void updateLong(String string, long l) throws SQLException {
    }

    public void updateShort(String string, short s) throws SQLException {
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
    }

    public void updateArray(int n, Array array) throws SQLException {
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
    }

    public void updateClob(int n, Clob clob) throws SQLException {
    }

    public void updateDate(int n, Date date) throws SQLException {
    }

    public void updateRef(int n, Ref ref) throws SQLException {
    }

    public void updateTime(int n, Time time) throws SQLException {
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
    }

    public void updateObject(String string, Object object) throws SQLException {
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
    }

    public void updateString(String string, String string2) throws SQLException {
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
    }

    public void updateArray(String string, Array array) throws SQLException {
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
    }

    public void updateClob(String string, Clob clob) throws SQLException {
    }

    public void updateDate(String string, Date date) throws SQLException {
    }

    public Ref getRef(String string) throws SQLException {
        return null;
    }

    public void updateRef(String string, Ref ref) throws SQLException {
    }

    public void updateTime(String string, Time time) throws SQLException {
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
    }
}

