/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.DRDBConstants;
import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LDAPStatement;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNodeColumn;
import com.novell.sql.SQLNodeValues;
import com.novell.sql.SQLType;
import com.novell.sql.SQLTypes;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class LDAPResultSetMetaData
implements ResultSetMetaData,
LDAPSQLExceptionCodes,
DRDBConstants,
SQLErrorCodes {
    private LDAPStatement m_statement;
    private int m_columnCount;
    private SQLNodeValues[] m_columns;

    protected LDAPResultSetMetaData(LDAPStatement lDAPStatement) {
        this.m_statement = lDAPStatement;
        this.m_columnCount = this.m_statement.getColumnCount();
        this.m_columns = this.m_statement.getColumns(this.m_columnCount);
    }

    public int getColumnCount() throws SQLException {
        return this.m_columnCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return false;
    }

    public int isNullable(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        if (this.m_columns[n - 1].Value.sqlNodeType == 21) {
            SQLNodeColumn sQLNodeColumn = (SQLNodeColumn)this.m_columns[n - 1].Value;
            if (sQLNodeColumn.Nullable) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        switch (this.m_columns[n - 1].Value.sqlSqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2;
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        switch (this.m_columns[n - 1].Value.sqlSqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = this.m_columns[n - 1].Value.sqlPrecision + 1;
                break;
            }
            default: {
                n2 = this.m_columns[n - 1].Value.sqlPrecision;
            }
        }
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        String string;
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        if (this.m_columns[n - 1].Alias != null && this.m_columns[n - 1].Alias.length() != 0) {
            string = this.m_columns[n - 1].Alias;
        } else if (this.m_columns[n - 1].Value.sqlNodeType == 21) {
            SQLNodeColumn sQLNodeColumn = (SQLNodeColumn)this.m_columns[n - 1].Value;
            string = sQLNodeColumn.Column;
        } else {
            string = "";
        }
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        String string;
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        if (this.m_columns[n - 1].Alias != null && this.m_columns[n - 1].Alias.length() != 0) {
            string = this.m_columns[n - 1].Alias;
        } else if (this.m_columns[n - 1].Value.sqlNodeType == 21) {
            SQLNodeColumn sQLNodeColumn = (SQLNodeColumn)this.m_columns[n - 1].Value;
            string = sQLNodeColumn.Column;
        } else {
            string = "";
        }
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return this.m_columns[n - 1].Value.sqlPrecision;
    }

    public int getScale(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return this.m_columns[n - 1].Value.sqlScale;
    }

    public String getTableName(int n) throws SQLException {
        String string;
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        if (this.m_columns[n - 1].Value.sqlNodeType == 21) {
            SQLNodeColumn sQLNodeColumn = (SQLNodeColumn)this.m_columns[n - 1].Value;
            string = sQLNodeColumn.Table.Handle.getName();
        } else {
            string = "";
        }
        return string;
    }

    public String getCatalogName(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return this.m_columns[n - 1].Value.sqlSqlType;
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        SQLType sQLType = SQLTypes.getTypeByID(this.m_columns[n - 1].Value.sqlSqlType);
        String string = sQLType.name;
        return string;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (n < 1 || n > this.m_columnCount) {
            throw Errors.sqlException(1008, String.valueOf(n));
        }
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        return null;
    }
}

