/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPDatabaseMetaData;
import com.novell.sql.LDAPDriverProperties;
import com.novell.sql.LDAPPreparedStatement;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LDAPStatement;
import com.novell.sql.LdapIsam;
import com.novell.sql.SQLWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LDAPSQLConnection
implements Connection,
LDAPSQLExceptionCodes,
LDAPDriverProperties {
    protected static final String DEFAULT_PORT_STR = "DEFAULT";
    protected static final String DEFAULT_PORT = "389";
    protected static final String DEFAULT_SSL_PORT = "636";
    private String m_host;
    private String m_port;
    private LdapContext m_rootContext;
    private DirContext m_baseContext;
    private boolean m_useClearText;
    private boolean m_saslExternal;
    private String m_derefAlias;
    private String m_referral;
    private boolean m_connected;
    private LdapIsam m_ldapIsam;
    private String m_userDN;
    private String m_baseDN;
    private SQLWarnings m_warnings;
    int TRANSACTION_NONE = 0;
    int TRANSACTION_READ_UNCOMMITTED = 1;
    int TRANSACTION_READ_COMMITTED = 2;
    int TRANSACTION_REPEATABLE_READ = 4;
    int TRANSACTION_SERIALIZABLE = 8;

    protected LDAPSQLConnection(String string, Hashtable hashtable) throws SQLException {
        String string2 = "";
        this.m_baseContext = null;
        this.m_rootContext = null;
        this.m_referral = null;
        this.m_connected = false;
        this.m_ldapIsam = null;
        this.m_warnings = new SQLWarnings();
        String string3 = (String)hashtable.get("useCleartext");
        this.m_useClearText = string3 != null ? string3.equalsIgnoreCase("true") : false;
        string3 = (String)hashtable.get("derefAlias");
        this.m_derefAlias = string3 != null && (string3.equalsIgnoreCase("never") || string3.equalsIgnoreCase("finding") || string3.equalsIgnoreCase("searching")) ? string3 : "always";
        string3 = (String)hashtable.get("external");
        this.m_saslExternal = string3 != null ? string3.equalsIgnoreCase("true") : false;
        string3 = (String)hashtable.get("referral");
        this.m_referral = string3 != null && (string3.equalsIgnoreCase("ignore") || string3.equalsIgnoreCase("follow") || string3.equalsIgnoreCase("throw")) ? string3 : "ignore";
        this.m_host = (String)hashtable.get("host");
        try {
            string2 = (String)hashtable.get("port");
            this.m_port = string2.equalsIgnoreCase(DEFAULT_PORT_STR) ? (this.m_useClearText ? DEFAULT_PORT : DEFAULT_SSL_PORT) : string2;
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(6, string2);
        }
        string3 = (String)hashtable.get("baseDN");
        this.m_baseDN = string3 != null ? string3 : "";
        this.m_userDN = (String)hashtable.get("user");
        String string4 = (String)hashtable.get("password");
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (!this.m_useClearText) {
            hashtable2.put("java.naming.security.protocol", "ssl");
            hashtable2.put("java.naming.ldap.factory.socket", "javax.net.ssl.SSLSocketFactory");
        }
        hashtable2.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable2.put("java.naming.provider.url", "ldap://" + this.m_host + ":" + this.m_port);
        if (!this.m_saslExternal) {
            hashtable2.put("java.naming.security.authentication", "simple");
        } else {
            hashtable2.put("java.naming.security.authentication", "EXTERNAL");
        }
        if (this.m_referral != null) {
            hashtable2.put("java.naming.referral", this.m_referral);
        } else {
            hashtable2.put("java.naming.referral", "ignore");
        }
        if (this.m_userDN != null) {
            hashtable2.put("java.naming.security.principal", this.m_userDN);
        }
        if (string4 != null) {
            hashtable2.put("java.naming.security.credentials", string4);
        }
        if (this.m_derefAlias != null) {
            hashtable2.put("java.naming.ldap.derefAliases", this.m_derefAlias);
        }
        hashtable2.put("java.naming.batchsize", "0");
        hashtable2.put("com.sun.naming.netscape.schemaBugs", "true");
        try {
            this.m_rootContext = new InitialLdapContext(hashtable2, null);
            this.m_baseContext = (DirContext)this.m_rootContext.lookup(this.m_baseDN);
            this.m_connected = true;
            this.m_ldapIsam = new LdapIsam(this.m_rootContext, this.m_baseContext, this.m_userDN, this.m_baseDN);
            this.m_ldapIsam.setURL(string);
        }
        catch (AuthenticationException authenticationException) {
            throw Errors.NamingtoSQLException(authenticationException, 24);
        }
        catch (NamingException namingException) {
            throw Errors.NamingtoSQLException(namingException, 7);
        }
    }

    protected String getBaseDN() {
        return this.m_baseDN;
    }

    protected String getUserDN() {
        return this.m_userDN;
    }

    public Statement createStatement() throws SQLException {
        if (this.m_connected) {
            return new LDAPStatement(this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public Statement createStatment(int n, int n2) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.createStatement()");
    }

    public Statement createStatment(int n, int n2, int n3) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.createStatement()");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.m_connected) {
            return new LDAPPreparedStatement(string, this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.m_connected) {
            return new LDAPPreparedStatement(string, this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.m_connected) {
            return new LDAPPreparedStatement(string, this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.m_connected) {
            return new LDAPPreparedStatement(string, this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.m_connected) {
            return new LDAPPreparedStatement(string, this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.m_connected) {
            return new LDAPPreparedStatement(string, this.m_ldapIsam, this);
        }
        throw Errors.sqlException(15);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.prepareCall()");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.prepareCall()");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.prepareCall()");
    }

    public String nativeSQL(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.prepareStatement()");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.AutoCommit()");
    }

    public boolean getAutoCommit() throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.AutoCommit()");
    }

    public void commit() throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.commit()");
    }

    public void rollback() throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.rollback()");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.Rollback");
    }

    public void close() throws SQLException {
        if (this.m_connected) {
            try {
                this.m_connected = false;
                this.m_rootContext.close();
                this.m_baseContext.close();
            }
            catch (NamingException namingException) {
                throw Errors.NamingtoSQLException(namingException, 8);
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.m_connected;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new LDAPDatabaseMetaData(this.m_ldapIsam);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (!bl) {
            throw Errors.sqlException(1, "LDAPSQLConnection.setReadOnly()");
        }
    }

    public boolean isReadOnly() throws SQLException {
        return true;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public int getHoldability() throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.getHoldability()");
    }

    public void setHoldability(int n) throws SQLException {
    }

    public void setTransactionIsolation(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.setTransactionIsolation()");
    }

    public int getTransactionIsolation() throws SQLException {
        return this.TRANSACTION_NONE;
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw Errors.sqlException(1, "LDAPSQLConnection.setTypeMap()");
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warnings.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.m_warnings.clearWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return null;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return null;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return null;
    }
}

