/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.AttributeInfo;
import com.novell.sql.ColumnRef;
import com.novell.sql.DRDBConstants;
import com.novell.sql.DataTable;
import com.novell.sql.EffectiveRightsDataTable;
import com.novell.sql.Errors;
import com.novell.sql.ISAM;
import com.novell.sql.ISAMColumnDef;
import com.novell.sql.ISAMStatement;
import com.novell.sql.ISAMTableDef;
import com.novell.sql.IntRef;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.ObjectRef;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLType;
import com.novell.sql.SQLTypes;
import com.novell.sql.SortedHashtable;
import com.novell.sql.TableInfo;
import com.novell.sql.Value;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

class LdapIsam
extends ISAM
implements LDAPSQLExceptionCodes,
SQLErrorCodes,
DRDBConstants {
    protected static final String RIGHTS_TABLE_NAME = "EffectiveRights";
    protected static final String RIGHTS_ATTRIBUTE = "EffectiveRights";
    protected static final String RIGHTS_COLUMN_OBJECTNAME = "ObjectName";
    protected static final String RIGHTS_COLUMN_OBJECTFULLNAME = "ObjectFullName";
    protected static final String RIGHTS_COLUMN_OBJECTCONTEXT = "ObjectContext";
    protected static final String RIGHTS_COLUMN_OBJECTCLASS = "ObjectClass";
    protected static final String RIGHTS_COLUMN_TRUSTEENAME = "TrusteeName";
    protected static final String RIGHTS_COLUMN_TRUSTEEFULLNAME = "TrusteeFullName";
    protected static final String RIGHTS_COLUMN_TRUSTEECONTEXT = "TrusteeContext";
    protected static final String RIGHTS_COLUMN_TRUSTEECLASS = "TrusteeClass";
    protected static final String RIGHTS_COLUMN_ATTRIBUTE = "Attribute";
    protected static final String RIGHTS_COLUMN_PRIVILEGES = "Privileges";
    protected static final String RIGHTS_COLUMN_SUPERVISOR = "Supervisor";
    protected static final String RIGHTS_COLUMN_BROWSE = "Browse";
    protected static final String RIGHTS_COLUMN_CREATE = "Create";
    protected static final String RIGHTS_COLUMN_DELETE = "Delete";
    protected static final String RIGHTS_COLUMN_RENAME = "Rename";
    protected static final String RIGHTS_COLUMN_COMPARE = "Compare";
    protected static final String RIGHTS_COLUMN_READ = "Read";
    protected static final String RIGHTS_COLUMN_WRITE = "Write";
    protected static final String RIGHTS_COLUMN_ADDSELF = "AddSelf";
    protected static final String RIGHTS_ENTRY = "[Entry Rights]";
    protected static final String RIGHTS_ALLATTRIBUTES = "[All Attributes Rights]";
    protected static final String DEFAULT_SEPARATOR = ",";
    private static Hashtable s_tableNameTranslationTable;
    private static Hashtable s_attrNameTranslationTable;
    private LdapContext m_rootContext;
    private DirContext m_baseContext;
    private SortedHashtable m_tables;
    private Hashtable m_attributes;
    private Vector m_dataTables;
    private String m_database;
    private int m_errorCode;
    private String m_errorString;
    private String m_userDN;
    private String m_baseDN;
    private String m_url;
    private boolean m_effectiveRightsSupported;
    private String m_separator;
    String m_filter;

    LdapIsam(LdapContext ldapContext, DirContext dirContext, String string, String string2) throws SQLException {
        this.m_rootContext = ldapContext;
        this.m_baseContext = dirContext;
        this.m_tables = null;
        this.m_dataTables = new Vector(10);
        this.m_userDN = string;
        this.m_baseDN = string2;
        this.m_separator = DEFAULT_SEPARATOR;
        this.m_errorString = "";
        this.m_effectiveRightsSupported = this.isGetEffectiveRightsSupported();
        this.m_effectiveRightsSupported = true;
        this.readSchema();
        Enumeration enumeration = this.m_tables.elements();
        while (enumeration.hasMoreElements()) {
            TableInfo tableInfo = (TableInfo)enumeration.nextElement();
            tableInfo.addColumn("NDS", this.m_attributes, false);
            tableInfo.addColumn("createTimeStamp", this.m_attributes, false);
            tableInfo.addColumn("entryFlags", this.m_attributes, false);
            tableInfo.addColumn("federationBoundary", this.m_attributes, false);
            tableInfo.addColumn("localEntryID", this.m_attributes, false);
            tableInfo.addColumn("modifyTimeStamp", this.m_attributes, false);
            tableInfo.addColumn("structuralObjectClass", this.m_attributes, false);
            tableInfo.addColumn("subordinateCount", this.m_attributes, false);
            tableInfo.addColumn("subschemaSubentry", this.m_attributes, false);
        }
    }

    boolean isGetEffectiveRightsSupported() throws SQLException {
        String[] stringArray = new String[]{"supportedExtension"};
        SearchControls searchControls = new SearchControls();
        try {
            searchControls.setCountLimit(0L);
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = this.m_rootContext.search("", "(objectClass=*)", searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
                while (namingEnumeration2.hasMore()) {
                    Attribute attribute = namingEnumeration2.next();
                    NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
                    while (namingEnumeration3.hasMore()) {
                        String string = (String)namingEnumeration3.next();
                        if (!string.equalsIgnoreCase("2.16.840.1.113719.1.27.100.33")) continue;
                        namingEnumeration.close();
                        return true;
                    }
                }
            }
            namingEnumeration.close();
        }
        catch (NamingException namingException) {
            throw Errors.NamingtoSQLException(namingException, 7);
        }
        return false;
    }

    public SortedHashtable getTables() {
        return this.m_tables;
    }

    public int maxTableNameLength() {
        return 63;
    }

    public int maxColumnNameLength() {
        return 63;
    }

    public int getSQLTypesCount() {
        return SQLTypes.NumTypes();
    }

    public SQLType getSQLType(int n) {
        return SQLTypes.getType(n);
    }

    public SQLType getSQLTypeByID(int n) {
        return SQLTypes.getTypeByID(n);
    }

    public String getErrorMessage() {
        return this.m_errorString;
    }

    public int parameter(ISAMStatement iSAMStatement, int n, int n2, Value value) {
        return 3;
    }

    public int openTable(String string, boolean bl, ObjectRef objectRef) {
        int n = 0;
        TableInfo tableInfo = (TableInfo)this.m_tables.get(string.toLowerCase());
        if (tableInfo == null) {
            n = 1024;
            this.m_errorCode = 1024;
            this.m_errorString = string;
        } else {
            objectRef.object = tableInfo;
            DataTable dataTable = string.equalsIgnoreCase("EffectiveRights") ? new EffectiveRightsDataTable(string, tableInfo) : new DataTable(string, tableInfo);
            tableInfo.setDataTable(dataTable);
            this.m_dataTables.addElement(dataTable);
        }
        return n;
    }

    public void addDataColumn(String string, ISAMColumnDef iSAMColumnDef) {
        Enumeration enumeration = this.m_dataTables.elements();
        while (enumeration.hasMoreElements()) {
            DataTable dataTable = (DataTable)enumeration.nextElement();
            if (!string.equalsIgnoreCase(dataTable.getName())) continue;
            dataTable.addDataColumn((ColumnRef)iSAMColumnDef);
        }
    }

    public int position(ISAMTableDef iSAMTableDef, int n) {
        this.m_errorCode = !iSAMTableDef.position(n) ? 4 : 0;
        return this.m_errorCode;
    }

    public int getPosition(ISAMTableDef iSAMTableDef) {
        return iSAMTableDef.getPosition();
    }

    public boolean getSchemaInfoTransactioned() {
        return this.m_fSchemaInfoTransactioned;
    }

    public int getTransactionCapable() {
        return 1;
    }

    public String getUser() {
        return this.m_userDN;
    }

    public ISAMStatement getISAMStatement() {
        return null;
    }

    public int sort(ISAMTableDef iSAMTableDef, int n, int[] nArray, boolean[] blArray) {
        this.m_errorCode = 3;
        return 3;
    }

    public int restrict(ISAMTableDef iSAMTableDef, int n, Object[] objectArray, int[] nArray, int[] nArray2, Object[] objectArray2, boolean[] blArray) {
        this.m_errorCode = 0;
        return 0;
    }

    public int rewind(ISAMTableDef iSAMTableDef) {
        try {
            this.createDataEntries();
        }
        catch (SQLException sQLException) {
            return 4;
        }
        ((TableInfo)iSAMTableDef).rewind();
        return 0;
    }

    public int nextRecord(ISAMTableDef iSAMTableDef) {
        this.m_errorCode = ((TableInfo)iSAMTableDef).nextRecord() ? 0 : 1;
        return this.m_errorCode;
    }

    public int getData(ISAMTableDef iSAMTableDef, int n, ObjectRef objectRef) {
        objectRef.object = ((TableInfo)iSAMTableDef).getData(n);
        return 0;
    }

    public int execute(ISAMStatement iSAMStatement, IntRef intRef) {
        return 3;
    }

    private void createDataEntries() throws SQLException {
        Enumeration enumeration = this.m_dataTables.elements();
        while (enumeration.hasMoreElements()) {
            DataTable dataTable = (DataTable)enumeration.nextElement();
            dataTable.createDataEntries(this);
        }
    }

    protected void readSchema() throws SQLException {
        this.m_tables = new SortedHashtable(100);
        this.m_attributes = new Hashtable(100);
        try {
            DirContext dirContext = this.m_baseContext.getSchema("");
            DirContext dirContext2 = (DirContext)dirContext.lookup("AttributeDefinition");
            NamingEnumeration<Binding> namingEnumeration = dirContext2.listBindings("");
            while (namingEnumeration.hasMore()) {
                DirContext dirContext3 = (DirContext)namingEnumeration.next().getObject();
                AttributeInfo attributeInfo = new AttributeInfo(dirContext3);
                this.m_attributes.put(attributeInfo.getName().toLowerCase(), attributeInfo);
                if (!attributeInfo.canConcatenateValues()) continue;
                attributeInfo = new AttributeInfo(attributeInfo);
                this.m_attributes.put(attributeInfo.getName().toLowerCase(), attributeInfo);
                attributeInfo.setFactoryInfo(this);
            }
            this.addSpecialAttributes();
            DirContext dirContext4 = (DirContext)dirContext.lookup("ClassDefinition");
            namingEnumeration = dirContext4.listBindings("");
            while (namingEnumeration.hasMore()) {
                DirContext dirContext5 = (DirContext)namingEnumeration.next().getObject();
                TableInfo tableInfo = new TableInfo(dirContext5, this.m_attributes);
                this.m_tables.put(tableInfo.getName().toLowerCase(), tableInfo);
            }
            dirContext.close();
        }
        catch (NamingException namingException) {
            throw Errors.NamingtoSQLException(namingException, 16);
        }
        this.addColumnsFromSuperClasses();
        this.addSpecialTables();
    }

    private void addSpecialTables() {
        if (this.m_effectiveRightsSupported) {
            String[] stringArray = new String[]{"EffectiveRights"};
            TableInfo tableInfo = new TableInfo("EffectiveRights", stringArray, this.m_attributes);
            this.m_tables.put(tableInfo.getName().toLowerCase(), tableInfo);
        }
    }

    private void addSpecialAttributes() {
        AttributeInfo attributeInfo = new AttributeInfo("NDS", true, this);
        attributeInfo.setFactoryInfo(this);
        this.m_attributes.put(attributeInfo.getName().toLowerCase(), attributeInfo);
        if (this.m_effectiveRightsSupported) {
            attributeInfo = new AttributeInfo("EffectiveRights", true, this);
            attributeInfo.setFactoryInfo(this);
            this.m_attributes.put(attributeInfo.getName().toLowerCase(), attributeInfo);
        }
    }

    private void addColumnsFromThisSuperClass(TableInfo tableInfo, String string) {
        TableInfo tableInfo2 = (TableInfo)this.m_tables.get(string.toLowerCase());
        if (tableInfo2 != null) {
            if (!tableInfo2.getHasExpandedColumns()) {
                Enumeration enumeration = tableInfo2.getSuperClassesEnum();
                while (enumeration.hasMoreElements()) {
                    this.addColumnsFromThisSuperClass(tableInfo2, (String)enumeration.nextElement());
                }
            }
            tableInfo.addColumns(tableInfo2);
        }
    }

    private void addColumnsFromSuperClasses() {
        Enumeration enumeration = this.m_tables.elements();
        while (enumeration.hasMoreElements()) {
            TableInfo tableInfo = (TableInfo)enumeration.nextElement();
            if (tableInfo.getHasExpandedColumns()) continue;
            Enumeration enumeration2 = tableInfo.getSuperClassesEnum();
            while (enumeration2.hasMoreElements()) {
                this.addColumnsFromThisSuperClass(tableInfo, (String)enumeration2.nextElement());
            }
        }
    }

    private static void initializeTranslationTables() {
        s_tableNameTranslationTable = new Hashtable();
        s_tableNameTranslationTable.put("group", "GroupNDS");
        s_tableNameTranslationTable.put("user", "UserNDS");
        s_attrNameTranslationTable = new Hashtable();
    }

    protected static String translateTableName(String string) {
        String string2 = (String)s_tableNameTranslationTable.get(string.toLowerCase());
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    protected void checkTableName(String string) throws SQLException {
        if (!this.m_tables.containsKey(string)) {
            throw Errors.sqlException(1024, string);
        }
    }

    protected String getBaseDN() {
        return this.m_baseDN;
    }

    protected DirContext getBaseContext() {
        return this.m_baseContext;
    }

    protected LdapContext getRootContext() {
        return this.m_rootContext;
    }

    protected void setURL(String string) {
        this.m_url = string;
    }

    protected String getURL() {
        return this.m_url;
    }

    protected String getSeparator() {
        return this.m_separator;
    }

    protected void setSeparator(String string) {
        this.m_separator = string;
    }

    static {
        LdapIsam.initializeTranslationTables();
    }
}

