/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.BaseMetaDataResultSet;
import com.novell.sql.Errors;
import com.novell.sql.MetaDataResultSetColumnDef;
import com.novell.sql.SQLType;
import com.novell.sql.Value;
import com.novell.sql.ValueBoolean;
import com.novell.sql.ValueChar;
import com.novell.sql.ValueInteger;
import com.novell.sql.ValueSmallInt;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class SQLTypes
extends BaseMetaDataResultSet {
    private static final int ODBCVER = 528;
    private static final int NUMERIC_PRECISION = 15;
    private static final int DECIMAL_PRECISION = 15;
    private static final int BIGINT_PRECISION = 20;
    protected static final int TIMESTAMP_SCALE = 3;
    private static SQLType[] m_types = new SQLType[]{new SQLType(true, "CHAR", 1, 254L, "'", "'", "max length", 1, false, 3, false, false, false, "CHAR", -1, -1), new SQLType(true, "VARCHAR", 12, 254L, "'", "'", "max length", 1, false, 3, false, false, false, "VARCHAR", -1, -1), new SQLType(false, "LONGVARCHAR", -1, 65535L, "'", "'", null, 1, false, 0, false, false, false, "LONGVARCHAR", -1, -1), new SQLType(false, "DECIMAL", 3, 15L, null, null, "precision, scale", 1, false, 3, false, false, false, "DECIMAL", 0, 15), new SQLType(false, "NUMERIC", 2, 15L, null, null, "precision, scale", 1, false, 3, false, false, false, "NUMERIC", 0, 15), new SQLType(false, "TINYINT", -6, 3L, null, null, null, 1, false, 3, false, false, false, "TINYINT", -1, -1), new SQLType(false, "SMALLINT", 5, 5L, null, null, null, 1, false, 3, false, false, false, "SMALLINT", -1, -1), new SQLType(true, "INTEGER", 4, 10L, null, null, null, 1, false, 3, false, false, false, "INTEGER", -1, -1), new SQLType(false, "BIGINT", -5, 20L, null, null, null, 1, false, 3, false, false, false, "BIGINT", -1, -1), new SQLType(false, "REAL", 7, 7L, null, null, null, 1, false, 3, false, false, false, "REAL", -1, -1), new SQLType(false, "FLOAT", 6, 15L, null, null, null, 1, false, 3, false, false, false, "FLOAT", -1, -1), new SQLType(false, "DOUBLE", 8, 15L, null, null, null, 1, false, 3, false, false, false, "DOUBLE", -1, -1), new SQLType(true, "BIT", -7, 1L, null, null, null, 1, false, 3, false, false, false, "BIT", -1, -1), new SQLType(false, "DATE", 91, 10L, null, null, null, 1, false, 3, false, false, false, "DATE", -1, -1), new SQLType(false, "TIME", 92, 8L, null, null, null, 1, false, 3, false, false, false, "TIME", -1, -1), new SQLType(true, "TIMESTAMP", 93, 23L, null, null, null, 1, false, 3, false, false, false, "TIMESTAMP", 3, 3), new SQLType(false, "BINARY", -2, 255L, null, null, "max length", 1, false, 3, false, false, false, "BINARY", -1, -1), new SQLType(false, "VARBINARY", -3, 255L, "'", "'", "max length", 1, true, 3, false, false, false, "VARBINARY", -1, -1), new SQLType(false, "LONGVARBINARY", -4, 65535L, "'", "'", null, 1, true, 0, false, false, false, "LONGVARBINARY", -1, -1)};
    private static MetaDataResultSetColumnDef[] s_columns = new MetaDataResultSetColumnDef[]{new MetaDataResultSetColumnDef("type_name", 1, 12, 0), new MetaDataResultSetColumnDef("data_type", 2, 5, 0), new MetaDataResultSetColumnDef("precision", 3, 4, 0), new MetaDataResultSetColumnDef("literal_prefix", 4, 12, 1), new MetaDataResultSetColumnDef("literal_suffix", 5, 12, 1), new MetaDataResultSetColumnDef("create_params", 6, 12, 1), new MetaDataResultSetColumnDef("nullable", 7, 5, 0), new MetaDataResultSetColumnDef("case_sensitive", 8, -7, 0), new MetaDataResultSetColumnDef("searchable", 9, 5, 0), new MetaDataResultSetColumnDef("unsigned_attribute", 10, -7, 0), new MetaDataResultSetColumnDef("fixed_prec_scale", 11, -7, 0), new MetaDataResultSetColumnDef("auto_increment", 12, -7, 0), new MetaDataResultSetColumnDef("local_type_name", 13, 12, 1), new MetaDataResultSetColumnDef("minimum_scale", 14, 5, 0), new MetaDataResultSetColumnDef("maximum_scale", 15, 5, 0), new MetaDataResultSetColumnDef("sql_data_type", 16, 4, 1), new MetaDataResultSetColumnDef("sql_datetime_sub", 17, 4, 0), new MetaDataResultSetColumnDef("num_prec_radix", 18, 4, 0)};
    private int m_currentType = -1;

    protected SQLTypes() {
    }

    public boolean next() {
        ++this.m_currentType;
        return this.m_currentType < m_types.length;
    }

    public static int NumTypes() {
        return m_types.length;
    }

    public static SQLType getType(int n) {
        return m_types[n];
    }

    public static SQLType getTypeByID(int n) {
        int n2 = 0;
        while (n2 < m_types.length) {
            if (SQLTypes.m_types[n2].type == n) {
                return m_types[n2];
            }
            ++n2;
        }
        return null;
    }

    public MetaDataResultSetColumnDef[] getColumns() {
        return s_columns;
    }

    protected Value getColumnValue(int n) throws SQLException {
        Value value = null;
        this.m_wasNull = false;
        switch (n) {
            case 1: {
                value = new ValueChar(SQLTypes.m_types[this.m_currentType].name);
                break;
            }
            case 2: {
                value = new ValueSmallInt((short)SQLTypes.m_types[this.m_currentType].type);
                break;
            }
            case 3: {
                value = new ValueInteger((int)SQLTypes.m_types[this.m_currentType].precision);
                break;
            }
            case 4: {
                this.m_wasNull = true;
                break;
            }
            case 5: {
                this.m_wasNull = true;
                break;
            }
            case 6: {
                this.m_wasNull = true;
                break;
            }
            case 7: {
                value = new ValueSmallInt((short)SQLTypes.m_types[this.m_currentType].nullable);
                break;
            }
            case 8: {
                value = new ValueBoolean(SQLTypes.m_types[this.m_currentType].caseSensitive);
                break;
            }
            case 9: {
                value = new ValueSmallInt((short)SQLTypes.m_types[this.m_currentType].searchable);
                break;
            }
            case 10: {
                value = new ValueBoolean(SQLTypes.m_types[this.m_currentType].unsignedAttribute);
                break;
            }
            case 11: {
                value = new ValueBoolean(SQLTypes.m_types[this.m_currentType].money);
                break;
            }
            case 12: {
                value = new ValueBoolean(SQLTypes.m_types[this.m_currentType].autoincrement);
                break;
            }
            case 13: {
                this.m_wasNull = true;
                break;
            }
            case 14: {
                value = new ValueSmallInt((short)SQLTypes.m_types[this.m_currentType].minscale);
                break;
            }
            case 15: {
                value = new ValueSmallInt((short)SQLTypes.m_types[this.m_currentType].maxscale);
                break;
            }
            case 16: {
                this.m_wasNull = true;
                break;
            }
            case 17: {
                this.m_wasNull = true;
                break;
            }
            case 18: {
                value = new ValueInteger(10);
                break;
            }
            default: {
                throw Errors.sqlException(1008, String.valueOf(n));
            }
        }
        return value;
    }

    public int getConcurrency() throws SQLException {
        return 0;
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getRow() throws SQLException {
        return 0;
    }

    public int getType() throws SQLException {
        return 0;
    }

    public void afterLast() throws SQLException {
    }

    public void beforeFirst() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void deleteRow() throws SQLException {
    }

    public void insertRow() throws SQLException {
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
    }

    public void refreshRow() throws SQLException {
    }

    public void updateRow() throws SQLException {
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public void updateNull(int n) throws SQLException {
    }

    public boolean absolute(int n) throws SQLException {
        return false;
    }

    public boolean relative(int n) throws SQLException {
        return false;
    }

    public void updateByte(int n, byte by) throws SQLException {
    }

    public void updateDouble(int n, double d) throws SQLException {
    }

    public void updateFloat(int n, float f) throws SQLException {
    }

    public void updateInt(int n, int n2) throws SQLException {
    }

    public void updateLong(int n, long l) throws SQLException {
    }

    public void updateShort(int n, short s) throws SQLException {
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return null;
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
    }

    public void updateObject(int n, Object object) throws SQLException {
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
    }

    public void updateString(int n, String string) throws SQLException {
    }

    public void updateNull(String string) throws SQLException {
    }

    public void updateByte(String string, byte by) throws SQLException {
    }

    public void updateDouble(String string, double d) throws SQLException {
    }

    public void updateFloat(String string, float f) throws SQLException {
    }

    public void updateInt(String string, int n) throws SQLException {
    }

    public void updateLong(String string, long l) throws SQLException {
    }

    public void updateShort(String string, short s) throws SQLException {
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return null;
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
    }

    public URL getURL(int n) throws SQLException {
        return null;
    }

    public Array getArray(int n) throws SQLException {
        return null;
    }

    public void updateArray(int n, Array array) throws SQLException {
    }

    public Blob getBlob(int n) throws SQLException {
        return null;
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
    }

    public Clob getClob(int n) throws SQLException {
        return null;
    }

    public void updateClob(int n, Clob clob) throws SQLException {
    }

    public void updateDate(int n, Date date) throws SQLException {
    }

    public Ref getRef(int n) throws SQLException {
        return null;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public void updateTime(int n, Time time) throws SQLException {
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return null;
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
    }

    public void updateObject(String string, Object object) throws SQLException {
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
    }

    public Object getObject(int n, Map map) throws SQLException {
        return null;
    }

    public void updateString(String string, String string2) throws SQLException {
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return null;
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
    }

    public URL getURL(String string) throws SQLException {
        return null;
    }

    public Array getArray(String string) throws SQLException {
        return null;
    }

    public void updateArray(String string, Array array) throws SQLException {
    }

    public Blob getBlob(String string) throws SQLException {
        return null;
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
    }

    public Clob getClob(String string) throws SQLException {
        return null;
    }

    public void updateClob(String string, Clob clob) throws SQLException {
    }

    public void updateDate(String string, Date date) throws SQLException {
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return null;
    }

    public void updateRef(String string, Ref ref) throws SQLException {
    }

    public void updateTime(String string, Time time) throws SQLException {
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return null;
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return null;
    }
}

