/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.BCD;
import com.novell.sql.DRDBConstants;
import com.novell.sql.ISAMColumnDef;
import com.novell.sql.ISAMTableDef;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LDAPStatement;
import com.novell.sql.ObjectRef;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNode;
import com.novell.sql.SQLNodeAggregate;
import com.novell.sql.SQLNodeAlgebraic;
import com.novell.sql.SQLNodeBoolean;
import com.novell.sql.SQLNodeColumn;
import com.novell.sql.SQLNodeColumns;
import com.novell.sql.SQLNodeComparison;
import com.novell.sql.SQLNodeCreate;
import com.novell.sql.SQLNodeCreateColumns;
import com.novell.sql.SQLNodeCreateIndex;
import com.novell.sql.SQLNodeDelete;
import com.novell.sql.SQLNodeDrop;
import com.novell.sql.SQLNodeDropIndex;
import com.novell.sql.SQLNodeGroupByColumns;
import com.novell.sql.SQLNodeInsert;
import com.novell.sql.SQLNodeNumeric;
import com.novell.sql.SQLNodeRoot;
import com.novell.sql.SQLNodeScalar;
import com.novell.sql.SQLNodeSelect;
import com.novell.sql.SQLNodeSortColumns;
import com.novell.sql.SQLNodeString;
import com.novell.sql.SQLNodeTable;
import com.novell.sql.SQLNodeTables;
import com.novell.sql.SQLNodeUpdate;
import com.novell.sql.SQLNodeUpdateValues;
import com.novell.sql.SQLNodeValues;
import com.novell.sql.SQLType;
import com.novell.sql.Scalar;
import com.novell.sql.StringRef;
import java.sql.SQLException;

class Semantic
implements SQLErrorCodes,
LDAPSQLExceptionCodes,
DRDBConstants {
    Semantic() {
    }

    static int SemanticCheck(LDAPStatement lDAPStatement, SQLNode sQLNode, boolean bl, boolean bl2, SQLNode sQLNode2, SQLNode sQLNode3) {
        if (sQLNode == null) {
            return 0;
        }
        int n = 0;
        block0 : switch (sQLNode.sqlNodeType) {
            case 0: {
                break;
            }
            case 1: {
                n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeRoot)sQLNode).sql, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 2: {
                SQLNodeCreate sQLNodeCreate = (SQLNodeCreate)sQLNode;
                if (sQLNodeCreate.Table.length() > lDAPStatement.getISAM().maxTableNameLength()) {
                    lDAPStatement.setErrorMsg(sQLNodeCreate.Table);
                    return 1024;
                }
                n = Semantic.SemanticCheck(lDAPStatement, sQLNodeCreate.Columns, bl, bl2, sQLNode2, sQLNodeCreate);
                if (n == 0) break;
                return n;
            }
            case 3: {
                SQLNodeDrop sQLNodeDrop = (SQLNodeDrop)sQLNode;
                if (sQLNodeDrop.Table.length() <= lDAPStatement.getISAM().maxTableNameLength()) break;
                lDAPStatement.setErrorMsg(sQLNodeDrop.Table);
                return 1024;
            }
            case 4: {
                n = Semantic.SelectCheck(lDAPStatement, (SQLNodeSelect)sQLNode, bl2, sQLNode3);
                break;
            }
            case 5: {
                n = Semantic.CheckInsertNode(lDAPStatement, (SQLNodeInsert)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 6: {
                n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeDelete)sQLNode).Table, bl, bl2, sQLNode2, sQLNode);
                if (n != 0) {
                    return n;
                }
                n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeDelete)sQLNode).Predicate, bl, bl2, sQLNode2, sQLNode);
                if (n == 0) break;
                return n;
            }
            case 7: {
                n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeUpdate)sQLNode).Table, bl, bl2, sQLNode2, sQLNode);
                if (n != 0) {
                    return n;
                }
                n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeUpdate)sQLNode).Updatevalues, bl, bl2, sQLNode2, sQLNode);
                if (n != 0) {
                    return n;
                }
                n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeUpdate)sQLNode).Predicate, bl, bl2, sQLNode2, sQLNode);
                if (n == 0) break;
                return n;
            }
            case 30: {
                n = Semantic.CheckCreateIndexNode(lDAPStatement, (SQLNodeCreateIndex)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 31: {
                if (((SQLNodeDropIndex)sQLNode).Index.length() <= 63) break;
                lDAPStatement.setErrorMsg(((SQLNodeDropIndex)sQLNode).Index);
                return 1055;
            }
            case 8: {
                lDAPStatement.setErrorMsg("CREATE, DROP, SELECT, INSERT, UPDATE, or DELETE");
                return 1015;
            }
            case 9: {
                n = Semantic.CheckTablesNode(lDAPStatement, (SQLNodeTables)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 10: {
                SQLNodeValues sQLNodeValues = (SQLNodeValues)sQLNode;
                while (true) {
                    if ((n = Semantic.SemanticCheck(lDAPStatement, sQLNodeValues.Value, bl, bl2, sQLNode2, sQLNode3)) != 0) {
                        return n;
                    }
                    if (sQLNodeValues.Next == null) break block0;
                    sQLNodeValues = sQLNodeValues.Next;
                }
            }
            case 11: {
                n = Semantic.CheckColumnsNode(lDAPStatement, (SQLNodeColumns)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 12: {
                n = Semantic.CheckSortColumnsNode(lDAPStatement, (SQLNodeSortColumns)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 13: {
                while (true) {
                    if ((n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeGroupByColumns)sQLNode).Column, bl, bl2, sQLNode2, sQLNode3)) != 0) {
                        return n;
                    }
                    if (((SQLNodeGroupByColumns)sQLNode).Next == null) break block0;
                    sQLNode = ((SQLNodeGroupByColumns)sQLNode).Next;
                }
            }
            case 14: {
                while (true) {
                    if ((n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeUpdateValues)sQLNode).Column, bl, bl2, sQLNode2, sQLNode3)) != 0) {
                        return n;
                    }
                    n = Semantic.SemanticCheck(lDAPStatement, ((SQLNodeUpdateValues)sQLNode).Value, bl, bl2, sQLNode2, sQLNode3);
                    if (n != 0) {
                        return n;
                    }
                    n = Semantic.TypeCheck(lDAPStatement, ((SQLNodeUpdateValues)sQLNode).Column, ((SQLNodeUpdateValues)sQLNode).Value, 0, null);
                    if (n != 0) {
                        return n;
                    }
                    if (((SQLNodeUpdateValues)sQLNode).Next == null) break block0;
                    sQLNode = ((SQLNodeUpdateValues)sQLNode).Next;
                }
            }
            case 15: {
                n = Semantic.CheckCreateColumnsNode(lDAPStatement, (SQLNodeCreateColumns)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 16: {
                n = Semantic.CheckBooleanNode(lDAPStatement, (SQLNodeBoolean)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 17: {
                n = Semantic.CheckComparisonNode(lDAPStatement, (SQLNodeComparison)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 18: {
                n = Semantic.CheckAlgebraicNode(lDAPStatement, (SQLNodeAlgebraic)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 32: {
                SQLNodeScalar sQLNodeScalar = (SQLNodeScalar)sQLNode;
                sQLNodeScalar.EnclosingStatement = sQLNode3;
                n = Scalar.ScalarCheck(lDAPStatement, sQLNodeScalar, bl, bl2, sQLNode2, sQLNode3);
                if (n != 0) {
                    return n;
                }
                switch (sQLNodeScalar.sqlDataType) {
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        break block0;
                    }
                }
                return 1003;
            }
            case 19: {
                n = Semantic.CheckAggregateNode(lDAPStatement, (SQLNodeAggregate)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                if (n == 0) break;
                return n;
            }
            case 20: {
                n = Semantic.CheckTableNode(lDAPStatement, (SQLNodeTable)sQLNode, sQLNode3);
                break;
            }
            case 21: {
                n = Semantic.CheckColumnNode(lDAPStatement, (SQLNodeColumn)sQLNode, bl, bl2, sQLNode2, sQLNode3);
                break;
            }
            case 22: {
                sQLNode.sqlDataType = 8;
                sQLNode.sqlSqlType = 12;
                sQLNode.sqlPrecision = ((SQLNodeString)sQLNode).Value.length();
                sQLNode.sqlScale = -1;
                break;
            }
            case 23: {
                if (sQLNode.sqlDataType != 1) break;
                sQLNode.sqlDataType = 6;
                sQLNode.sqlSqlType = 8;
                sQLNode.sqlPrecision = 15;
                sQLNode.sqlScale = -1;
                break;
            }
            case 24: {
                sQLNode.sqlDataType = 1;
                sQLNode.sqlSqlType = 0;
                sQLNode.sqlPrecision = 0;
                sQLNode.sqlScale = -1;
                break;
            }
            case 25: {
                sQLNode.sqlDataType = 8;
                sQLNode.sqlSqlType = 12;
                sQLNode.sqlPrecision = lDAPStatement.getISAM().getUser().length();
                sQLNode.sqlScale = -1;
                break;
            }
            case 26: {
                sQLNode.sqlDataType = 1;
                sQLNode.sqlSqlType = 0;
                sQLNode.sqlPrecision = 0;
                sQLNode.sqlScale = -1;
                break;
            }
            case 27: {
                sQLNode.sqlDataType = 9;
                if (sQLNode.sqlSqlType != 0) break;
                sQLNode.sqlSqlType = 91;
                sQLNode.sqlPrecision = 10;
                sQLNode.sqlScale = -1;
                break;
            }
            case 28: {
                sQLNode.sqlDataType = 10;
                if (sQLNode.sqlSqlType != 0) break;
                sQLNode.sqlSqlType = 92;
                sQLNode.sqlPrecision = 8;
                sQLNode.sqlScale = -1;
                break;
            }
            case 29: {
                sQLNode.sqlDataType = 11;
                if (sQLNode.sqlSqlType != 0) break;
                sQLNode.sqlSqlType = 93;
                sQLNode.sqlPrecision = 23;
                sQLNode.sqlScale = 3;
                break;
            }
            default: {
                return 1019;
            }
        }
        return n;
    }

    static String getTempFileName() {
        return "tempsortFile";
    }

    static int SelectCheck(LDAPStatement lDAPStatement, SQLNodeSelect sQLNodeSelect, boolean bl, SQLNode sQLNode) {
        SQLNodeAggregate sQLNodeAggregate;
        int n;
        int n2;
        SQLNodeSortColumns sQLNodeSortColumns;
        SQLNodeValues sQLNodeValues;
        boolean bl2;
        SQLNodeColumn sQLNodeColumn;
        SQLNodeGroupByColumns sQLNodeGroupByColumns;
        int n3 = 5;
        if (sQLNodeSelect == null) {
            return 0;
        }
        sQLNodeSelect.EnclosingStatement = sQLNode;
        int n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSelect.Tables, false, bl, null, sQLNodeSelect);
        if (n4 != 0) {
            return n4;
        }
        n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSelect.Groupbycolumns, false, bl, null, sQLNodeSelect);
        if (n4 != 0) {
            return n4;
        }
        int n5 = 0;
        int n6 = 0;
        if (sQLNodeSelect.Groupbycolumns != null) {
            if (sQLNodeSelect.Values == null) {
                return 1049;
            }
            sQLNodeGroupByColumns = sQLNodeSelect.Groupbycolumns;
            while (sQLNodeGroupByColumns != null) {
                if (++n5 > 20) {
                    return 1046;
                }
                sQLNodeColumn = sQLNodeGroupByColumns.Column;
                sQLNodeColumn.SortIndex = n6;
                switch (sQLNodeColumn.sqlDataType) {
                    case 3: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 12: {
                        lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                        return 1047;
                    }
                    default: {
                        lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                        return 1047;
                    }
                }
                ++n6;
                sQLNodeGroupByColumns = sQLNodeGroupByColumns.Next;
            }
            bl2 = true;
        } else if (!Semantic.FindAggregate(sQLNodeSelect.Values)) {
            if (sQLNodeSelect.Having != null) {
                return 1051;
            }
            bl2 = false;
        } else {
            sQLNodeSelect.ImplicitGroupby = true;
            bl2 = true;
        }
        if (sQLNodeSelect.Values == null) {
            SQLNodeValues sQLNodeValues2 = null;
            SQLNodeTables sQLNodeTables = sQLNodeSelect.Tables;
            while (sQLNodeTables != null) {
                SQLNodeTable sQLNodeTable = sQLNodeTables.Table;
                ISAMTableDef iSAMTableDef = sQLNodeTable.Handle;
                int n7 = 0;
                while (n7 < iSAMTableDef.getColumnCount()) {
                    sQLNodeColumn = new SQLNodeColumn();
                    sQLNodeColumn.Tablealias = sQLNodeTable.Alias;
                    sQLNodeColumn.Column = iSAMTableDef.getColumnDef(n7).getColumnName();
                    sQLNodeValues = new SQLNodeValues();
                    sQLNodeValues.Value = sQLNodeColumn;
                    sQLNodeValues.Alias = null;
                    sQLNodeValues.Next = null;
                    if (sQLNodeValues2 == null) {
                        sQLNodeSelect.Values = sQLNodeValues;
                    } else {
                        sQLNodeValues2.Next = sQLNodeValues;
                    }
                    sQLNodeValues2 = sQLNodeValues;
                    ++n7;
                }
                sQLNodeTables = sQLNodeTables.Next;
            }
        }
        if ((n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSelect.Sortcolumns, bl2, bl, null, sQLNodeSelect)) != 0) {
            return n4;
        }
        sQLNodeGroupByColumns = sQLNodeSelect.Groupbycolumns;
        while (sQLNodeGroupByColumns != null) {
            SQLNodeColumn sQLNodeColumn2;
            SQLNodeColumn sQLNodeColumn3 = sQLNodeGroupByColumns.Column;
            String string = sQLNodeColumn3.Tablealias;
            String string2 = sQLNodeColumn3.Column;
            sQLNodeSortColumns = sQLNodeSelect.Sortcolumns;
            SQLNodeSortColumns sQLNodeSortColumns2 = null;
            while (sQLNodeSortColumns != null) {
                sQLNodeColumn2 = sQLNodeSortColumns.Column;
                if (sQLNodeColumn2.sqlNodeType == 21) {
                    String string3 = sQLNodeColumn2.Tablealias;
                    String string4 = sQLNodeColumn2.Column;
                    if (bl ? string3.equals(string) && string4.equals(string2) : string3.equalsIgnoreCase(string) && string4.equalsIgnoreCase(string2)) break;
                }
                sQLNodeSortColumns2 = sQLNodeSortColumns;
                sQLNodeSortColumns = sQLNodeSortColumns.Next;
            }
            if (sQLNodeSortColumns == null) {
                sQLNodeColumn2 = new SQLNodeColumn();
                sQLNodeColumn2.Tablealias = sQLNodeColumn3.Tablealias;
                sQLNodeColumn2.Column = sQLNodeColumn3.Column;
                sQLNodeSortColumns = new SQLNodeSortColumns();
                sQLNodeSortColumns.Column = sQLNodeColumn2;
                sQLNodeSortColumns.Descending = false;
                sQLNodeSortColumns.Next = null;
                if (sQLNodeSortColumns2 == null) {
                    sQLNodeSelect.Sortcolumns = sQLNodeSortColumns;
                } else {
                    sQLNodeSortColumns2.Next = sQLNodeSortColumns;
                }
                n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSortColumns, bl2, bl, null, sQLNodeSelect);
            }
            sQLNodeGroupByColumns = sQLNodeGroupByColumns.Next;
        }
        n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSelect.Values, bl2, bl, null, sQLNodeSelect);
        if (n4 != 0) {
            return n4;
        }
        n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSelect.Predicate, false, bl, null, sQLNodeSelect);
        if (n4 != 0) {
            return n4;
        }
        n4 = Semantic.SemanticCheck(lDAPStatement, sQLNodeSelect.Having, bl2, bl, null, sQLNodeSelect);
        if (n4 != 0) {
            return n4;
        }
        if (sQLNodeSelect.Sortcolumns != null) {
            sQLNodeSortColumns = sQLNodeSelect.Sortcolumns;
            while (sQLNodeSortColumns != null) {
                sQLNodeColumn = sQLNodeSortColumns.Column;
                if (sQLNodeSelect.Groupbycolumns == null || sQLNodeColumn.sqlNodeType != 21) {
                    if (++n5 > 20) {
                        return 1026;
                    }
                    switch (sQLNodeColumn.sqlDataType) {
                        case 3: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 11: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 12: {
                            n2 = sQLNodeColumn.sqlPrecision;
                            if (n2 <= 255) break;
                            if (sQLNodeColumn.sqlNodeType == 21) {
                                lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                            } else {
                                lDAPStatement.setErrorMsg("<expression>");
                            }
                            return 1044;
                        }
                        default: {
                            if (sQLNodeColumn.sqlNodeType == 21) {
                                lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                            } else {
                                lDAPStatement.setErrorMsg("<expression>");
                            }
                            return 1044;
                        }
                    }
                }
                sQLNodeSortColumns = sQLNodeSortColumns.Next;
            }
            if (sQLNodeSelect.Groupbycolumns != null || sQLNodeSelect.ImplicitGroupby) {
                n = 0;
                sQLNodeAggregate = sQLNodeSelect.Aggregates;
                while (sQLNodeAggregate != null) {
                    sQLNodeAggregate.SortIndex = n++;
                    sQLNodeAggregate = sQLNodeAggregate.Next;
                }
            }
        }
        if (sQLNodeSelect.ImplicitGroupby) {
            sQLNodeAggregate = sQLNodeSelect.Aggregates;
            n = 0;
            while (sQLNodeAggregate != null) {
                sQLNodeAggregate.SortIndex = n++;
                sQLNodeAggregate = sQLNodeAggregate.Next;
            }
        }
        if (sQLNodeSelect.Distinct) {
            n5 = 0;
            sQLNodeValues = sQLNodeSelect.Values;
            while (sQLNodeValues != null) {
                SQLNode sQLNode2 = sQLNodeValues.Value;
                block10 : switch (sQLNode2.sqlNodeType) {
                    case 18: 
                    case 19: 
                    case 21: 
                    case 32: {
                        if (++n5 > 20) {
                            return 1026;
                        }
                        switch (sQLNode2.sqlDataType) {
                            case 3: 
                            case 6: 
                            case 7: 
                            case 9: 
                            case 10: 
                            case 11: {
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 12: {
                                n2 = sQLNode2.sqlPrecision;
                                if (n2 <= 255) break;
                                if (sQLNode2.sqlNodeType == 21) {
                                    lDAPStatement.setErrorMsg(((SQLNodeColumn)sQLNode2).Column);
                                } else {
                                    lDAPStatement.setErrorMsg("<expression>");
                                }
                                return 1044;
                            }
                            default: {
                                if (sQLNode2.sqlNodeType == 21) {
                                    lDAPStatement.setErrorMsg(((SQLNodeColumn)sQLNode2).Column);
                                } else {
                                    lDAPStatement.setErrorMsg("<expression>");
                                }
                                return 1044;
                            }
                        }
                        switch (sQLNode2.sqlNodeType) {
                            case 21: {
                                ((SQLNodeColumn)sQLNode2).DistinctIndex = n5 - 1;
                                break block10;
                            }
                            case 19: {
                                ((SQLNodeAggregate)sQLNode2).DistinctIndex = n5 - 1;
                                break block10;
                            }
                            case 18: {
                                ((SQLNodeAlgebraic)sQLNode2).DistinctIndex = n5 - 1;
                                break block10;
                            }
                            case 32: {
                                ((SQLNodeScalar)sQLNode2).DistinctIndex = n5 - 1;
                                break block10;
                            }
                        }
                        return 1019;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        break;
                    }
                    default: {
                        return 1019;
                    }
                }
                sQLNodeValues = sQLNodeValues.Next;
            }
        }
        return 0;
    }

    static boolean FindAggregate(SQLNode sQLNode) {
        if (sQLNode == null) {
            return false;
        }
        switch (sQLNode.sqlNodeType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 30: 
            case 31: {
                return false;
            }
            case 10: {
                while (true) {
                    if (Semantic.FindAggregate(((SQLNodeValues)sQLNode).Value)) {
                        return true;
                    }
                    if (((SQLNodeValues)sQLNode).Next == null) {
                        return false;
                    }
                    sQLNode = ((SQLNodeValues)sQLNode).Next;
                }
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return false;
            }
            case 18: {
                if (Semantic.FindAggregate(((SQLNodeAlgebraic)sQLNode).Left)) {
                    return true;
                }
                return Semantic.FindAggregate(((SQLNodeAlgebraic)sQLNode).Right);
            }
            case 32: {
                return Semantic.FindAggregate(((SQLNodeScalar)sQLNode).Arguments);
            }
            case 19: {
                return true;
            }
            case 20: {
                return false;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return false;
            }
        }
        return false;
    }

    static int FindColumn(LDAPStatement lDAPStatement, boolean bl, SQLNodeColumn sQLNodeColumn, SQLNodeTable sQLNodeTable) {
        ISAMColumnDef iSAMColumnDef = null;
        String string = sQLNodeColumn.Column;
        if (sQLNodeColumn.Tablealias != null) {
            if (bl) {
                if (!sQLNodeTable.Alias.equals(sQLNodeColumn.Tablealias)) {
                    lDAPStatement.setErrorMsg(string);
                    return 1021;
                }
            } else if (!sQLNodeTable.Alias.equalsIgnoreCase(sQLNodeColumn.Tablealias)) {
                lDAPStatement.setErrorMsg(string);
                return 1021;
            }
        }
        ISAMTableDef iSAMTableDef = sQLNodeTable.Handle;
        int n = 0;
        while (n < iSAMTableDef.getColumnCount()) {
            iSAMColumnDef = iSAMTableDef.getColumnDef(n);
            String string2 = iSAMColumnDef.getColumnName();
            if (bl ? string.equals(string2) : string.equalsIgnoreCase(string2)) break;
            ++n;
        }
        if (n == iSAMTableDef.getColumnCount()) {
            lDAPStatement.setErrorMsg(string);
            return 1021;
        }
        sQLNodeColumn.Table = sQLNodeTable;
        sQLNodeColumn.Id = n;
        if (sQLNodeColumn.Tablealias == null) {
            sQLNodeColumn.Tablealias = sQLNodeTable.Alias;
        }
        sQLNodeColumn.Nullable = iSAMColumnDef.getNullable();
        sQLNodeColumn.sqlSqlType = iSAMColumnDef.getJDBCType();
        switch (sQLNodeColumn.sqlSqlType) {
            case 2: 
            case 3: {
                sQLNodeColumn.sqlDataType = 7;
                sQLNodeColumn.sqlPrecision = iSAMColumnDef.getPrecision();
                sQLNodeColumn.sqlScale = iSAMColumnDef.getScale();
                break;
            }
            case -5: {
                sQLNodeColumn.sqlDataType = 7;
                sQLNodeColumn.sqlPrecision = iSAMColumnDef.getPrecision();
                sQLNodeColumn.sqlScale = 0;
                break;
            }
            case -6: {
                sQLNodeColumn.sqlDataType = 3;
                sQLNodeColumn.sqlPrecision = 3;
                sQLNodeColumn.sqlScale = 0;
                break;
            }
            case 5: {
                sQLNodeColumn.sqlDataType = 3;
                sQLNodeColumn.sqlPrecision = 5;
                sQLNodeColumn.sqlScale = 0;
                break;
            }
            case 4: {
                sQLNodeColumn.sqlDataType = 3;
                sQLNodeColumn.sqlPrecision = 10;
                sQLNodeColumn.sqlScale = 0;
                break;
            }
            case -7: {
                sQLNodeColumn.sqlDataType = 3;
                sQLNodeColumn.sqlPrecision = 1;
                sQLNodeColumn.sqlScale = 0;
                break;
            }
            case 7: {
                sQLNodeColumn.sqlDataType = 6;
                sQLNodeColumn.sqlPrecision = 7;
                sQLNodeColumn.sqlScale = -1;
                break;
            }
            case 6: 
            case 8: {
                sQLNodeColumn.sqlDataType = 6;
                sQLNodeColumn.sqlPrecision = 15;
                sQLNodeColumn.sqlScale = -1;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                sQLNodeColumn.sqlDataType = 8;
                sQLNodeColumn.sqlPrecision = iSAMColumnDef.getPrecision();
                sQLNodeColumn.sqlScale = -1;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                sQLNodeColumn.sqlDataType = 12;
                sQLNodeColumn.sqlPrecision = iSAMColumnDef.getPrecision();
                sQLNodeColumn.sqlScale = -1;
                break;
            }
            case 91: {
                sQLNodeColumn.sqlDataType = 9;
                sQLNodeColumn.sqlPrecision = 10;
                sQLNodeColumn.sqlScale = -1;
                break;
            }
            case 92: {
                sQLNodeColumn.sqlDataType = 10;
                sQLNodeColumn.sqlPrecision = 8;
                sQLNodeColumn.sqlScale = -1;
                break;
            }
            case 93: {
                sQLNodeColumn.sqlDataType = 11;
                sQLNodeColumn.sqlPrecision = 23;
                sQLNodeColumn.sqlScale = 3;
                break;
            }
            default: {
                return 1003;
            }
        }
        lDAPStatement.getISAM().addDataColumn(iSAMTableDef.getName(), iSAMColumnDef);
        return 0;
    }

    private static String ErrorOpCode(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "<assignment>";
                break;
            }
            case 1: {
                string = "=";
                break;
            }
            case 2: {
                string = "<>";
                break;
            }
            case 3: {
                string = "<=";
                break;
            }
            case 4: {
                string = "<";
                break;
            }
            case 5: {
                string = ">=";
                break;
            }
            case 6: {
                string = ">";
                break;
            }
            case 7: {
                string = "IN";
                break;
            }
            case 8: {
                string = "NOT IN";
                break;
            }
            case 9: {
                string = "LIKE";
                break;
            }
            case 10: {
                string = "NOT LIKE";
                break;
            }
            case 11: {
                string = "-";
                break;
            }
            case 12: {
                string = "+";
                break;
            }
            case 13: {
                string = "-";
                break;
            }
            case 14: {
                string = "*";
                break;
            }
            case 15: {
                string = "/";
                break;
            }
            case 16: {
                string = "NOT";
                break;
            }
            case 17: {
                string = "AND";
                break;
            }
            case 18: {
                string = "OR";
                break;
            }
            case 19: {
                string = "EXISTS";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String ErrorAggCode(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "AVG";
                break;
            }
            case 2: {
                string = "COUNT";
                break;
            }
            case 3: {
                string = "MAX";
                break;
            }
            case 4: {
                string = "MIN";
                break;
            }
            case 5: {
                string = "SUM";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static int CheckTableNode(LDAPStatement lDAPStatement, SQLNodeTable sQLNodeTable, SQLNode sQLNode) {
        boolean bl;
        ObjectRef objectRef = new ObjectRef();
        int n = 0;
        if (sQLNodeTable.Name.length() > lDAPStatement.getISAM().maxTableNameLength()) {
            lDAPStatement.setErrorMsg(sQLNodeTable.Name);
            return 1024;
        }
        switch (sQLNode.sqlNodeType) {
            case 4: {
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 30: 
            case 31: {
                bl = false;
                break;
            }
            default: {
                return 1019;
            }
        }
        n = lDAPStatement.getISAM().openTable(sQLNodeTable.Name, bl, objectRef);
        if (n != 0) {
            sQLNodeTable.Handle = null;
            lDAPStatement.setErrorMsg(lDAPStatement.getISAM().getErrorMessage());
            return n;
        }
        sQLNodeTable.Handle = (ISAMTableDef)objectRef.object;
        lDAPStatement.setISAMTxnStarted(lDAPStatement.getISAM().getSchemaInfoTransactioned());
        n = 0;
        if (sQLNodeTable.Alias == null) {
            sQLNodeTable.Alias = sQLNodeTable.Name;
        }
        return n;
    }

    static int CheckColumnNode(LDAPStatement lDAPStatement, SQLNodeColumn sQLNodeColumn, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n;
        block40: {
            SQLNodeTables sQLNodeTables;
            boolean bl3;
            String string;
            String string2;
            SQLNode sQLNode3;
            n = 0;
            sQLNodeColumn.EnclosingStatement = sQLNode2;
            if (sQLNode == null) {
                sQLNode3 = sQLNode2;
                while (sQLNode3 != null) {
                    switch (sQLNode3.sqlNodeType) {
                        case 4: {
                            string2 = sQLNodeColumn.Tablealias;
                            string = sQLNodeColumn.Tablealias;
                            bl3 = false;
                            n = 1021;
                            sQLNodeTables = ((SQLNodeSelect)sQLNode3).Tables;
                            while (sQLNodeTables != null) {
                                n = Semantic.FindColumn(lDAPStatement, bl2, sQLNodeColumn, sQLNodeTables.Table);
                                if (n == 0) {
                                    if (bl3) {
                                        lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                                        return 1036;
                                    }
                                    bl3 = true;
                                    if (string != null) break;
                                    string2 = sQLNodeColumn.Tablealias;
                                    sQLNodeColumn.Tablealias = null;
                                } else if (n != 1021) {
                                    return n;
                                }
                                sQLNodeTables = sQLNodeTables.Next;
                            }
                            sQLNodeColumn.Tablealias = string2;
                            if (bl3) {
                                n = 0;
                                break;
                            }
                            n = 1021;
                            break;
                        }
                        case 5: {
                            if (sQLNode3 == sQLNode2) {
                                n = Semantic.FindColumn(lDAPStatement, bl2, sQLNodeColumn, ((SQLNodeInsert)sQLNode3).Table);
                                break;
                            }
                            n = 1021;
                            break;
                        }
                        case 7: {
                            n = Semantic.FindColumn(lDAPStatement, bl2, sQLNodeColumn, ((SQLNodeUpdate)sQLNode3).Table);
                            break;
                        }
                        case 6: {
                            n = Semantic.FindColumn(lDAPStatement, bl2, sQLNodeColumn, ((SQLNodeDelete)sQLNode3).Table);
                            break;
                        }
                        case 30: {
                            n = Semantic.FindColumn(lDAPStatement, bl2, sQLNodeColumn, ((SQLNodeCreateIndex)sQLNode3).Table);
                            break;
                        }
                        default: {
                            return 1019;
                        }
                    }
                    if (n != 0 && n != 1021) {
                        return n;
                    }
                    if (n == 0 || sQLNode3.sqlNodeType != 4) break;
                    sQLNode3 = ((SQLNodeSelect)sQLNode3).EnclosingStatement;
                }
                if (n == 1021) {
                    lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                    return 1021;
                }
            } else {
                string2 = sQLNodeColumn.Tablealias;
                string = sQLNodeColumn.Tablealias;
                sQLNodeTables = (SQLNodeTables)sQLNode;
                SQLNodeTable sQLNodeTable = sQLNodeTables.Table;
                bl3 = false;
                do {
                    if ((n = Semantic.FindColumn(lDAPStatement, bl2, sQLNodeColumn, sQLNodeTable)) == 0) {
                        if (bl3) {
                            lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                            return 1036;
                        }
                        bl3 = true;
                        string2 = sQLNodeColumn.Tablealias;
                        if (string == null) {
                            sQLNodeColumn.Tablealias = null;
                        }
                    } else if (n != 1021) {
                        return n;
                    }
                    if ((sQLNodeTables = sQLNodeTables.Next) == null) break;
                    sQLNodeTable = sQLNodeTables.Table;
                } while (sQLNodeTable.OuterJoinFromTables != null);
                if (!bl3) {
                    lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                    return 1021;
                }
                sQLNodeColumn.Tablealias = string2;
                n = 0;
            }
            if (bl) {
                String string3 = sQLNodeColumn.Column;
                String string4 = sQLNodeColumn.Tablealias;
                sQLNode3 = sQLNode2;
                if (sQLNode3.sqlNodeType != 4) {
                    return 1019;
                }
                SQLNodeGroupByColumns sQLNodeGroupByColumns = ((SQLNodeSelect)sQLNode3).Groupbycolumns;
                if (((SQLNodeSelect)sQLNode3).ImplicitGroupby) {
                    lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                    return 1017;
                }
                do {
                    if (sQLNodeGroupByColumns.Column == null) continue;
                    SQLNodeColumn sQLNodeColumn2 = sQLNodeGroupByColumns.Column;
                    String string5 = sQLNodeColumn2.Tablealias;
                    String string6 = sQLNodeColumn2.Column;
                    if ((!bl2 || !string6.equals(string3) || !string5.equals(string4)) && (!string6.equalsIgnoreCase(string3) || !string5.equalsIgnoreCase(string4))) continue;
                    sQLNodeColumn.InSortRecord = true;
                    sQLNodeColumn.SortIndex = sQLNodeColumn2.SortIndex;
                    sQLNodeColumn.DistinctIndex = sQLNodeColumn2.DistinctIndex;
                    break block40;
                } while ((sQLNodeGroupByColumns = sQLNodeGroupByColumns.Next) != null);
                lDAPStatement.setErrorMsg(sQLNodeColumn.Column);
                return 1021;
            }
        }
        switch (sQLNodeColumn.sqlDataType) {
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                break;
            }
            case 12: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            default: {
                return 1003;
            }
        }
        return n;
    }

    static int CheckInsertNode(LDAPStatement lDAPStatement, SQLNodeInsert sQLNodeInsert, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        SQLNodeColumns sQLNodeColumns;
        int n = Semantic.SemanticCheck(lDAPStatement, sQLNodeInsert.Table, bl, bl2, sQLNode, sQLNodeInsert);
        if (n != 0) {
            return n;
        }
        if (sQLNodeInsert.Columns == null) {
            SQLNodeTable sQLNodeTable = sQLNodeInsert.Table;
            String string = sQLNodeTable.Alias;
            ISAMTableDef iSAMTableDef = sQLNodeTable.Handle;
            SQLNodeColumns sQLNodeColumns2 = null;
            int n2 = 0;
            while (n2 < iSAMTableDef.getColumnCount()) {
                SQLNodeColumn sQLNodeColumn = new SQLNodeColumn();
                sQLNodeColumn.Tablealias = string;
                sQLNodeColumn.Column = iSAMTableDef.getColumnDef(n2).getColumnName();
                sQLNodeColumn.Table = sQLNodeInsert.Table;
                sQLNodeColumn.Id = n2;
                sQLNodeColumns = new SQLNodeColumns();
                sQLNodeColumns.Column = sQLNodeColumn;
                sQLNodeColumns.Next = null;
                if (sQLNodeColumns2 == null) {
                    sQLNodeInsert.Columns = sQLNodeColumns;
                } else {
                    sQLNodeColumns2.Next = sQLNodeColumns;
                }
                sQLNodeColumns2 = sQLNodeColumns;
                ++n2;
            }
        }
        if ((n = Semantic.SemanticCheck(lDAPStatement, sQLNodeInsert.Columns, bl, bl2, sQLNode, sQLNodeInsert)) != 0) {
            return n;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeInsert.Values, bl, bl2, sQLNode, sQLNodeInsert);
        if (n != 0) {
            return n;
        }
        SQLNode sQLNode3 = sQLNodeInsert.Values;
        SQLNodeValues sQLNodeValues = sQLNode3.sqlNodeType == 4 ? ((SQLNodeSelect)sQLNode3).Values : (SQLNodeValues)sQLNodeInsert.Values;
        sQLNodeColumns = sQLNodeInsert.Columns;
        while (sQLNodeValues != null) {
            if (sQLNodeColumns == null) {
                return 1028;
            }
            SQLNode sQLNode4 = sQLNodeValues.Value;
            if (sQLNode3.sqlNodeType != 4) {
                switch (sQLNode4.sqlNodeType) {
                    case 18: 
                    case 19: 
                    case 32: {
                        return 1029;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        break;
                    }
                    default: {
                        return 1019;
                    }
                }
            }
            if ((n = Semantic.TypeCheck(lDAPStatement, sQLNodeColumns.Column, sQLNodeValues.Value, 0, null)) != 0) {
                return n;
            }
            sQLNodeValues = sQLNodeValues.Next;
            sQLNodeColumns = sQLNodeColumns.Next;
        }
        if (sQLNodeColumns != null) {
            return 1028;
        }
        return n;
    }

    static int CheckCreateIndexNode(LDAPStatement lDAPStatement, SQLNodeCreateIndex sQLNodeCreateIndex, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        if (sQLNodeCreateIndex.Index.length() > 63) {
            lDAPStatement.setErrorMsg(sQLNodeCreateIndex.Index);
            return 1055;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeCreateIndex.Table, bl, bl2, sQLNode, sQLNodeCreateIndex);
        if (n != 0) {
            return n;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeCreateIndex.Columns, bl, bl2, sQLNode, sQLNodeCreateIndex);
        if (n != 0) {
            return n;
        }
        SQLNodeSortColumns sQLNodeSortColumns = sQLNodeCreateIndex.Columns;
        int n2 = 0;
        while (sQLNodeSortColumns != null) {
            ++n2;
            sQLNodeSortColumns = sQLNodeSortColumns.Next;
        }
        if (n2 > 15) {
            return 1056;
        }
        return n;
    }

    static int CheckTablesNode(LDAPStatement lDAPStatement, SQLNodeTables sQLNodeTables, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = Semantic.SemanticCheck(lDAPStatement, sQLNodeTables.Table, bl, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeTables.Next, bl, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        SQLNodeTable sQLNodeTable = sQLNodeTables.Table;
        String string = sQLNodeTable.Alias;
        SQLNodeTables sQLNodeTables2 = sQLNodeTables.Next;
        while (sQLNodeTables2 != null) {
            sQLNodeTable = sQLNodeTables2.Table;
            if (bl2) {
                if (string.equals(sQLNodeTable.Alias)) {
                    lDAPStatement.setErrorMsg(string);
                    return 1031;
                }
            } else if (string.equalsIgnoreCase(sQLNodeTable.Alias)) {
                lDAPStatement.setErrorMsg(string);
                return 1031;
            }
            sQLNodeTables2 = sQLNodeTables2.Next;
        }
        sQLNodeTable = sQLNodeTables.Table;
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeTable.OuterJoinPredicate, false, bl2, sQLNodeTable.OuterJoinFromTables, sQLNode2);
        return n;
    }

    static int CheckColumnsNode(LDAPStatement lDAPStatement, SQLNodeColumns sQLNodeColumns, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        while (true) {
            if ((n = Semantic.SemanticCheck(lDAPStatement, sQLNodeColumns.Column, bl, bl2, sQLNode, sQLNode2)) != 0) {
                return n;
            }
            if (sQLNodeColumns.Next == null) break;
            sQLNodeColumns = sQLNodeColumns.Next;
        }
        SQLNodeColumn sQLNodeColumn = sQLNodeColumns.Column;
        String string = sQLNodeColumn.Column;
        sQLNodeColumns = sQLNodeColumns.Next;
        while (sQLNodeColumns != null) {
            sQLNodeColumn = sQLNodeColumns.Column;
            if (bl2) {
                if (string.equals(sQLNodeColumn.Column)) {
                    lDAPStatement.setErrorMsg(string);
                    return 1032;
                }
            } else if (string.equalsIgnoreCase(sQLNodeColumn.Column)) {
                lDAPStatement.setErrorMsg(string);
                return 1032;
            }
            sQLNodeColumns = sQLNodeColumns.Next;
        }
        return n;
    }

    static int CheckSortColumnsNode(LDAPStatement lDAPStatement, SQLNodeSortColumns sQLNodeSortColumns, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        while (true) {
            if ((n = Semantic.SemanticCheck(lDAPStatement, sQLNodeSortColumns.Column, bl, bl2, sQLNode, sQLNode2)) != 0) {
                return n;
            }
            SQLNodeColumn sQLNodeColumn = sQLNodeSortColumns.Column;
            if (sQLNodeColumn.sqlNodeType == 23) {
                if (sQLNode2.sqlNodeType != 4) {
                    return 1019;
                }
                SQLNodeValues sQLNodeValues = ((SQLNodeSelect)sQLNode2).Values;
                int n2 = 1;
                while (true) {
                    if (sQLNodeValues == null) {
                        return 1025;
                    }
                    try {
                        if (n2 == ((SQLNodeNumeric)((Object)sQLNodeColumn)).Value.getInt()) {
                            break;
                        }
                    }
                    catch (SQLException sQLException) {
                        return 1019;
                    }
                    sQLNodeValues = sQLNodeValues.Next;
                    ++n2;
                }
                SQLNode sQLNode3 = sQLNodeValues.Value;
                if (sQLNode3.sqlNodeType != 21) {
                    return 1027;
                }
                SQLNodeColumn sQLNodeColumn2 = new SQLNodeColumn();
                sQLNodeColumn2.Tablealias = ((SQLNodeColumn)sQLNode3).Tablealias;
                sQLNodeColumn2.Column = ((SQLNodeColumn)sQLNode3).Column;
                sQLNodeSortColumns.Column = sQLNodeColumn2;
                n = Semantic.SemanticCheck(lDAPStatement, sQLNodeSortColumns.Column, bl, bl2, sQLNode, sQLNode2);
                if (n != 0) {
                    return n;
                }
            }
            if (sQLNodeSortColumns.Next == null) break;
            sQLNodeSortColumns = sQLNodeSortColumns.Next;
        }
        return n;
    }

    static int CheckCreateColumnsNode(LDAPStatement lDAPStatement, SQLNodeCreateColumns sQLNodeCreateColumns, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        SQLType sQLType = null;
        while (true) {
            if (sQLNodeCreateColumns.Name.length() > lDAPStatement.getISAM().maxColumnNameLength()) {
                lDAPStatement.setErrorMsg(sQLNodeCreateColumns.Name);
                return 1033;
            }
            int n2 = lDAPStatement.getISAM().getSQLTypesCount();
            int n3 = 0;
            while (n3 < n2) {
                sQLType = lDAPStatement.getISAM().getSQLType(n3);
                if (sQLType.supported && sQLType.name.equalsIgnoreCase(sQLNodeCreateColumns.Type)) break;
                ++n3;
            }
            if (n3 >= n2) {
                lDAPStatement.setErrorMsg(sQLNodeCreateColumns.Type);
                return 1034;
            }
            sQLNodeCreateColumns.iSqlType = n3;
            n2 = 0;
            if (sQLType.params != null) {
                n2 = 1;
                int n4 = 0;
                while (n4 < sQLType.params.length()) {
                    n3 = sQLType.params.indexOf(44, n4);
                    if (n3 == -1) break;
                    ++n2;
                    n4 = n3 + 1;
                }
            }
            if (n2 != sQLNodeCreateColumns.Params) {
                lDAPStatement.setErrorMsg(sQLNodeCreateColumns.Type);
                return 1035;
            }
            if (sQLNodeCreateColumns.Next == null) break;
            sQLNodeCreateColumns = sQLNodeCreateColumns.Next;
        }
        return n;
    }

    static int CheckBooleanNode(LDAPStatement lDAPStatement, SQLNodeBoolean sQLNodeBoolean, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        while (true) {
            if ((n = Semantic.SemanticCheck(lDAPStatement, sQLNodeBoolean.Left, bl, bl2, sQLNode, sQLNode2)) != 0) {
                return n;
            }
            sQLNodeBoolean.sqlDataType = 3;
            sQLNodeBoolean.sqlSqlType = -7;
            sQLNodeBoolean.sqlPrecision = 1;
            sQLNodeBoolean.sqlScale = 0;
            if (sQLNodeBoolean.Right == null) break;
            if (sQLNodeBoolean.Right.sqlNodeType != 16) {
                n = Semantic.SemanticCheck(lDAPStatement, sQLNodeBoolean.Right, bl, bl2, sQLNode, sQLNode2);
                if (n == 0) break;
                return n;
            }
            sQLNodeBoolean = (SQLNodeBoolean)sQLNodeBoolean.Right;
        }
        return n;
    }

    static int CheckComparisonNode(LDAPStatement lDAPStatement, SQLNodeComparison sQLNodeComparison, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeComparison.Left, bl, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeComparison.Right, bl, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        if ((sQLNodeComparison.Operator == 7 || sQLNodeComparison.Operator == 8) && sQLNodeComparison.Right.sqlNodeType == 4) {
            if (sQLNodeComparison.Operator == 7) {
                sQLNodeComparison.Operator = 1;
                sQLNodeComparison.SelectModifier = 2;
            } else if (sQLNodeComparison.Operator == 8) {
                sQLNodeComparison.Operator = 2;
                sQLNodeComparison.SelectModifier = 1;
            }
        }
        if (sQLNodeComparison.Operator != 19) {
            if (sQLNodeComparison.Operator != 7 && sQLNodeComparison.Operator != 8) {
                switch (sQLNodeComparison.SelectModifier) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        SQLNodeSelect sQLNodeSelect = (SQLNodeSelect)sQLNodeComparison.Right;
                        SQLNodeValues sQLNodeValues = sQLNodeSelect.Values;
                        if (sQLNodeValues.Next != null) {
                            return 1065;
                        }
                        SQLNode sQLNode3 = sQLNodeValues.Value;
                        if (sQLNode3.sqlSqlType == -1 || sQLNode3.sqlSqlType == -4) {
                            lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(sQLNodeComparison.Operator));
                            return 1023;
                        }
                        sQLNodeSelect.sqlDataType = sQLNode3.sqlDataType;
                        sQLNodeSelect.sqlSqlType = sQLNode3.sqlSqlType;
                        sQLNodeSelect.sqlPrecision = sQLNode3.sqlPrecision;
                        sQLNodeSelect.sqlScale = sQLNode3.sqlScale;
                        break;
                    }
                    default: {
                        return 1019;
                    }
                }
                n = Semantic.TypeCheck(lDAPStatement, sQLNodeComparison.Left, sQLNodeComparison.Right, sQLNodeComparison.Operator, sQLNodeComparison);
                if (n != 0) {
                    return n;
                }
                if (sQLNodeComparison.sqlDataType != 8 && (sQLNodeComparison.Operator == 9 || sQLNodeComparison.Operator == 10)) {
                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(sQLNodeComparison.Operator));
                    return 1023;
                }
                if (sQLNodeComparison.sqlDataType == 12 && (sQLNodeComparison.Operator != 1 && sQLNodeComparison.Operator != 2 || sQLNodeComparison.sqlPrecision > 255)) {
                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(sQLNodeComparison.Operator));
                    return 1023;
                }
            } else {
                SQLNodeValues sQLNodeValues = (SQLNodeValues)sQLNodeComparison.Right;
                while (sQLNodeValues != null) {
                    SQLNode sQLNode4 = sQLNodeValues.Value;
                    switch (sQLNode4.sqlNodeType) {
                        case 18: 
                        case 19: 
                        case 32: {
                            return 1030;
                        }
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 29: {
                            n = Semantic.TypeCheck(lDAPStatement, sQLNodeComparison.Left, sQLNodeValues.Value, sQLNodeComparison.Operator, sQLNodeComparison);
                            if (n == 0) break;
                            return n;
                        }
                        case 26: {
                            return 1030;
                        }
                        default: {
                            return 1019;
                        }
                    }
                    sQLNodeValues = sQLNodeValues.Next;
                }
            }
        }
        sQLNodeComparison.sqlDataType = 3;
        sQLNodeComparison.sqlSqlType = -7;
        sQLNodeComparison.sqlPrecision = 1;
        sQLNodeComparison.sqlScale = 0;
        return n;
    }

    static int CheckAlgebraicNode(LDAPStatement lDAPStatement, SQLNodeAlgebraic sQLNodeAlgebraic, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        sQLNodeAlgebraic.EnclosingStatement = sQLNode2;
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeAlgebraic.Left, bl, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeAlgebraic.Right, bl, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        n = Semantic.TypeCheck(lDAPStatement, sQLNodeAlgebraic.Left, sQLNodeAlgebraic.Right, sQLNodeAlgebraic.Operator, sQLNodeAlgebraic);
        if (n != 0) {
            return n;
        }
        switch (sQLNodeAlgebraic.sqlDataType) {
            case 3: 
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 12: {
                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(sQLNodeAlgebraic.Operator));
                return 1023;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(sQLNodeAlgebraic.Operator));
                return 1023;
            }
            default: {
                return 1003;
            }
        }
        SQLNode sQLNode3 = sQLNodeAlgebraic.Left;
        if (sQLNodeAlgebraic.Operator == 11 && sQLNode3.sqlNodeType == 23) {
            SQLNodeNumeric sQLNodeNumeric = (SQLNodeNumeric)sQLNode3;
            sQLNodeAlgebraic.sqlNodeType = 23;
            sQLNodeAlgebraic.sqlDataType = sQLNodeNumeric.sqlDataType;
            sQLNodeAlgebraic.sqlSqlType = sQLNodeNumeric.sqlSqlType;
            sQLNodeAlgebraic.sqlScale = sQLNodeNumeric.sqlScale;
            sQLNodeAlgebraic.sqlPrecision = sQLNodeNumeric.sqlPrecision;
            sQLNodeAlgebraic.value = sQLNodeNumeric.value;
            sQLNodeAlgebraic.Value = sQLNodeNumeric.Value;
            sQLNodeAlgebraic.Value.negate();
            sQLNodeAlgebraic.Numeric = sQLNodeNumeric.Numeric;
            sQLNodeAlgebraic.Left = null;
            String string = sQLNodeAlgebraic.Numeric;
            if (string.charAt(0) != '-') {
                StringRef stringRef = new StringRef();
                string = "-" + string;
                BCD.BCDNormalize(string, stringRef, sQLNodeAlgebraic.sqlPrecision, sQLNodeAlgebraic.sqlScale);
                sQLNodeAlgebraic.Numeric = stringRef.value;
            } else {
                sQLNodeAlgebraic.Numeric = string.substring(1);
            }
        }
        return n;
    }

    static int CheckAggregateNode(LDAPStatement lDAPStatement, SQLNodeAggregate sQLNodeAggregate, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n = 0;
        sQLNodeAggregate.EnclosingStatement = sQLNode2;
        if (!bl) {
            lDAPStatement.setErrorMsg(Semantic.ErrorAggCode(sQLNodeAggregate.Operator));
            return 1048;
        }
        n = Semantic.SemanticCheck(lDAPStatement, sQLNodeAggregate.Expression, false, bl2, sQLNode, sQLNode2);
        if (n != 0) {
            return n;
        }
        SQLNode sQLNode3 = sQLNodeAggregate.Operator != 2 ? sQLNodeAggregate.Expression : null;
        block0 : switch (sQLNodeAggregate.Operator) {
            case 1: {
                switch (sQLNode3.sqlDataType) {
                    case 3: 
                    case 6: 
                    case 7: {
                        sQLNodeAggregate.sqlDataType = 6;
                        sQLNodeAggregate.sqlSqlType = 8;
                        sQLNodeAggregate.sqlPrecision = 15;
                        sQLNodeAggregate.sqlScale = -1;
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorAggCode(sQLNodeAggregate.Operator));
                        return 1023;
                    }
                }
                return 1003;
            }
            case 2: {
                sQLNodeAggregate.sqlDataType = 3;
                sQLNodeAggregate.sqlSqlType = 4;
                sQLNodeAggregate.sqlPrecision = 10;
                sQLNodeAggregate.sqlScale = 0;
                break;
            }
            case 3: 
            case 4: {
                switch (sQLNode3.sqlDataType) {
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        sQLNodeAggregate.sqlDataType = sQLNode3.sqlDataType;
                        sQLNodeAggregate.sqlSqlType = sQLNode3.sqlSqlType;
                        sQLNodeAggregate.sqlPrecision = sQLNode3.sqlPrecision;
                        sQLNodeAggregate.sqlScale = sQLNode3.sqlScale;
                        break block0;
                    }
                    case 12: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorAggCode(sQLNodeAggregate.Operator));
                        return 1023;
                    }
                }
                return 1003;
            }
            case 5: {
                switch (sQLNode3.sqlDataType) {
                    case 3: 
                    case 6: 
                    case 7: {
                        sQLNodeAggregate.sqlDataType = sQLNode3.sqlDataType;
                        sQLNodeAggregate.sqlSqlType = sQLNode3.sqlSqlType;
                        sQLNodeAggregate.sqlPrecision = sQLNode3.sqlPrecision;
                        sQLNodeAggregate.sqlScale = sQLNode3.sqlScale;
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorAggCode(sQLNodeAggregate.Operator));
                        return 1023;
                    }
                }
                return 1003;
            }
            default: {
                return 1019;
            }
        }
        block18 : switch (sQLNodeAggregate.sqlDataType) {
            case 6: {
                break;
            }
            case 7: {
                switch (sQLNodeAggregate.sqlSqlType) {
                    case 2: 
                    case 3: {
                        break block18;
                    }
                    case -5: {
                        break block18;
                    }
                }
                return 1019;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                return 1019;
            }
            default: {
                return 1003;
            }
        }
        if (sQLNode2 == null || sQLNode2.sqlNodeType != 4) {
            return 1019;
        }
        SQLNodeSelect sQLNodeSelect = (SQLNodeSelect)sQLNode2;
        if (sQLNodeSelect.Aggregates == null) {
            sQLNodeSelect.Aggregates = sQLNodeAggregate;
        } else {
            SQLNodeAggregate sQLNodeAggregate2 = sQLNodeSelect.Aggregates;
            while (sQLNodeAggregate2.Next != null) {
                sQLNodeAggregate2 = sQLNodeAggregate2.Next;
            }
            sQLNodeAggregate2.Next = sQLNodeAggregate;
        }
        return n;
    }

    static int TypeCheck(LDAPStatement lDAPStatement, SQLNode sQLNode, SQLNode sQLNode2, int n, SQLNode sQLNode3) {
        block228: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            block230: {
                block229: {
                    block227: {
                        if (sQLNode == null) {
                            return 1019;
                        }
                        n9 = sQLNode.sqlDataType;
                        n8 = sQLNode.sqlSqlType;
                        n7 = sQLNode.sqlPrecision;
                        n6 = sQLNode.sqlScale;
                        if (sQLNode2 != null) {
                            n5 = sQLNode2.sqlDataType;
                            n4 = sQLNode2.sqlSqlType;
                            n3 = sQLNode2.sqlPrecision;
                            n2 = sQLNode2.sqlScale;
                        } else {
                            if (n != 11) {
                                return 1019;
                            }
                            if (n9 == 1) {
                                return 1022;
                            }
                            n5 = n9;
                            n4 = n8;
                            n3 = n7;
                            n2 = n6;
                        }
                        if (n9 != 1) break block227;
                        if (n5 == 1) {
                            return 1022;
                        }
                        if (n5 == 8) {
                            switch (n) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: {
                                    break;
                                }
                                case 11: {
                                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                    return 1023;
                                }
                                case 12: {
                                    if (n4 != -1) break;
                                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                    return 1023;
                                }
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                    return 1023;
                                }
                            }
                        } else if (n5 == 9) {
                            switch (n) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    break;
                                }
                                case 9: 
                                case 10: 
                                case 11: {
                                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                    return 1023;
                                }
                                case 12: 
                                case 13: {
                                    break;
                                }
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                    return 1023;
                                }
                            }
                        }
                        if (n5 == 9 && n == 12) {
                            sQLNode.sqlDataType = 3;
                            sQLNode.sqlSqlType = 4;
                            sQLNode.sqlPrecision = 10;
                            sQLNode.sqlScale = 0;
                        } else {
                            sQLNode.sqlDataType = n5;
                            sQLNode.sqlSqlType = n4;
                            sQLNode.sqlPrecision = n3;
                            sQLNode.sqlScale = n2;
                            if (n5 == 8 && n == 12) {
                                sQLNode.sqlSqlType = 12;
                                sQLNode.sqlPrecision = 255;
                            }
                        }
                        if (n5 == 9 && n == 12) {
                            if (sQLNode3 != null) {
                                sQLNode3.sqlDataType = sQLNode2.sqlDataType;
                                sQLNode3.sqlSqlType = sQLNode2.sqlSqlType;
                                sQLNode3.sqlPrecision = sQLNode2.sqlPrecision;
                                sQLNode3.sqlScale = sQLNode2.sqlScale;
                            }
                        } else if (sQLNode.sqlDataType == 9 && n == 13) {
                            if (sQLNode3 != null) {
                                sQLNode3.sqlDataType = 3;
                                sQLNode3.sqlSqlType = 4;
                                sQLNode3.sqlPrecision = 10;
                                sQLNode3.sqlScale = 0;
                            }
                        } else if (sQLNode3 != null) {
                            sQLNode3.sqlDataType = sQLNode.sqlDataType;
                            sQLNode3.sqlSqlType = sQLNode.sqlSqlType;
                            sQLNode3.sqlPrecision = sQLNode.sqlPrecision;
                            sQLNode3.sqlScale = sQLNode.sqlScale;
                        }
                        break block228;
                    }
                    if (n5 != 1) break block229;
                    if (n9 == 8) {
                        switch (n) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                break;
                            }
                            case 11: {
                                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                return 1023;
                            }
                            case 12: {
                                if (n8 != -1) break;
                                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                return 1023;
                            }
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                return 1023;
                            }
                        }
                    } else if (n9 == 9) {
                        switch (n) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                break;
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                return 1023;
                            }
                            case 12: 
                            case 13: {
                                break;
                            }
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                return 1023;
                            }
                        }
                    }
                    if (n9 == 9 && n == 12) {
                        sQLNode2.sqlDataType = 3;
                        sQLNode2.sqlSqlType = 4;
                        sQLNode2.sqlPrecision = 10;
                        sQLNode2.sqlScale = 0;
                    } else {
                        sQLNode2.sqlDataType = n9;
                        sQLNode2.sqlSqlType = n8;
                        sQLNode2.sqlPrecision = n7;
                        sQLNode2.sqlScale = n6;
                        if (n9 == 8 && n == 12) {
                            sQLNode2.sqlSqlType = 12;
                            sQLNode2.sqlPrecision = 255;
                        }
                    }
                    if (n9 == 9 && n == 12) {
                        if (sQLNode3 != null) {
                            sQLNode3.sqlDataType = 9;
                            sQLNode3.sqlSqlType = 91;
                            sQLNode3.sqlPrecision = 10;
                            sQLNode3.sqlScale = 0;
                        }
                    } else if (n9 == 9 && n == 13) {
                        if (sQLNode3 != null) {
                            sQLNode3.sqlDataType = 3;
                            sQLNode3.sqlSqlType = 4;
                            sQLNode3.sqlPrecision = 10;
                            sQLNode3.sqlScale = 0;
                        }
                    } else if (sQLNode3 != null) {
                        sQLNode3.sqlDataType = sQLNode2.sqlDataType;
                        sQLNode3.sqlSqlType = sQLNode2.sqlSqlType;
                        sQLNode3.sqlPrecision = sQLNode2.sqlPrecision;
                        sQLNode3.sqlScale = sQLNode2.sqlScale;
                    }
                    break block228;
                }
                if (!(n9 == n5 || n9 == 6 && n5 == 7 || n9 == 6 && n5 == 3 || n9 == 7 && n5 == 6 || n9 == 7 && n5 == 3 || n9 == 3 && n5 == 6) && (n9 != 3 || n5 != 7)) break block230;
                if (n9 == 8) {
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            break;
                        }
                        case 11: {
                            lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                            return 1023;
                        }
                        case 12: {
                            if (n4 != -1 && n8 != -1) break;
                            lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                            return 1023;
                        }
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                            return 1023;
                        }
                    }
                } else if (n9 == 9) {
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                            return 1023;
                        }
                        case 13: {
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                            return 1023;
                        }
                    }
                }
                int n10 = n9 == 7 && n5 == 6 ? 6 : (n9 == 3 && n5 == 6 ? 6 : (n9 == 3 && n5 == 7 ? 7 : n9));
                if (sQLNode3 != null) {
                    sQLNode3.sqlDataType = n10;
                }
                switch (n8) {
                    case 8: {
                        switch (n4) {
                            case 8: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                }
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlPrecision = n3;
                                }
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n8;
                                }
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlPrecision = n7;
                                }
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 12: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case 6: {
                        switch (n4) {
                            case 6: 
                            case 8: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                }
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlPrecision = n3;
                                }
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 7: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n8;
                                    sQLNode3.sqlPrecision = n7;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 12: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case 7: {
                        switch (n4) {
                            case 6: 
                            case 7: 
                            case 8: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n8;
                                    sQLNode3.sqlPrecision = n7;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 12: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        switch (n4) {
                            case 6: 
                            case 7: 
                            case 8: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                int n11 = n4 == 3 || n8 == 3 ? 3 : (n4 == 2 || n8 == 2 ? 2 : (n4 == -5 || n8 == -5 ? -5 : (n4 == 4 || n8 == 4 ? 4 : (n4 == 5 || n8 == 5 ? 5 : (n4 == -6 || n8 == -6 ? -6 : -7)))));
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n11;
                                }
                                switch (n) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: {
                                        if (sQLNode3 == null) break;
                                        sQLNode3.sqlPrecision = n7;
                                        sQLNode3.sqlScale = n6;
                                        break;
                                    }
                                    case 9: 
                                    case 10: {
                                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                        return 1023;
                                    }
                                    case 11: {
                                        if (sQLNode3 == null) break;
                                        sQLNode3.sqlPrecision = n7;
                                        sQLNode3.sqlScale = n6;
                                        break;
                                    }
                                    case 12: 
                                    case 13: {
                                        int n12;
                                        int n13 = n2 > n6 ? n2 : n6;
                                        switch (n11) {
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                return 1019;
                                            }
                                            case -5: 
                                            case 2: 
                                            case 3: {
                                                if (n3 - n2 > n7 - n6) {
                                                    n12 = n13 + (n3 - n2) + 1;
                                                    break;
                                                }
                                                n12 = n13 + (n7 - n6) + 1;
                                                break;
                                            }
                                            case 4: {
                                                n12 = 10;
                                                break;
                                            }
                                            case 5: {
                                                n12 = 5;
                                                break;
                                            }
                                            case -6: {
                                                n12 = 3;
                                                break;
                                            }
                                            case -7: {
                                                n12 = 1;
                                                break;
                                            }
                                            case -4: 
                                            case -3: 
                                            case -2: 
                                            case -1: 
                                            case 1: 
                                            case 12: 
                                            case 91: 
                                            case 92: 
                                            case 93: {
                                                return 1019;
                                            }
                                            default: {
                                                return 1003;
                                            }
                                        }
                                        if (sQLNode3 == null) break;
                                        sQLNode3.sqlPrecision = n12;
                                        sQLNode3.sqlScale = n13;
                                        break;
                                    }
                                    case 14: 
                                    case 15: {
                                        int n14;
                                        int n15 = n2 + n6;
                                        switch (n11) {
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                return 1019;
                                            }
                                            case -5: 
                                            case 2: 
                                            case 3: {
                                                n14 = n15 + (n3 - n2) + (n7 - n6);
                                                break;
                                            }
                                            case 4: {
                                                n14 = 10;
                                                break;
                                            }
                                            case 5: {
                                                n14 = 5;
                                                break;
                                            }
                                            case -6: {
                                                n14 = 3;
                                                break;
                                            }
                                            case -7: {
                                                n14 = 1;
                                                break;
                                            }
                                            case -4: 
                                            case -3: 
                                            case -2: 
                                            case -1: 
                                            case 1: 
                                            case 12: 
                                            case 91: 
                                            case 92: 
                                            case 93: {
                                                return 1019;
                                            }
                                            default: {
                                                return 1003;
                                            }
                                        }
                                        if (sQLNode3 == null) break;
                                        sQLNode3.sqlPrecision = n14;
                                        sQLNode3.sqlScale = n15;
                                        break;
                                    }
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 19: {
                                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                        return 1023;
                                    }
                                }
                                break block228;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 12: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case -1: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                return 1019;
                            }
                            case -1: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case 1: 
                            case 12: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n8;
                                    sQLNode3.sqlPrecision = n7 > n3 ? n7 : n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case 12: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                return 1019;
                            }
                            case -1: 
                            case 12: {
                                if (sQLNode3 == null) break;
                                sQLNode3.sqlSqlType = n4;
                                sQLNode3.sqlPrecision = n3;
                                sQLNode3.sqlScale = -1;
                                break;
                            }
                            case 1: {
                                if (sQLNode3 == null) break;
                                sQLNode3.sqlSqlType = n8;
                                sQLNode3.sqlPrecision = n7;
                                sQLNode3.sqlScale = -1;
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                        if (n == 12 && sQLNode3 != null) {
                            sQLNode3.sqlPrecision = n3 + n7 < 255 ? n3 + n7 : 255;
                        }
                        break block228;
                    }
                    case 1: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                return 1019;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                if (sQLNode3 == null) break;
                                sQLNode3.sqlSqlType = n4;
                                sQLNode3.sqlPrecision = n3;
                                sQLNode3.sqlScale = -1;
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                        if (n == 12 && sQLNode3 != null) {
                            sQLNode3.sqlPrecision = n3 + n7 < 255 ? n3 + n7 : 255;
                        }
                        break block228;
                    }
                    case -4: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: {
                                return 1019;
                            }
                            case -4: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -3: 
                            case -2: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n8;
                                    sQLNode3.sqlPrecision = n7;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case -3: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: {
                                return 1019;
                            }
                            case -4: 
                            case -3: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case -2: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n8;
                                    sQLNode3.sqlPrecision = n7;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case -2: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: {
                                return 1019;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case 91: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: {
                                return 1019;
                            }
                            case 91: {
                                switch (n) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: {
                                        if (sQLNode3 == null) break;
                                        sQLNode3.sqlSqlType = n8;
                                        sQLNode3.sqlPrecision = n7;
                                        sQLNode3.sqlScale = n6;
                                        break;
                                    }
                                    case 9: 
                                    case 10: 
                                    case 11: 
                                    case 12: {
                                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                        return 1023;
                                    }
                                    case 13: {
                                        if (sQLNode3 == null) break;
                                        sQLNode3.sqlDataType = 3;
                                        sQLNode3.sqlPrecision = 10;
                                        sQLNode3.sqlSqlType = 4;
                                        sQLNode3.sqlScale = 0;
                                        break;
                                    }
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 19: {
                                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                                        return 1023;
                                    }
                                }
                                break block228;
                            }
                            case 92: 
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case 92: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: 
                            case 91: {
                                return 1019;
                            }
                            case 92: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = -1;
                                }
                                break block228;
                            }
                            case 93: {
                                return 1019;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    case 93: {
                        switch (n4) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: 
                            case 91: 
                            case 92: {
                                return 1019;
                            }
                            case 93: {
                                if (sQLNode3 != null) {
                                    sQLNode3.sqlSqlType = n4;
                                    sQLNode3.sqlPrecision = n3;
                                    sQLNode3.sqlScale = 3;
                                }
                                break block228;
                            }
                            default: {
                                return 1003;
                            }
                        }
                    }
                    default: {
                        return 1003;
                    }
                }
            }
            if (n9 == 9 && (n5 == 6 || n5 == 7 || n5 == 3)) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                        return 1023;
                    }
                    case 12: 
                    case 13: {
                        if (sQLNode3 == null) break;
                        sQLNode3.sqlDataType = n9;
                        sQLNode3.sqlSqlType = n8;
                        sQLNode3.sqlPrecision = n7;
                        sQLNode3.sqlScale = n6;
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                        return 1023;
                    }
                }
            } else if (n5 == 9 && (n9 == 6 || n9 == 7 || n9 == 3)) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                        return 1023;
                    }
                    case 12: {
                        if (sQLNode3 == null) break;
                        sQLNode3.sqlDataType = n5;
                        sQLNode3.sqlSqlType = n4;
                        sQLNode3.sqlPrecision = n3;
                        sQLNode3.sqlScale = n2;
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                        return 1023;
                    }
                }
            } else {
                lDAPStatement.setErrorMsg(Semantic.ErrorOpCode(n));
                return 1023;
            }
        }
        return 0;
    }
}

