/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Value;
import java.math.BigDecimal;
import java.sql.SQLException;

class ValueBoolean
extends Value
implements LDAPSQLExceptionCodes {
    public static final ValueBoolean TRUE = new ValueBoolean(true);
    public static final ValueBoolean FALSE = new ValueBoolean(false);
    boolean m_value;

    public ValueBoolean(boolean bl) {
        super(-7);
        this.m_value = bl;
    }

    public void setValue(Value value) throws SQLException {
        this.m_value = value.getBoolean();
    }

    public int compare(Value value) throws SQLException {
        if (value.m_javaType != -7) {
            throw Errors.sqlException(22);
        }
        if (this.m_value == ((ValueBoolean)value).m_value) {
            return 0;
        }
        if (!this.m_value) {
            return -1;
        }
        return 1;
    }

    public byte getByte() throws SQLException {
        if (this.m_value) {
            return 1;
        }
        return 0;
    }

    public short getShort() throws SQLException {
        if (this.m_value) {
            return 1;
        }
        return 0;
    }

    public int getInt() {
        if (this.m_value) {
            return 1;
        }
        return 0;
    }

    public long getLong() {
        if (this.m_value) {
            return 1L;
        }
        return 0L;
    }

    public float getFloat() {
        if (this.m_value) {
            return 1.0f;
        }
        return 0.0f;
    }

    public double getDouble() {
        if (this.m_value) {
            return 1.0;
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal() {
        if (this.m_value) {
            return new BigDecimal(1.0);
        }
        return new BigDecimal(0.0);
    }

    public boolean getBoolean() {
        return this.m_value;
    }

    public String getString() {
        if (this.m_value) {
            return "true";
        }
        return "false";
    }

    public Object getObject() {
        return new Boolean(this.m_value);
    }
}

