/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Value;
import java.math.BigDecimal;
import java.sql.SQLException;

class ValueDecimal
extends Value
implements LDAPSQLExceptionCodes {
    BigDecimal m_value;

    public ValueDecimal(BigDecimal bigDecimal) {
        super(3);
        this.m_value = bigDecimal;
    }

    public void setValue(BigDecimal bigDecimal) {
        this.m_value = bigDecimal;
    }

    public void setValue(Value value) throws SQLException {
        this.m_value = value.getBigDecimal();
    }

    public void negate() {
        this.m_value = this.m_value.negate();
    }

    public int compare(Value value) throws SQLException {
        if (value.m_javaType != 3) {
            throw Errors.sqlException(22);
        }
        return this.m_value.compareTo((BigDecimal)value.getObject());
    }

    public byte getByte() throws SQLException {
        int n = this.m_value.intValue();
        if (n <= 127 && n >= -128) {
            return (byte)n;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "byte");
    }

    public short getShort() throws SQLException {
        int n = this.m_value.intValue();
        if (n <= Short.MAX_VALUE && n >= Short.MIN_VALUE) {
            return (short)n;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "short");
    }

    public int getInt() {
        return this.m_value.intValue();
    }

    public long getLong() {
        return this.m_value.longValue();
    }

    public float getFloat() {
        return this.m_value.floatValue();
    }

    public double getDouble() {
        return this.m_value.doubleValue();
    }

    public BigDecimal getBigDecimal() {
        return this.m_value;
    }

    public boolean getBoolean() {
        return this.m_value.doubleValue() != 0.0;
    }

    public String getString() {
        return this.m_value.toString();
    }

    public Object getObject() {
        return this.m_value;
    }
}

