/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Value;
import java.math.BigDecimal;
import java.sql.SQLException;

class ValueDouble
extends Value
implements LDAPSQLExceptionCodes {
    double m_value;

    public ValueDouble(double d) {
        super(8);
        this.m_value = d;
    }

    public void setValue(double d) {
        this.m_value = d;
    }

    public void setValue(Value value) throws SQLException {
        this.m_value = value.getDouble();
    }

    public void negate() {
        this.m_value = -this.m_value;
    }

    public int compare(Value value) throws SQLException {
        if (value.m_javaType != 8) {
            throw Errors.sqlException(22);
        }
        if (this.m_value < ((ValueDouble)value).m_value) {
            return -1;
        }
        if (this.m_value > ((ValueDouble)value).m_value) {
            return 1;
        }
        return 0;
    }

    public byte getByte() throws SQLException {
        int n = (int)this.m_value;
        if (n <= 127 && n >= -128) {
            return (byte)n;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "byte");
    }

    public short getShort() throws SQLException {
        int n = (int)this.m_value;
        if (n <= Short.MAX_VALUE && n >= Short.MIN_VALUE) {
            return (short)n;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "short");
    }

    public int getInt() {
        return (int)this.m_value;
    }

    public long getLong() {
        return (long)this.m_value;
    }

    public float getFloat() {
        return (float)this.m_value;
    }

    public double getDouble() {
        return this.m_value;
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.m_value);
    }

    public boolean getBoolean() {
        return this.m_value != 0.0;
    }

    public String getString() {
        return String.valueOf(this.m_value);
    }

    public Object getObject() {
        return new Double(this.m_value);
    }
}

