/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Value;
import java.math.BigDecimal;
import java.sql.SQLException;

class ValueLong
extends Value
implements LDAPSQLExceptionCodes {
    int m_value;

    public ValueLong(int n) {
        super(-5);
        this.m_value = n;
    }

    public void setValue(int n) {
        this.m_value = n;
    }

    public void setValue(Value value) throws SQLException {
        this.m_value = value.getInt();
    }

    public void negate() {
        this.m_value = -this.m_value;
    }

    public int compare(Value value) throws SQLException {
        if (value.m_javaType != -5) {
            throw Errors.sqlException(22);
        }
        return this.m_value - ((ValueLong)value).m_value;
    }

    public byte getByte() throws SQLException {
        if (this.m_value <= 127 && this.m_value >= -128) {
            return (byte)this.m_value;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "byte");
    }

    public short getShort() throws SQLException {
        if (this.m_value <= Short.MAX_VALUE && this.m_value >= Short.MIN_VALUE) {
            return (short)this.m_value;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "short");
    }

    public int getInt() throws SQLException {
        if (this.m_value <= Integer.MAX_VALUE && this.m_value >= Integer.MIN_VALUE) {
            return (short)this.m_value;
        }
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "int");
    }

    public long getLong() {
        return this.m_value;
    }

    public float getFloat() {
        return this.m_value;
    }

    public double getDouble() {
        return this.m_value;
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal((double)this.m_value);
    }

    public boolean getBoolean() {
        return this.m_value != 0;
    }

    public String getString() {
        return String.valueOf(this.m_value);
    }

    public Object getObject() {
        return new Long(this.m_value);
    }
}

