/*
 * Decompiled with CFR 0.152.
 */
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class AttributeFrame
extends JFrame
implements ActionListener {
    private static int buttonHeight = 25;
    private static int buttonWidth = 100;
    private static int mainPaneHeight = 400;
    private static int mainPaneWidth = 500;
    JButton attrDefButton;
    JButton syntaxButton;
    JScrollPane treeScrollPane;
    JTree tree;
    DefaultMutableTreeNode rootNode;
    DirContext dirCtx;

    public AttributeFrame(ContextTreeNode contextTreeNode) {
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(mainPaneWidth, mainPaneHeight);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.attrDefButton = new JButton("AttrDef");
        this.attrDefButton.setToolTipText("Display the attribute definition for the selected attribute");
        this.attrDefButton.setSize(buttonWidth, buttonHeight);
        this.attrDefButton.addActionListener(this);
        jPanel.add(this.attrDefButton);
        this.syntaxButton = new JButton("Syntax");
        this.syntaxButton.setToolTipText("Display the syntax for the selected attribute");
        this.syntaxButton.addActionListener(this);
        this.syntaxButton.setSize(buttonWidth, buttonHeight);
        jPanel.add(this.syntaxButton);
        this.getContentPane().add((Component)jPanel, "North");
        this.treeScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.treeScrollPane, "Center");
        this.setDefaultCloseOperation(2);
        Cursor cursor = this.getCursor();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        this.dirCtx = (DirContext)contextTreeNode.getThisContext();
        this.rootNode = new DefaultMutableTreeNode(String.valueOf(contextTreeNode.toString()) + ": Attributes");
        try {
            int n = 0;
            OrderedMap orderedMap = new OrderedMap((BinaryPredicate)AttributeCompare.singleton);
            Attributes attributes = this.dirCtx.getAttributes("");
            Enumeration<Attribute> enumeration = attributes.getAll();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                orderedMap.add((Object)attribute.getID(), (Object)new AttributeTreeNode(this, attribute));
            }
            enumeration = orderedMap.elements();
            while (enumeration.hasMoreElements()) {
                AttributeTreeNode attributeTreeNode = (AttributeTreeNode)((Object)enumeration.nextElement());
                this.rootNode.insert(attributeTreeNode, n++);
            }
        }
        catch (NamingException namingException) {
            new MessageBox("Error", "Unable to list attributes for object:\n" + Util.getExceptionTrace(namingException)).show();
        }
        this.tree = new JTree(this.rootNode);
        this.treeScrollPane.getViewport().add(this.tree);
        ((Component)this).setCursor(cursor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.attrDefButton) {
            this.attrDefButton_Action(actionEvent);
            return;
        }
        if (object == this.syntaxButton) {
            this.syntaxButton_Action(actionEvent);
        }
    }

    void attrDefButton_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof AttributeTreeNode)) {
            new MessageBox("Error", "No attribute selected.").show();
            return;
        }
        Cursor cursor = this.getCursor();
        ((Component)this).setCursor(new Cursor(3));
        try {
            AttributeTreeNode attributeTreeNode = (AttributeTreeNode)object;
            Attribute attribute = (Attribute)attributeTreeNode.getUserObject();
            DirContext dirContext = attribute.getAttributeDefinition();
            ContextTreeNode contextTreeNode = new ContextTreeNode(null, "Attribute Definition");
            contextTreeNode.setThisContext(dirContext);
            AttributeFrame attributeFrame = new AttributeFrame(contextTreeNode);
            attributeFrame.setTitle("Attribute Definition");
            attributeFrame.rootNode.setUserObject(String.valueOf(attribute.getID()) + ": Attribute Definition");
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)attributeFrame).setLocation(point);
            attributeFrame.show();
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to get attribute definition:\n" + Util.getExceptionTrace(exception)).show();
        }
        ((Component)this).setCursor(cursor);
    }

    void syntaxButton_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof AttributeTreeNode)) {
            new MessageBox("Error", "No attribute selected.").show();
            return;
        }
        Cursor cursor = this.getCursor();
        ((Component)this).setCursor(new Cursor(3));
        try {
            AttributeTreeNode attributeTreeNode = (AttributeTreeNode)object;
            Attribute attribute = (Attribute)attributeTreeNode.getUserObject();
            DirContext dirContext = attribute.getAttributeSyntaxDefinition();
            ContextTreeNode contextTreeNode = new ContextTreeNode(null, "Attribute Syntax Definition");
            contextTreeNode.setThisContext(dirContext);
            AttributeFrame attributeFrame = new AttributeFrame(contextTreeNode);
            attributeFrame.setTitle("Attribute Syntax");
            attributeFrame.rootNode.setUserObject(String.valueOf(attribute.getID()) + ": Attribute Syntax Definition");
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)attributeFrame).setLocation(point);
            attributeFrame.show();
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to get attribute definition:\n" + Util.getExceptionTrace(exception)).show();
        }
        ((Component)this).setCursor(cursor);
    }
}

