/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultTreeModel;

public class ContextFrame
extends JFrame
implements ActionListener,
MouseListener {
    private static int buttonHeight = 25;
    private static int buttonWidth = 100;
    private static int mainPaneHeight = 400;
    private static int mainPaneWidth = 500;
    private JMenuBar mainMenuBar;
    private JMenu fileMenu;
    private JMenuItem exitMenuItem;
    private JMenu viewMenu;
    private JMenuItem lookupMenuItem;
    private JMenuItem searchMenuItem;
    private JCheckBoxMenuItem showClassesMenuItem;
    private JMenuItem refreshMenuItem;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JButton lookupButton;
    private JButton attributeButton;
    private JScrollPane treeScrollPane;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JLabel statusLabel;
    private JPopupMenu popup;
    private JMenuItem lookupPopupMenuItem;
    private JMenuItem attributePopupMenuItem;
    private JMenuItem schemaPopupMenuItem;
    private JMenuItem classDefPopupMenuItem;
    private JMenuItem renamePopupMenuItem;
    private ContextTreeNode rootNode;
    private boolean isRoot = false;

    public ContextFrame(ContextTreeNode contextTreeNode) {
        super("Context Browser");
        this.rootNode = contextTreeNode;
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(mainPaneWidth, mainPaneHeight);
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.viewMenu = new JMenu("View");
        this.lookupMenuItem = new JMenuItem("Lookup");
        this.lookupMenuItem.addActionListener(this);
        this.viewMenu.add(this.lookupMenuItem);
        this.searchMenuItem = new JMenuItem("Search");
        this.searchMenuItem.addActionListener(this);
        this.viewMenu.add(this.searchMenuItem);
        this.showClassesMenuItem = new JCheckBoxMenuItem("Show classes", ContextTreeNode.showClasses);
        this.showClassesMenuItem.addActionListener(this);
        this.viewMenu.add(this.showClassesMenuItem);
        this.refreshMenuItem = new JMenuItem("Refresh");
        this.refreshMenuItem.addActionListener(this);
        this.viewMenu.add(this.refreshMenuItem);
        this.mainMenuBar.add(this.viewMenu);
        this.helpMenu = new JMenu("Help");
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.addActionListener(this);
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        this.attributePopupMenuItem = new JMenuItem("Attribute");
        this.attributePopupMenuItem.addActionListener(this);
        this.classDefPopupMenuItem = new JMenuItem("ClassDef");
        this.classDefPopupMenuItem.addActionListener(this);
        this.lookupPopupMenuItem = new JMenuItem("Lookup");
        this.lookupPopupMenuItem.addActionListener(this);
        this.renamePopupMenuItem = new JMenuItem("Rename");
        this.renamePopupMenuItem.addActionListener(this);
        this.schemaPopupMenuItem = new JMenuItem("Schema");
        this.schemaPopupMenuItem.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.attributeButton = new JButton("Attribute");
        this.attributeButton.setToolTipText("Display attributes for an object");
        this.attributeButton.addActionListener(this);
        this.attributeButton.setSize(buttonWidth, buttonHeight);
        jPanel.add(this.attributeButton);
        this.lookupButton = new JButton("Lookup");
        this.lookupButton.setToolTipText("Lookup the selected object");
        this.lookupButton.setSize(buttonWidth, buttonHeight);
        this.lookupButton.addActionListener(this);
        jPanel.add(this.lookupButton);
        this.getContentPane().add((Component)jPanel, "North");
        this.treeScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.treeScrollPane, "Center");
        contextTreeNode.setContextFrame(this);
        this.treeModel = new DefaultTreeModel(contextTreeNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(true);
        this.treeScrollPane.getViewport().add(this.tree);
        this.tree.addMouseListener(this);
        this.statusLabel = new JLabel();
        this.statusLabel.setToolTipText("Status");
        this.statusLabel.setBorder(new EtchedBorder(1));
        this.statusLabel.setSize(mainPaneWidth, buttonHeight);
        this.getContentPane().add((Component)this.statusLabel, "South");
        this.setDefaultCloseOperation(2);
    }

    public String setStatusLabel(String string) {
        String string2 = this.statusLabel.getText();
        this.statusLabel.setText(string);
        return string2;
    }

    public void setRootFlag(boolean bl) {
        this.isRoot = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.attributeButton || object == this.attributePopupMenuItem) {
            this.attributeButton_Action(actionEvent);
            return;
        }
        if (object == this.classDefPopupMenuItem) {
            this.classDefMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.lookupButton || object == this.lookupPopupMenuItem) {
            this.lookupButton_Action(actionEvent);
            return;
        }
        if (object == this.renamePopupMenuItem) {
            this.renameMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.schemaPopupMenuItem) {
            this.schemaMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.exitMenuItem) {
            this.dispose();
            return;
        }
        if (object == this.lookupMenuItem) {
            this.lookupMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.searchMenuItem) {
            this.searchMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.showClassesMenuItem) {
            this.showClassesMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.refreshMenuItem) {
            this.refreshMenuItem_Action(actionEvent);
            return;
        }
        if (object == this.aboutMenuItem) {
            this.aboutMenuItem_Action(actionEvent);
        }
    }

    void attributeButton_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof ContextTreeNode)) {
            new MessageBox("Error", "No item selected.").show();
            return;
        }
        try {
            ContextTreeNode contextTreeNode = (ContextTreeNode)object;
            DirContext dirContext = (DirContext)contextTreeNode.getThisContext();
            if (dirContext == null) {
                throw new Exception("Root node");
            }
            AttributeFrame attributeFrame = new AttributeFrame(contextTreeNode);
            attributeFrame.setTitle("Attributes");
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)attributeFrame).setLocation(point);
            attributeFrame.show();
            return;
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to get attributes for object:\n" + Util.getExceptionTrace(exception)).show();
            return;
        }
    }

    void classDefMenuItem_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof ContextTreeNode)) {
            new MessageBox("Error", "No item selected.").show();
            return;
        }
        try {
            ContextTreeNode contextTreeNode = (ContextTreeNode)object;
            DirContext dirContext = (DirContext)contextTreeNode.getThisContext();
            if (dirContext == null) {
                throw new Exception("Root node");
            }
            dirContext = dirContext.getSchemaClassDefinition("");
            contextTreeNode = new ContextTreeNode(null, dirContext);
            ContextFrame contextFrame = new ContextFrame(contextTreeNode);
            contextFrame.setTitle("Class Definition");
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)contextFrame).setLocation(point);
            contextFrame.show();
            return;
        }
        catch (ClassCastException classCastException) {
            new MessageBox("Error", "Object selected is not a DirContext:\n" + Util.getExceptionTrace(classCastException)).show();
            return;
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to get schema for object:\n" + Util.getExceptionTrace(exception)).show();
            return;
        }
    }

    void lookupButton_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof ContextTreeNode)) {
            new MessageBox("Error", "No context selected.").show();
            return;
        }
        Cursor cursor = this.getCursor();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        try {
            ContextTreeNode contextTreeNode = (ContextTreeNode)object;
            Context context = contextTreeNode.getThisContext();
            if (context == null) {
                throw new Exception("Root node");
            }
            NameClassPair nameClassPair = (NameClassPair)contextTreeNode.getUserObject();
            ContextTreeNode contextTreeNode2 = new ContextTreeNode(null, nameClassPair);
            contextTreeNode2.setThisContext(context);
            ContextFrame contextFrame = new ContextFrame(contextTreeNode2);
            contextFrame.setStatusLabel("Context: " + nameClassPair.getName());
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)contextFrame).setLocation(point);
            contextFrame.show();
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to lookup item:\n" + Util.getExceptionTrace(exception)).show();
        }
        ((Component)this).setCursor(cursor);
    }

    void renameMenuItem_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof ContextTreeNode)) {
            new MessageBox("Error", "No context selected.").show();
            return;
        }
        try {
            ContextTreeNode contextTreeNode = (ContextTreeNode)object;
            Context context = contextTreeNode.getParentContext();
            if (context == null) {
                throw new Exception("No parent context");
            }
            NameClassPair nameClassPair = (NameClassPair)contextTreeNode.getUserObject();
            RenameFrame renameFrame = new RenameFrame(this, nameClassPair.getName());
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)renameFrame).setLocation(point);
            renameFrame.show();
            String string = renameFrame.getText();
            renameFrame.dispose();
            if (string != null) {
                context.rename(nameClassPair.getName(), string);
                this.refreshMenuItem_Action(null);
                return;
            }
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to rename object:\n" + Util.getExceptionTrace(exception)).show();
        }
    }

    void schemaMenuItem_Action(ActionEvent actionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof ContextTreeNode)) {
            new MessageBox("Error", "No item selected.").show();
            return;
        }
        try {
            ContextTreeNode contextTreeNode = (ContextTreeNode)object;
            DirContext dirContext = (DirContext)contextTreeNode.getThisContext();
            if (dirContext == null) {
                throw new Exception("Root node");
            }
            dirContext = dirContext.getSchema("");
            contextTreeNode = new ContextTreeNode(null, dirContext);
            ContextFrame contextFrame = new ContextFrame(contextTreeNode);
            contextFrame.setTitle("Schema");
            Point point = this.getLocation();
            point.translate(buttonHeight, buttonHeight);
            ((Component)contextFrame).setLocation(point);
            contextFrame.show();
            return;
        }
        catch (ClassCastException classCastException) {
            new MessageBox("Error", "Object selected is not a DirContext:\n" + Util.getExceptionTrace(classCastException)).show();
            return;
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to get schema for object:\n" + Util.getExceptionTrace(exception)).show();
            return;
        }
    }

    public void lookupMenuItem_Action(ActionEvent actionEvent) {
        LookupFrame lookupFrame = new LookupFrame(this);
        lookupFrame.show();
        String string = lookupFrame.getText();
        lookupFrame.dispose();
        if (string != null) {
            try {
                Context context = this.rootNode.getThisContext();
                Object object = context.lookup(string);
                if (object instanceof Context) {
                    ContextTreeNode contextTreeNode = new ContextTreeNode(null, (Context)object);
                    ContextFrame contextFrame = new ContextFrame(contextTreeNode);
                    contextFrame.setStatusLabel("Context: " + string);
                    Point point = this.getLocation();
                    point.translate(buttonHeight, buttonHeight);
                    ((Component)contextFrame).setLocation(point);
                    contextFrame.show();
                    return;
                }
                new MessageBox("Lookup", "Found non-context object:\n" + object.toString()).show();
                return;
            }
            catch (NamingException namingException) {
                new MessageBox("Error", "Unable to lookup object:\n" + Util.getExceptionTrace(namingException)).show();
                return;
            }
        }
    }

    public void searchMenuItem_Action(ActionEvent actionEvent) {
        SearchFrame searchFrame = new SearchFrame(this);
        searchFrame.show();
        String string = searchFrame.getText();
        searchFrame.dispose();
        if (string != null) {
            try {
                DirContext dirContext = (DirContext)this.rootNode.getThisContext();
                SearchControls searchControls = new SearchControls(1, 0L, 0, new String[0], false, false);
                NamingEnumeration<SearchResult> namingEnumeration = dirContext.search("", string, searchControls);
                SearchTreeNode searchTreeNode = new SearchTreeNode(null, dirContext, namingEnumeration);
                ContextFrame contextFrame = new ContextFrame(searchTreeNode);
                contextFrame.setStatusLabel("Search: " + string);
                contextFrame.setTitle("Search Result");
                Point point = this.getLocation();
                point.translate(buttonHeight, buttonHeight);
                ((Component)contextFrame).setLocation(point);
                contextFrame.show();
                return;
            }
            catch (ClassCastException classCastException) {
                new MessageBox("Error", "Root object is not a DirContext:\n" + Util.getExceptionTrace(classCastException)).show();
                return;
            }
            catch (NamingException namingException) {
                new MessageBox("Error", "Unable to perform search:\n" + Util.getExceptionTrace(namingException)).show();
                return;
            }
        }
    }

    public void showClassesMenuItem_Action(ActionEvent actionEvent) {
        ContextTreeNode.showClasses = !ContextTreeNode.showClasses;
        this.refreshMenuItem_Action(actionEvent);
    }

    public void refreshMenuItem_Action(ActionEvent actionEvent) {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void aboutMenuItem_Action(ActionEvent actionEvent) {
        AboutFrame aboutFrame = AboutFrame.getAboutFrame(null);
        Point point = this.getLocation();
        point.translate(buttonHeight, buttonHeight);
        ((Component)aboutFrame).setLocation(point);
        aboutFrame.show();
    }

    public void dispose() {
        try {
            super.dispose();
            if (this.isRoot) {
                System.exit(0);
                return;
            }
        }
        catch (Throwable throwable) {}
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        Component component;
        if (mouseEvent.isPopupTrigger() && (component = mouseEvent.getComponent()) == this.tree) {
            Object object = this.tree.getLastSelectedPathComponent();
            if (object == null) {
                return;
            }
            this.popup = new JPopupMenu();
            this.popup.add(this.attributePopupMenuItem);
            this.popup.add(this.classDefPopupMenuItem);
            this.popup.add(this.lookupPopupMenuItem);
            this.popup.add(this.renamePopupMenuItem);
            this.popup.add(this.schemaPopupMenuItem);
            if (NJCLApplet.popupHandlers != null) {
                this.popup.addSeparator();
                int n = 0;
                while (n < NJCLApplet.popupHandlers.length) {
                    NJCLApplet.popupHandlers[n].popupRequested(this, this.popup, object);
                    ++n;
                }
            }
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

