/*
 * Decompiled with CFR 0.152.
 */
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.OrderedMap;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContextTreeNode
extends DefaultMutableTreeNode {
    boolean hasLoaded = false;
    boolean isLeaf = false;
    Context thisContext;
    ContextFrame frame;
    static boolean showClasses;

    public ContextTreeNode(ContextFrame contextFrame, Object object) {
        super(object);
        this.frame = contextFrame;
    }

    public ContextTreeNode(ContextFrame contextFrame, Context context) {
        super(null);
        this.thisContext = context;
        this.frame = contextFrame;
    }

    public void setThisContext(Context context) {
        this.thisContext = context;
    }

    public void setContextFrame(ContextFrame contextFrame) {
        this.frame = contextFrame;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public int getChildCount() {
        if (!this.hasLoaded && !this.isLeaf) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.hasLoaded = false;
        this.isLeaf = false;
    }

    public String toString() {
        if (this.userObject != null && this.userObject instanceof NameClassPair) {
            NameClassPair nameClassPair = (NameClassPair)this.userObject;
            if (showClasses) {
                return String.valueOf(nameClassPair.getName()) + " :: " + this.getThisContext().getClass().getName();
            }
            return nameClassPair.getName();
        }
        return super.toString();
    }

    public Context getThisContext() {
        if (this.thisContext == null) {
            Object object;
            try {
                object = ((ContextTreeNode)this.parent).thisContext.lookup(((NameClassPair)this.userObject).getName());
            }
            catch (NameNotFoundException nameNotFoundException) {
                try {
                    object = ((ContextTreeNode)this.parent).thisContext.lookup("/" + ((NameClassPair)this.userObject).getName());
                }
                catch (NamingException namingException) {
                    new MessageBox("Error", "Unable to lookup this object:\n" + Util.getExceptionTrace(namingException)).show();
                    return null;
                }
            }
            catch (NamingException namingException) {
                new MessageBox("Error", "Unable to lookup this object:\n" + Util.getExceptionTrace(namingException)).show();
                return null;
            }
            if (object instanceof Context) {
                this.thisContext = (Context)object;
            }
        }
        return this.thisContext;
    }

    public NameClassPair getNameClassPair() {
        return (NameClassPair)this.getUserObject();
    }

    public Context getParentContext() {
        if (this.parent != null) {
            return ((ContextTreeNode)this.parent).getThisContext();
        }
        return null;
    }

    void loadChildren() {
        Cursor cursor = this.frame.getCursor();
        ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(3));
        if (this.getThisContext() == null) {
            this.isLeaf = true;
            ((Component)this.frame).setCursor(cursor);
            return;
        }
        try {
            ContextTreeNode contextTreeNode;
            NameClassPair nameClassPair;
            OrderedMap orderedMap = new OrderedMap((BinaryPredicate)NameClassCompare.singleton);
            Enumeration<NameClassPair> enumeration = this.thisContext.list("");
            while (enumeration.hasMoreElements()) {
                nameClassPair = (NameClassPair)enumeration.nextElement();
                contextTreeNode = new ContextTreeNode(this.frame, nameClassPair);
                orderedMap.add((Object)nameClassPair.getName(), (Object)contextTreeNode);
            }
            try {
                enumeration = this.thisContext.list("/");
                while (enumeration.hasMoreElements()) {
                    nameClassPair = enumeration.nextElement();
                    contextTreeNode = new ContextTreeNode(this.frame, nameClassPair);
                    orderedMap.add((Object)nameClassPair.getName(), (Object)contextTreeNode);
                }
            }
            catch (NamingException namingException) {}
            enumeration = orderedMap.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                contextTreeNode = (ContextTreeNode)((Object)enumeration.nextElement());
                this.insert(contextTreeNode, n++);
            }
        }
        catch (NamingException namingException) {
            new MessageBox("Error", "Unable to load children for this context:\n" + Util.getExceptionTrace(namingException)).show();
        }
        ((Component)this.frame).setCursor(cursor);
        this.hasLoaded = true;
    }
}

