/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Lib;
import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestAddAttrContainer;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.ValueElementsParent;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSProductElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSReadAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSearchAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class CommonImpl
implements Constants {
    public static final String PRODUCT_NAME = "VRTest DirXML Driver";
    public static final String COMPANY_NAME = "Novell, Inc.";
    public static final String VERSION = "1.1";
    protected static final String TRACE_ID = "VRTest Driver";
    protected static final String DEFAULT_COUNT = "0";
    protected static final int COUNT_INCREMENT = 1;
    protected static final String TAG_TIME_STAMP = "time-stamp";
    protected static final String TAG_RUN_COUNT = "run-count";
    protected Map driverParams = null;
    protected String driverRDN = null;
    protected Trace trace = null;
    private long runCount = -1L;
    protected VRTestAPIWrapper api;
    protected boolean connected = false;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance();

    protected CommonImpl() {
    }

    protected void setDriverParams(Map map) {
        this.driverParams = map;
    }

    Map getDriverParams() {
        return this.driverParams;
    }

    protected void setDriverRDN(String string) {
        this.driverRDN = string;
    }

    protected String getDriverRDN() {
        return this.driverRDN == null ? TRACE_ID : this.driverRDN;
    }

    protected void setTrace(String string) {
        String string2 = string == null ? this.getDriverRDN() : this.getDriverRDN() + "\\" + string;
        this.trace = new Trace(string2);
    }

    protected void setRunCount(long l) {
        this.runCount = l + 1L;
    }

    protected long getRunCount() {
        return this.runCount;
    }

    protected void setAPI(VRTestAPIWrapper vRTestAPIWrapper) {
        Lib.CheckParam(vRTestAPIWrapper, "someAPI");
        this.api = vRTestAPIWrapper;
    }

    protected VRTestAPIWrapper getAPI() {
        return this.api;
    }

    protected void appendSourceInfo(WriteableDocument writeableDocument) {
        if (writeableDocument != null) {
            XDSSourceElement xDSSourceElement = writeableDocument.appendSourceElement();
            XDSProductElement xDSProductElement = xDSSourceElement.appendProductElement();
            xDSProductElement.setBuild("20030127_0314");
            xDSProductElement.setInstance(this.driverRDN);
            xDSProductElement.setVersion(VERSION);
            xDSProductElement.appendText(PRODUCT_NAME);
            xDSSourceElement.appendContactElement(COMPANY_NAME);
        }
    }

    protected XDSResultDocument newResultDoc() {
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        this.appendSourceInfo((WriteableDocument)xDSResultDocument);
        return xDSResultDocument;
    }

    protected XDSCommandDocument newCommandDoc() {
        XDSCommandDocument xDSCommandDocument = new XDSCommandDocument();
        this.appendSourceInfo((WriteableDocument)xDSCommandDocument);
        return xDSCommandDocument;
    }

    protected void connect() throws IOException, VRTestException {
        this.trace.trace("connect", 1);
        if (!this.connected) {
            Object object = this.api.connectMutex;
            synchronized (object) {
                if (this.api.badConnection()) {
                    if (this.api.connected()) {
                        this.api.resetConnection();
                    } else {
                        this.api.openConnection();
                    }
                }
            }
        }
    }

    protected void disconnect() {
        this.trace.trace("disconnect", 1);
        this.connected = false;
        if (this.api != null) {
            Object object = this.api.connectMutex;
            synchronized (object) {
                this.api.closeConnection();
            }
        }
    }

    protected String getConnectHeader() {
        if (this.connected) {
            return "Lost connection.";
        }
        return "Unable to connect.";
    }

    protected void queryHandler(XDSQueryElement xDSQueryElement, QueryResultDocument queryResultDocument) throws VRTestException, IOException {
        this.trace.trace("queryHandler", 1);
        if (xDSQueryElement == null) {
            return;
        }
        VRTestObject vRTestObject = this.getBaseObject(xDSQueryElement, queryResultDocument);
        if (vRTestObject == null) {
            return;
        }
        VRTestAttributeFilter vRTestAttributeFilter = this.getReadAttributeFilter(xDSQueryElement);
        if (xDSQueryElement.hasEntryScope()) {
            if (this.api.isRootObject(vRTestObject)) {
                return;
            }
            this.appendInstanceElement(queryResultDocument, vRTestObject, vRTestAttributeFilter);
        } else {
            List list = this.getSearchClasses(xDSQueryElement);
            VRTestAttributeFilter vRTestAttributeFilter2 = this.getSearchAttributeFilter(xDSQueryElement);
            if (this.api.getSchema().isHierarchical()) {
                if (xDSQueryElement.hasSubordinatesScope()) {
                    this.subordinateObjectsToXDS(queryResultDocument, vRTestObject, list, vRTestAttributeFilter2, vRTestAttributeFilter);
                } else {
                    this.subtreeObjectsToXDS(queryResultDocument, vRTestObject, list, vRTestAttributeFilter2, vRTestAttributeFilter);
                }
            } else {
                this.objectsToXDS(queryResultDocument, list, vRTestAttributeFilter2, vRTestAttributeFilter);
            }
        }
    }

    private VRTestObject getBaseObject(XDSQueryElement xDSQueryElement, QueryResultDocument queryResultDocument) throws VRTestException, IOException {
        String string = xDSQueryElement.extractAssociationText();
        if (string != null) {
            VRTestObject vRTestObject = this.api.getObjectByAssociation(string, null);
            return vRTestObject;
        }
        String string2 = xDSQueryElement.getDestDN();
        if (string2 != null) {
            return this.api.getObjectByDN(string2);
        }
        return this.api.getRootObject();
    }

    private VRTestAttributeFilter getReadAttributeFilter(XDSQueryElement xDSQueryElement) throws VRTestException {
        VRTestAttributeFilter vRTestAttributeFilter;
        if (xDSQueryElement.shouldReadAttributes()) {
            if (xDSQueryElement.containsReadAttrElements()) {
                vRTestAttributeFilter = new VRTestAttributeFilter();
                ListIterator listIterator = xDSQueryElement.extractReadAttrElements().listIterator();
                while (listIterator.hasNext()) {
                    XDSReadAttrElement xDSReadAttrElement = (XDSReadAttrElement)listIterator.next();
                    String string = xDSReadAttrElement.getAttrName();
                    vRTestAttributeFilter.addAttribute(string);
                }
            } else {
                vRTestAttributeFilter = VRTestAttributeFilter.ALL_ATTRIBUTES;
            }
        } else {
            vRTestAttributeFilter = VRTestAttributeFilter.NO_ATTRIBUTES;
        }
        return vRTestAttributeFilter;
    }

    private List getSearchClasses(XDSQueryElement xDSQueryElement) {
        if (xDSQueryElement.containsSearchClassElements()) {
            return xDSQueryElement.extractSearchClassElements();
        }
        return this.api.getSchema().getClassSchemas();
    }

    private VRTestAttributeFilter getSearchAttributeFilter(XDSQueryElement xDSQueryElement) throws VRTestException {
        VRTestAttributeFilter vRTestAttributeFilter;
        if (xDSQueryElement.containsSearchAttrElements()) {
            List list = xDSQueryElement.extractSearchAttrElements();
            ListIterator listIterator = list.listIterator();
            vRTestAttributeFilter = new VRTestAttributeFilter();
            while (listIterator.hasNext()) {
                XDSSearchAttrElement xDSSearchAttrElement = (XDSSearchAttrElement)listIterator.next();
                String string = xDSSearchAttrElement.getAttrName();
                CommonImpl.ToVRTestAttributes(vRTestAttributeFilter, (ValueElementsParent)xDSSearchAttrElement, string);
            }
        } else {
            vRTestAttributeFilter = VRTestAttributeFilter.NO_ATTRIBUTES;
        }
        return vRTestAttributeFilter;
    }

    private void objectsToXDS(QueryResultDocument queryResultDocument, List list, VRTestAttributeFilter vRTestAttributeFilter, VRTestAttributeFilter vRTestAttributeFilter2) throws VRTestException, IOException {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            List list2 = this.api.getMatchingObjects(e.toString(), vRTestAttributeFilter);
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                VRTestObject vRTestObject = (VRTestObject)listIterator2.next();
                this.appendInstanceElement(queryResultDocument, vRTestObject, vRTestAttributeFilter2);
            }
        }
    }

    private void subordinateObjectsToXDS(QueryResultDocument queryResultDocument, VRTestObject vRTestObject, List list, VRTestAttributeFilter vRTestAttributeFilter, VRTestAttributeFilter vRTestAttributeFilter2) throws VRTestException, IOException {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            List list2 = this.api.getMatchingObjects(e.toString(), vRTestAttributeFilter);
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                VRTestObject vRTestObject2 = (VRTestObject)listIterator2.next();
                if (!vRTestObject.isSubordinate(vRTestObject2)) continue;
                this.appendInstanceElement(queryResultDocument, vRTestObject2, vRTestAttributeFilter2);
            }
        }
    }

    private void subtreeObjectsToXDS(QueryResultDocument queryResultDocument, VRTestObject vRTestObject, List list, VRTestAttributeFilter vRTestAttributeFilter, VRTestAttributeFilter vRTestAttributeFilter2) throws VRTestException, IOException {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            List list2 = this.api.getMatchingObjects(e.toString(), vRTestAttributeFilter);
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                VRTestObject vRTestObject2 = (VRTestObject)listIterator2.next();
                if (!vRTestObject.inSubtree(vRTestObject2)) continue;
                this.appendInstanceElement(queryResultDocument, vRTestObject2, vRTestAttributeFilter2);
            }
        }
    }

    private void appendInstanceElement(QueryResultDocument queryResultDocument, VRTestObject vRTestObject, VRTestAttributeFilter vRTestAttributeFilter) throws VRTestException, IOException {
        XDSInstanceElement xDSInstanceElement = queryResultDocument.appendInstanceElement();
        xDSInstanceElement.setClassName(vRTestObject.getClassName());
        xDSInstanceElement.setSrcDN(vRTestObject.getDN());
        xDSInstanceElement.appendAssociationElement(vRTestObject.extractAssociationText());
        if (vRTestAttributeFilter != null) {
            this.appendAttrElements(xDSInstanceElement, vRTestObject.getAttributes(vRTestAttributeFilter));
        }
    }

    private void appendAttrElements(XDSInstanceElement xDSInstanceElement, List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            VRTestAttribute vRTestAttribute = (VRTestAttribute)listIterator.next();
            XDSAttrElement xDSAttrElement = xDSInstanceElement.appendAttrElement();
            xDSAttrElement.setAttrName(vRTestAttribute.getName());
            xDSAttrElement.appendValueElement(vRTestAttribute.getValue());
        }
    }

    protected static void ToVRTestAttributes(VRTestAddAttrContainer vRTestAddAttrContainer, ValueElementsParent valueElementsParent, String string) throws VRTestException {
        ListIterator listIterator = valueElementsParent.extractValueElements().listIterator();
        while (listIterator.hasNext()) {
            XDSValueElement xDSValueElement = (XDSValueElement)listIterator.next();
            vRTestAddAttrContainer.addAttribute(string, xDSValueElement.extractText());
        }
    }

    void appendStateInfo(StateParent stateParent) {
        Document document = stateParent.domDocument();
        Element element = stateParent.domElement();
        Element element2 = document.createElement(TAG_TIME_STAMP);
        Text text = document.createTextNode(this.dateFormat.format(new Date()));
        element2.appendChild(text);
        element.appendChild(element2);
        Element element3 = document.createElement(TAG_RUN_COUNT);
        text = document.createTextNode(String.valueOf(this.runCount));
        element3.appendChild(text);
        element.appendChild(element3);
    }
}

