/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestAddAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNParser;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNType;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifiedObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifyAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestNotification;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.vrtest.VRTestAPI;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestEvent;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class VRTestAPIWrapper
implements VRTestConstants {
    private int id;
    private int port;
    private String host;
    private boolean connected = false;
    private boolean bad = true;
    public final Object connectMutex;
    private boolean loopBack;
    private VRTestSchema schema;
    private VRTestAPI api;
    private VRTestRootObject root;
    private XmlQueryProcessor queryProcessor;
    private XDSCommandResultDocument associationDoc;

    VRTestAPIWrapper(String string, int n) {
        this.host = string;
        this.port = n;
        this.api = new VRTestAPI();
        this.root = new VRTestRootObject();
        this.loopBack = false;
        this.connectMutex = this.api.connectMutex;
        this.associationDoc = new XDSCommandResultDocument();
        XDSStatusElement xDSStatusElement = this.associationDoc.appendStatusElement();
        xDSStatusElement.setLevel(StatusLevel.WARNING);
        xDSStatusElement.appendText("Object missing required association.");
    }

    boolean connected() {
        return this.connected;
    }

    boolean badConnection() {
        return this.bad;
    }

    void setQueryProcessor(XmlQueryProcessor xmlQueryProcessor) throws VRTestException {
        this.queryProcessor = xmlQueryProcessor;
    }

    public void setLoopBack(boolean bl) {
        this.loopBack = bl;
    }

    public VRTestObject createObject(String string, VRTestAddAttributes vRTestAddAttributes) throws VRTestException, IOException {
        if (vRTestAddAttributes == null) {
            throw new IllegalArgumentException(Errors.nullParam("className"));
        }
        long l = this.api.create(string, vRTestAddAttributes.getList());
        VRTestObject vRTestObject = new VRTestObject(l, null, string, this);
        if (vRTestObject.extractAssociationText() == null) {
            throw new VRTestException("Object missing required association.");
        }
        return vRTestObject;
    }

    public void deleteObject(String string, String string2) throws VRTestException, IOException {
        VRTestObject vRTestObject = this.getObjectByAssociation(string, string2);
        if (vRTestObject == null) {
            return;
        }
        this.api.deleteByHandle(vRTestObject.getHandle());
    }

    public boolean isRootObject(VRTestObject vRTestObject) {
        return this.root == vRTestObject;
    }

    public VRTestRootObject getRootObject() {
        return this.root;
    }

    public List getMatchingObjects(String string, VRTestAttributeFilter vRTestAttributeFilter) throws VRTestException, IOException {
        VRTestAttributeList vRTestAttributeList = vRTestAttributeFilter == VRTestAttributeFilter.NO_ATTRIBUTES ? null : vRTestAttributeFilter.getList();
        LinkedList<VRTestObject> linkedList = new LinkedList<VRTestObject>();
        try {
            Object object = this.api.findMutex;
            synchronized (object) {
                long l = this.api.findFirst(string, vRTestAttributeList);
                while (l != 0L) {
                    VRTestObject vRTestObject = new VRTestObject(l, null, string, this);
                    linkedList.add(vRTestObject);
                    l = this.api.findNext();
                }
            }
            return linkedList;
        }
        catch (IOException iOException) {
            this.bad = true;
            throw iOException;
        }
    }

    public void modifyObject(VRTestObject vRTestObject, VRTestModifyAttributes vRTestModifyAttributes) throws VRTestException, IOException {
        if (vRTestObject == null) {
            throw new IllegalArgumentException(Errors.nullParam("object"));
        }
        if (vRTestModifyAttributes == null) {
            throw new IllegalArgumentException(Errors.nullParam("attributes"));
        }
        try {
            this.api.modifyByHandle(vRTestObject.getHandle(), vRTestModifyAttributes.getList());
            vRTestObject.resetAttributes();
        }
        catch (IOException iOException) {
            this.bad = true;
            throw iOException;
        }
    }

    public VRTestNotification waitForNotification(XmlCommandProcessor xmlCommandProcessor, Trace trace) throws VRTestException, IOException {
        if (xmlCommandProcessor == null) {
            throw new IllegalArgumentException(Errors.nullParam("processor"));
        }
        VRTestEvent vRTestEvent = null;
        VRTestModifiedObject vRTestModifiedObject = null;
        try {
            while (vRTestEvent == null) {
                vRTestEvent = this.api.waitForEvent();
                if (this.isLoopBack(vRTestEvent.getID())) {
                    trace.trace("Loopback event.");
                    vRTestEvent = null;
                    continue;
                }
                vRTestModifiedObject = new VRTestModifiedObject(vRTestEvent.getHandle(), null, vRTestEvent.getClassName(), vRTestEvent.getAttributes(), this);
                if (vRTestModifiedObject.extractAssociationText() != null) continue;
                xmlCommandProcessor.execute(this.associationDoc.toXML(), this.queryProcessor);
                vRTestEvent = null;
            }
        }
        catch (IOException iOException) {
            this.bad = true;
            throw iOException;
        }
        return new VRTestNotification(vRTestEvent.getType(), vRTestModifiedObject);
    }

    public VRTestSchema getSchema() {
        return this.schema;
    }

    public void openConnection() throws VRTestException, IOException {
        if (!this.connected) {
            this.api.startSession(this.host, this.port);
            this.id = this.api.getClientID();
            this.schema = this.api.getSchema();
            this.bad = false;
            this.connected = true;
        }
    }

    public void closeConnection() {
        this.connected = false;
        this.bad = true;
        this.api.endSession();
    }

    public void resetConnection() throws VRTestException, IOException {
        this.closeConnection();
        this.openConnection();
    }

    public VRTestObject getObjectByAssociation(String string, String string2) throws VRTestException, IOException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.nullParam("association"));
        }
        if (this.root.hasAssociation(string)) {
            return this.root;
        }
        VRTestAttributeFilter vRTestAttributeFilter = new VRTestAttributeFilter();
        vRTestAttributeFilter.addAttribute("Unique Id", string);
        try {
            return this.findObject(string2, vRTestAttributeFilter);
        }
        catch (IOException iOException) {
            this.bad = true;
            throw iOException;
        }
    }

    private VRTestObject findObject(String string, VRTestAttributeFilter vRTestAttributeFilter) throws VRTestException, IOException {
        long l = 0L;
        if (string != null) {
            Object object = this.api.findMutex;
            synchronized (object) {
                l = this.api.findFirst(string, vRTestAttributeFilter.getList());
            }
        }
        ListIterator listIterator = this.schema.getClassSchemas().listIterator();
        while (listIterator.hasNext()) {
            VRTestClassSchema vRTestClassSchema = (VRTestClassSchema)listIterator.next();
            Object object = this.api.findMutex;
            synchronized (object) {
                l = this.api.findFirst(vRTestClassSchema.toString(), vRTestAttributeFilter.getList());
            }
            if (l == 0L) continue;
            string = vRTestClassSchema.toString();
            break;
        }
        if (l == 0L) {
            return null;
        }
        return new VRTestObject(l, null, string, this);
    }

    public VRTestObject getObjectByDN(String string) throws VRTestException, IOException {
        if (this.root.hasDN(string)) {
            return this.root;
        }
        VRTestDNParser vRTestDNParser = new VRTestDNParser(string, VRTestDNType.VRTEST);
        try {
            return this.getObjectByNameANDPath(vRTestDNParser.getObjectName(), vRTestDNParser.getObjectPath());
        }
        catch (IOException iOException) {
            this.bad = true;
            throw iOException;
        }
    }

    VRTestObject getObjectByNameANDPath(String string, String string2) throws VRTestException, IOException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.nullParam("name"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(Errors.nullParam("path"));
        }
        try {
            return this.findObject(string, string2);
        }
        catch (IOException iOException) {
            this.bad = true;
            throw iOException;
        }
    }

    private VRTestObject findObject(String string, String string2) throws VRTestException, IOException {
        ListIterator listIterator = this.schema.getClassSchemas().listIterator();
        long l = 0L;
        VRTestAttributeFilter vRTestAttributeFilter = new VRTestAttributeFilter();
        VRTestClassSchema vRTestClassSchema = null;
        String string3 = null;
        while (listIterator.hasNext()) {
            vRTestClassSchema = (VRTestClassSchema)listIterator.next();
            VRTestAttributeSchema vRTestAttributeSchema = vRTestClassSchema.getNamingAttributeSchema();
            string3 = vRTestAttributeSchema.getName();
            vRTestAttributeFilter.addAttribute("Object Path", string2);
            vRTestAttributeFilter.addAttribute(string3, string);
            Object object = this.api.findMutex;
            synchronized (object) {
                l = this.api.findFirst(vRTestClassSchema.getName(), vRTestAttributeFilter.getList());
            }
            if (l != 0L) break;
            vRTestAttributeFilter.clear();
        }
        if (l == 0L) {
            return null;
        }
        return new VRTestObject(l, string, vRTestClassSchema.getName(), this);
    }

    VRTestAttributeList getAttributes(long l) throws VRTestException, IOException {
        return this.api.getAttributesByHandle(l);
    }

    private boolean isLoopBack(long l) {
        return !this.loopBack && (long)this.id == l;
    }
}

