/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNType;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;

class VRTestDNParser
implements VRTestConstants,
Constants {
    private String name;
    private String path;

    VRTestDNParser(String string, VRTestDNType vRTestDNType) throws VRTestException {
        this.parseObjectNameANDPath(string, vRTestDNType);
    }

    private void parseObjectNameANDPath(String string, VRTestDNType vRTestDNType) throws VRTestException {
        this.path = VRTestDNParser.ParseObjectPath(string, vRTestDNType);
        this.name = string.substring(this.path.length(), string.length());
    }

    static String ParseObjectPath(String string, VRTestDNType vRTestDNType) throws VRTestException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.nullParam("dn"));
        }
        if (vRTestDNType == null) {
            throw new IllegalArgumentException(Errors.nullParam("type"));
        }
        int n = vRTestDNType == VRTestDNType.VRTEST ? 0 : 1;
        int n2 = string.indexOf(92, n);
        int n3 = string.lastIndexOf(92) + 1;
        if (n2 == -1 || n3 == -1 || n3 < n2) {
            throw new VRTestException(Errors.badDN(string));
        }
        return string.substring(n2, n3);
    }

    String getObjectName() {
        return this.name;
    }

    String getObjectPath() {
        return this.path;
    }
}

